/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.BlockProxy;
import cpw.mods.fml.common.registry.BlockTracker;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;

public class GameRegistry {
    private static Multimap<ModContainer, BlockProxy> blockRegistry = ArrayListMultimap.create();
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<ICraftingHandler> craftingHandlers = Lists.newArrayList();
    private static List<IPickupNotifier> pickupHandlers = Lists.newArrayList();
    private static List<IPlayerTracker> playerTrackers = Lists.newArrayList();

    public static void registerWorldGenerator(IWorldGenerator generator) {
        worldGenerators.add(generator);
    }

    public static void generateWorld(int chunkX, int chunkZ, aab world, abt chunkGenerator, abt chunkProvider) {
        long worldSeed = world.G();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        fmlRandom.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed);
        for (IWorldGenerator generator : worldGenerators) {
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    public static Object buildBlock(ModContainer container, Class<?> type, Mod.Block annotation) throws Exception {
        Object o = type.getConstructor(Integer.TYPE).newInstance(GameRegistry.findSpareBlockId());
        GameRegistry.registerBlock((apa)o);
        return o;
    }

    private static int findSpareBlockId() {
        return BlockTracker.nextBlockId();
    }

    public static void registerItem(wk item, String name) {
        GameRegistry.registerItem(item, name, null);
    }

    public static void registerItem(wk item, String name, String modId) {
        GameData.setName(item, name, modId);
    }

    @Deprecated
    public static void registerBlock(apa block) {
        GameRegistry.registerBlock(block, xn.class);
    }

    public static void registerBlock(apa block, String name) {
        GameRegistry.registerBlock(block, xn.class, name);
    }

    @Deprecated
    public static void registerBlock(apa block, Class<? extends xn> itemclass) {
        GameRegistry.registerBlock(block, itemclass, null);
    }

    public static void registerBlock(apa block, Class<? extends xn> itemclass, String name) {
        GameRegistry.registerBlock(block, itemclass, name, null);
    }

    public static void registerBlock(apa block, Class<? extends xn> itemclass, String name, String modId) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            wk i;
            assert (block != null) : "registerBlock: block cannot be null";
            assert (itemclass != null) : "registerBlock: itemclass cannot be null";
            int blockItemId = block.cz - 256;
            try {
                Constructor<? extends xn> itemCtor = itemclass.getConstructor(Integer.TYPE);
                i = itemCtor.newInstance(blockItemId);
            }
            catch (NoSuchMethodException e) {
                Constructor<? extends xn> itemCtor = itemclass.getConstructor(Integer.TYPE, apa.class);
                i = itemCtor.newInstance(blockItemId, block);
            }
            GameRegistry.registerItem(i, name, modId);
        }
        catch (Exception e) {
            FMLLog.log(Level.SEVERE, e, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(e);
        }
        blockRegistry.put((Object)Loader.instance().activeModContainer(), (Object)((BlockProxy)((Object)block)));
    }

    public static void addRecipe(wm output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static ym addShapedRecipe(wm output, Object ... params) {
        return yk.a().a(output, params);
    }

    public static void addShapelessRecipe(wm output, Object ... params) {
        yk.a().b(output, params);
    }

    public static void addRecipe(ym recipe) {
        yk.a().b().add(recipe);
    }

    public static void addSmelting(int input, wm output, float xp2) {
        yg.a().a(input, output, xp2);
    }

    public static void registerTileEntity(Class<? extends aqp> tileEntityClass, String id) {
        aqp.a(tileEntityClass, id);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends aqp> tileEntityClass, String id, String ... alternatives) {
        aqp.a(tileEntityClass, id);
        Map teMappings = (Map)ObfuscationReflectionHelper.getPrivateValue(aqp.class, null, "field_70326_a", "nameToClassMap", "a");
        for (String s : alternatives) {
            if (teMappings.containsKey(s)) continue;
            teMappings.put(s, tileEntityClass);
        }
    }

    public static void addBiome(aav biome) {
        aal.b.addNewBiome(biome);
    }

    public static void removeBiome(aav biome) {
        aal.b.removeBiome(biome);
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(wm itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    public static void registerCraftingHandler(ICraftingHandler handler) {
        craftingHandlers.add(handler);
    }

    public static void onItemCrafted(sq player, wm item, lt craftMatrix) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onCrafting(player, item, craftMatrix);
        }
    }

    public static void onItemSmelted(sq player, wm item) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onSmelting(player, item);
        }
    }

    public static void registerPickupHandler(IPickupNotifier handler) {
        pickupHandlers.add(handler);
    }

    public static void onPickupNotification(sq player, rh item) {
        for (IPickupNotifier notify : pickupHandlers) {
            notify.notifyPickup(item, player);
        }
    }

    public static void registerPlayerTracker(IPlayerTracker tracker) {
        playerTrackers.add(tracker);
    }

    public static void onPlayerLogin(sq player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerLogin(player);
        }
    }

    public static void onPlayerLogout(sq player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerLogout(player);
        }
    }

    public static void onPlayerChangedDimension(sq player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerChangedDimension(player);
        }
    }

    public static void onPlayerRespawn(sq player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerRespawn(player);
        }
    }

    public static apa findBlock(String modId, String name) {
        return GameData.findBlock(modId, name);
    }

    public static wk findItem(String modId, String name) {
        return GameData.findItem(modId, name);
    }

    public static void registerCustomItemStack(String name, wm itemStack) {
        GameData.registerCustomItemStack(name, itemStack);
    }

    public static wm findItemStack(String modId, String name, int stackSize) {
        wm foundStack = GameData.findItemStack(modId, name);
        if (foundStack != null) {
            wm is2 = foundStack.m();
            is2.a = Math.min(stackSize, is2.e());
            return is2;
        }
        return null;
    }
}

