/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.MapDifference;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.UnsignedBytes;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLNetworkException;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;

public class ModIdMapPacket
extends FMLPacket {
    private byte[][] partials;

    public ModIdMapPacket() {
        super(FMLPacket.Type.MOD_IDMAP);
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        ca completeList = (ca)((Object)data[0]);
        bs wrap = new bs();
        wrap.a("List", (cf)completeList);
        try {
            return cc.a(wrap);
        }
        catch (Exception e) {
            FMLLog.log(Level.SEVERE, e, "A critical error writing the id map", new Object[0]);
            throw new FMLNetworkException(e);
        }
    }

    @Override
    public FMLPacket consumePacket(byte[] data) {
        ByteArrayDataInput bdi2 = ByteStreams.newDataInput((byte[])data);
        int chunkIdx = UnsignedBytes.toInt((byte)bdi2.readByte());
        int chunkTotal = UnsignedBytes.toInt((byte)bdi2.readByte());
        int chunkLength = bdi2.readInt();
        if (this.partials == null) {
            this.partials = new byte[chunkTotal][];
        }
        this.partials[chunkIdx] = new byte[chunkLength];
        bdi2.readFully(this.partials[chunkIdx]);
        for (int i = 0; i < this.partials.length; ++i) {
            if (this.partials[i] != null) continue;
            return null;
        }
        return this;
    }

    @Override
    public void execute(cg network, FMLNetworkHandler handler, ej netHandler, String userName) {
        byte[] allData = Bytes.concat((byte[][])this.partials);
        GameData.initializeServerGate(1);
        try {
            bs serverList = cc.a(allData);
            ca list = serverList.m("List");
            Set<ItemData> itemData = GameData.buildWorldItemData(list);
            GameData.validateWorldSave(itemData);
            MapDifference<Integer, ItemData> serverDifference = GameData.gateWorldLoadingForValidation();
            if (serverDifference != null) {
                FMLCommonHandler.instance().disconnectIDMismatch(serverDifference, netHandler, network);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

