/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import cpw.mods.fml.client.CustomModLoadingErrorDisplayException;
import cpw.mods.fml.client.GuiCustomModLoadingErrorScreen;
import cpw.mods.fml.client.GuiDupesFound;
import cpw.mods.fml.client.GuiIdMismatchScreen;
import cpw.mods.fml.client.GuiModsMissing;
import cpw.mods.fml.client.GuiModsMissingForServer;
import cpw.mods.fml.client.GuiSortingProblem;
import cpw.mods.fml.client.GuiWrongMinecraft;
import cpw.mods.fml.client.modloader.ModLoaderClientHelper;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.DuplicateModsFoundException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.WrongMinecraftVersionException;
import cpw.mods.fml.common.network.EntitySpawnAdjustmentPacket;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.network.ModMissingPacket;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.common.registry.ItemData;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.toposort.ModSortingException;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;

public class FMLClientHandler
implements IFMLSidedHandler {
    private static final FMLClientHandler INSTANCE = new FMLClientHandler();
    private Minecraft client;
    private DummyModContainer optifineContainer;
    private boolean guiLoaded;
    private boolean serverIsRunning;
    private MissingModsException modsMissing;
    private ModSortingException modSorting;
    private boolean loading;
    private WrongMinecraftVersionException wrongMC;
    private CustomModLoadingErrorDisplayException customError;
    private DuplicateModsFoundException dupesFound;
    private boolean serverShouldBeKilledQuietly;

    public void beginMinecraftLoading(Minecraft minecraft) {
        this.client = minecraft;
        if (minecraft.q()) {
            FMLLog.severe("DEMO MODE DETECTED, FML will not work. Finishing now.", new Object[0]);
            this.haltGame("FML will not run in demo mode", new RuntimeException());
            return;
        }
        this.loading = true;
        FMLCommonHandler.instance().beginLoading(this);
        new ModLoaderClientHelper(this.client);
        try {
            Class<?> optifineConfig = Class.forName("Config", false, Loader.instance().getModClassLoader());
            String optifineVersion = (String)optifineConfig.getField("VERSION").get(null);
            ImmutableMap dummyOptifineMeta = ImmutableMap.builder().put((Object)"name", (Object)"Optifine").put((Object)"version", (Object)optifineVersion).build();
            ModMetadata optifineMetadata = MetadataCollection.from(this.getClass().getResourceAsStream("optifinemod.info"), "optifine").getMetadataForId("optifine", (Map<String, Object>)dummyOptifineMeta);
            this.optifineContainer = new DummyModContainer(optifineMetadata);
            FMLLog.info("Forge Mod Loader has detected optifine %s, enabling compatibility features", this.optifineContainer.getVersion());
        }
        catch (Exception e) {
            this.optifineContainer = null;
        }
        try {
            Loader.instance().loadMods();
        }
        catch (WrongMinecraftVersionException wrong) {
            this.wrongMC = wrong;
        }
        catch (DuplicateModsFoundException dupes) {
            this.dupesFound = dupes;
        }
        catch (MissingModsException missing) {
            this.modsMissing = missing;
        }
        catch (ModSortingException sorting) {
            this.modSorting = sorting;
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.SEVERE, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
    }

    @Override
    public void haltGame(String message, Throwable t2) {
        this.client.c(new b(message, t2));
        throw Throwables.propagate((Throwable)t2);
    }

    public void finishMinecraftLoading() {
        if (this.modsMissing != null || this.wrongMC != null || this.customError != null || this.dupesFound != null || this.modSorting != null) {
            return;
        }
        try {
            Loader.instance().initializeMods();
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.SEVERE, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
            return;
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        LanguageRegistry.reloadLanguageTable();
        RenderingRegistry.instance().loadEntityRenderers(bgy.a.q);
        this.loading = false;
        KeyBindingRegistry.instance().uploadKeyBindingsToGame(this.client.z);
    }

    public void onInitializationComplete() {
        if (this.wrongMC != null) {
            this.client.a(new GuiWrongMinecraft(this.wrongMC));
        } else if (this.modsMissing != null) {
            this.client.a(new GuiModsMissing(this.modsMissing));
        } else if (this.dupesFound != null) {
            this.client.a(new GuiDupesFound(this.dupesFound));
        } else if (this.modSorting != null) {
            this.client.a(new GuiSortingProblem(this.modSorting));
        } else if (this.customError != null) {
            this.client.a(new GuiCustomModLoadingErrorScreen(this.customError));
        } else {
            this.client.p.c();
        }
    }

    public Minecraft getClient() {
        return this.client;
    }

    public Logger getMinecraftLogger() {
        return null;
    }

    public static FMLClientHandler instance() {
        return INSTANCE;
    }

    public void displayGuiScreen(sq player, axr gui) {
        if (this.client.g == player && gui != null) {
            this.client.a(gui);
        }
    }

    public void addSpecialModEntries(ArrayList<ModContainer> mods) {
        if (this.optifineContainer != null) {
            mods.add(this.optifineContainer);
        }
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        if (this.optifineContainer != null) {
            return Arrays.asList(String.format("Optifine %s", this.optifineContainer.getVersion()));
        }
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    public boolean hasOptifine() {
        return this.optifineContainer != null;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
        axr gui = (axr)clientGuiElement;
        this.client.a(gui);
    }

    @Override
    public mp spawnEntityIntoClientWorld(EntityRegistry.EntityRegistration er2, EntitySpawnPacket packet) {
        bds wc = this.client.e;
        Class<? extends mp> cls = er2.getEntityClass();
        try {
            mp entity;
            if (er2.hasCustomSpawning()) {
                entity = er2.doCustomSpawning(packet);
            } else {
                mp[] parts;
                entity = cls.getConstructor(aab.class).newInstance(wc);
                int offset = packet.entityId - entity.k;
                entity.k = packet.entityId;
                entity.b(packet.scaledX, packet.scaledY, packet.scaledZ, packet.scaledYaw, packet.scaledPitch);
                if (entity instanceof ng) {
                    ((ng)entity).aA = packet.scaledHeadYaw;
                }
                if ((parts = entity.an()) != null) {
                    for (int j2 = 0; j2 < parts.length; ++j2) {
                        parts[j2].k += offset;
                    }
                }
            }
            entity.cx = packet.rawX;
            entity.cy = packet.rawY;
            entity.cz = packet.rawZ;
            if (entity instanceof IThrowableEntity) {
                Object thrower = this.client.g.k == packet.throwerId ? this.client.g : wc.a(packet.throwerId);
                ((IThrowableEntity)((Object)entity)).setThrower((mp)thrower);
            }
            if (packet.metadata != null) {
                entity.u().a(packet.metadata);
            }
            if (packet.throwerId > 0) {
                entity.h(packet.speedScaledX, packet.speedScaledY, packet.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)((Object)entity)).readSpawnData(packet.dataStream);
            }
            wc.a(packet.entityId, entity);
            return entity;
        }
        catch (Exception e) {
            FMLLog.log(Level.SEVERE, e, "A severe problem occurred during the spawning of an entity", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void adjustEntityLocationOnClient(EntitySpawnAdjustmentPacket packet) {
        mp ent = this.client.e.a(packet.entityId);
        if (ent != null) {
            ent.cx = packet.serverX;
            ent.cy = packet.serverY;
            ent.cz = packet.serverZ;
        } else {
            FMLLog.fine("Attempted to adjust the position of entity %d which is not present on the client", packet.entityId);
        }
    }

    @Override
    public void beginServerLoading(MinecraftServer server) {
        this.serverShouldBeKilledQuietly = false;
    }

    @Override
    public void finishServerLoading() {
    }

    @Override
    public MinecraftServer getServer() {
        return this.client.D();
    }

    @Override
    public void sendPacket(ei packet) {
        if (this.client.g != null) {
            this.client.g.a.c(packet);
        }
    }

    @Override
    public void displayMissingMods(ModMissingPacket modMissingPacket) {
        this.client.a(new GuiModsMissingForServer(modMissingPacket));
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void handleTinyPacket(ej handler, db mapData) {
        ((bdk)handler).fmlPacket131Callback(mapData);
    }

    @Override
    public void setClientCompatibilityLevel(byte compatibilityLevel) {
        bdk.setConnectionCompatibilityLevel(compatibilityLevel);
    }

    @Override
    public byte getClientCompatibilityLevel() {
        return bdk.getConnectionCompatibilityLevel();
    }

    public void warnIDMismatch(MapDifference<Integer, ItemData> idDifferences, boolean mayContinue) {
        GuiIdMismatchScreen mismatch = new GuiIdMismatchScreen(idDifferences, mayContinue);
        this.client.a((axr)mismatch);
    }

    public void callbackIdDifferenceResponse(boolean response) {
        if (response) {
            this.serverShouldBeKilledQuietly = false;
            GameData.releaseGate(true);
            this.client.continueWorldLoading();
        } else {
            this.serverShouldBeKilledQuietly = true;
            GameData.releaseGate(false);
            this.client.a((bds)null);
            this.client.a((axr)null);
        }
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return this.serverShouldBeKilledQuietly;
    }

    @Override
    public void disconnectIDMismatch(MapDifference<Integer, ItemData> s, ej toKill, cg mgr) {
        boolean criticalMismatch = !s.entriesOnlyOnLeft().isEmpty();
        for (Map.Entry mismatch : s.entriesDiffering().entrySet()) {
            MapDifference.ValueDifference vd = (MapDifference.ValueDifference)mismatch.getValue();
            if (((ItemData)vd.leftValue()).mayDifferByOrdinal((ItemData)vd.rightValue())) continue;
            criticalMismatch = true;
        }
        if (!criticalMismatch) {
            return;
        }
        ((bdk)toKill).e();
        bdn.forceTermination((bdn)this.client.s);
        mgr.b();
        this.client.a((bds)null);
        this.warnIDMismatch(s, false);
    }

    public boolean isGUIOpen(Class<? extends axr> gui) {
        return this.client.s != null && this.client.s.getClass().equals(gui);
    }
}

