/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.world;

import codechicken.core.world.ChunkExtension;
import java.util.HashMap;

public abstract class WorldExtension {
    public final aab world;
    public HashMap chunkMap = new HashMap();

    public WorldExtension(aab world) {
        this.world = world;
    }

    public void load() {
    }

    public void unload() {
    }

    public void save() {
    }

    public void preTick() {
    }

    public void postTick() {
    }

    protected final void addChunk(ChunkExtension extension) {
        this.chunkMap.put(extension.chunk, extension);
    }

    protected final void loadChunk(abw chunk) {
        ((ChunkExtension)this.chunkMap.get(chunk)).load();
    }

    protected final void unloadChunk(abw chunk) {
        ((ChunkExtension)this.chunkMap.get(chunk)).unload();
    }

    protected final void loadChunkData(abw chunk, bs tag) {
        ((ChunkExtension)this.chunkMap.get(chunk)).loadData(tag);
    }

    protected final void saveChunkData(abw chunk, bs tag) {
        ((ChunkExtension)this.chunkMap.get(chunk)).saveData(tag);
    }

    protected final void remChunk(abw chunk) {
        this.chunkMap.remove(chunk);
    }

    protected final void watchChunk(abw chunk, jc player) {
        ((ChunkExtension)this.chunkMap.get(chunk)).watchPlayer(player);
    }

    protected final void unwatchChunk(abw chunk, jc player) {
        ChunkExtension extension = (ChunkExtension)this.chunkMap.get(chunk);
        if (extension != null) {
            extension.unwatchPlayer(player);
        }
    }

    protected final void sendChunkUpdates(abw chunk) {
        ((ChunkExtension)this.chunkMap.get(chunk)).sendUpdatePackets();
    }

    public boolean containsChunk(abw chunk) {
        return this.chunkMap.containsKey(chunk);
    }

    public ChunkExtension getChunkExtension(int chunkXPos, int chunkZPos) {
        if (!this.world.f(chunkXPos << 4, 128, chunkZPos << 4)) {
            return null;
        }
        return (ChunkExtension)this.chunkMap.get(this.world.e(chunkXPos, chunkZPos));
    }
}

