/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.sound;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.machinemuse.numina.basemod.NuminaConfig;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.sound.MovingSoundPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class Musique {
    private static HashMap<String, MovingSoundPlayer> soundMap = new HashMap();
    private static String soundprefix = "Numina";

    @SideOnly(value=Side.CLIENT)
    public static SoundHandler mcsound() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    public GameSettings options() {
        return Minecraft.func_71410_x().field_71474_y;
    }

    public static void playClientSound(String soundResourceLocation, float volume) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
            PositionedSoundRecord sound = PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(soundResourceLocation), (float)volume);
            Musique.mcsound().func_147682_a((ISound)sound);
        }
    }

    public static String makeSoundString(EntityPlayer player, String soundname) {
        return soundprefix + player.func_70005_c_() + soundname;
    }

    public static void playerSound(EntityPlayer player, String soundname, float volume, Float pitch, Boolean continuous) {
        pitch = Float.valueOf(pitch != null ? pitch.floatValue() : 1.0f);
        continuous = continuous != null ? continuous : true;
        if (player.field_70170_p.field_72995_K && NuminaConfig.useSounds()) {
            String soundID = Musique.makeSoundString(player, soundname);
            MovingSoundPlayer sound = soundMap.get(soundID);
            if (sound != null && (sound.func_147667_k() || !sound.func_147657_c())) {
                Musique.stopPlayerSound(player, soundname);
                sound = null;
            }
            if (sound != null) {
                sound.updateVolume(volume).updatePitch(pitch.floatValue()).updateRepeat(continuous);
            } else {
                MuseLogger.logDebug("New sound: " + soundname);
                MovingSoundPlayer newsound = new MovingSoundPlayer(player, new ResourceLocation(soundname), volume * 2.0f, pitch.floatValue(), continuous);
                Musique.mcsound().func_147682_a((ISound)newsound);
                soundMap.put(soundID, newsound);
            }
        }
    }

    public static void stopPlayerSound(EntityPlayer player, String soundname) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
            String soundID = Musique.makeSoundString(player, soundname);
            MovingSoundPlayer sound = soundMap.get(soundID);
            MuseLogger.logDebug("Sound stopped: " + soundname);
            if (sound != null) {
                sound.stopPlaying();
                Musique.mcsound().func_147683_b((ISound)sound);
            }
            soundMap.remove(soundID);
        }
    }
}

