/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.playerData;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.DimensionManager;

public class TransmutationOffline {
    private static Map<UUID, List<ItemStack>> cachedKnowledge = Maps.newHashMap();
    private static Map<UUID, Double> cachedEmc = Maps.newHashMap();
    private static Map<UUID, Boolean> cachedFullKnowledge = Maps.newHashMap();

    public static void cleanAll() {
        cachedKnowledge.clear();
        cachedEmc.clear();
        cachedFullKnowledge.clear();
    }

    public static void clear(UUID playerUUID) {
        cachedKnowledge.remove(playerUUID);
        cachedEmc.remove(playerUUID);
        cachedFullKnowledge.remove(playerUUID);
    }

    public static List<ItemStack> getKnowledge(UUID playerUUID) {
        if (!cachedKnowledge.containsKey(playerUUID)) {
            TransmutationOffline.cacheOfflineData(playerUUID);
        }
        return cachedKnowledge.get(playerUUID);
    }

    public static boolean hasKnowledgeForStack(ItemStack stack, UUID playerUUID) {
        List<ItemStack> knowledge = TransmutationOffline.getKnowledge(playerUUID);
        if (knowledge != null) {
            for (ItemStack s : knowledge) {
                if (!ItemHelper.basicAreStacksEqual(s, stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static double getEmc(UUID playerUUID) {
        if (!cachedEmc.containsKey(playerUUID)) {
            TransmutationOffline.cacheOfflineData(playerUUID);
        }
        return cachedEmc.get(playerUUID) == null ? Double.NaN : cachedEmc.get(playerUUID);
    }

    private static void cacheOfflineData(UUID playerUUID) {
        File player;
        Preconditions.checkState((boolean)FMLCommonHandler.instance().getEffectiveSide().isServer(), (Object)"CRITICAL: Trying to read filesystem on client!!");
        File playerData = new File(DimensionManager.getCurrentSaveRootDirectory(), "playerdata");
        if (playerData.exists() && (player = new File(playerData, playerUUID.toString() + ".dat")).exists() && player.isFile()) {
            try {
                NBTTagCompound props = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(player)).func_74775_l("ProjectETransmutation");
                cachedEmc.put(playerUUID, props.func_74769_h("transmutationEmc"));
                cachedFullKnowledge.put(playerUUID, props.func_74767_n("tome"));
                ArrayList knowledge = Lists.newArrayList();
                NBTTagList list = props.func_150295_c("knowledge", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ItemStack item = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
                    if (item == null) continue;
                    knowledge.add(item);
                }
                cachedKnowledge.put(playerUUID, knowledge);
                PELogger.logDebug("Caching offline data for UUID: %s", playerUUID);
            }
            catch (IOException e) {
                PELogger.logWarn("Failed to cache offline data for API calls for UUID: %s", playerUUID);
            }
        }
    }
}

