/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.ItemCharge;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class Zero
extends ItemCharge
implements IModeChanger,
IBauble,
IPedestalItem {
    @SideOnly(value=Side.CLIENT)
    private IIcon ringOff;
    @SideOnly(value=Side.CLIENT)
    private IIcon ringOn;

    public Zero() {
        super("zero_ring", (byte)4);
        this.func_77642_a(this);
        this.setNoRepair();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(stack, world, entity, par4, par5);
        if (world.field_72995_K || !(entity instanceof EntityPlayer) || par4 > 8 || stack.func_77960_j() == 0) {
            return;
        }
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(entity.field_70165_t - 3.0), (double)(entity.field_70163_u - 3.0), (double)(entity.field_70161_v - 3.0), (double)(entity.field_70165_t + 3.0), (double)(entity.field_70163_u + 3.0), (double)(entity.field_70161_v + 3.0));
        WorldHelper.freezeInBoundingBox(world, box, (EntityPlayer)entity, true);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            int offset = 3 + this.getCharge(stack);
            AxisAlignedBB box = player.field_70121_D.func_72314_b((double)offset, (double)offset, (double)offset);
            world.func_72956_a((Entity)player, "projecte:item.pepower", 1.0f, 1.0f);
            WorldHelper.freezeInBoundingBox(world, box, player, false);
        }
        return stack;
    }

    public boolean func_77630_h(ItemStack stack) {
        return false;
    }

    @Override
    public byte getMode(ItemStack stack) {
        return (byte)stack.func_77960_j();
    }

    @Override
    public void changeMode(EntityPlayer player, ItemStack stack) {
        stack.func_77964_b(stack.func_77960_j() == 0 ? 1 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int dmg) {
        return dmg == 0 ? this.ringOff : this.ringOn;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.ringOn = register.func_94245_a(this.getTexture("rings", "zero_on"));
        this.ringOff = register.func_94245_a(this.getTexture("rings", "zero_off"));
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(World world, int x, int y, int z) {
        if (!world.field_72995_K && ProjectEConfig.zeroPedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_147438_o(x, y, z);
            if (tile.getActivityCooldown() == 0) {
                AxisAlignedBB aabb = tile.getEffectBounds();
                WorldHelper.freezeInBoundingBox(world, aabb, null, false);
                List list = world.func_72872_a(Entity.class, aabb);
                for (Entity ent : list) {
                    if (!ent.func_70027_ad()) continue;
                    ent.func_70066_B();
                }
                tile.setActivityCooldown(ProjectEConfig.zeroPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.zeroPedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.zero.pedestal1"));
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.zero.pedestal2"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.zero.pedestal3"), MathUtils.tickToSecFormatted(ProjectEConfig.zeroPedCooldown)));
        }
        return list;
    }
}

