/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.PlayerChecks;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class SWRG
extends ItemPE
implements IBauble,
IPedestalItem,
IFlightProvider {
    @SideOnly(value=Side.CLIENT)
    private IIcon ringOff;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] ringOn;

    public SWRG() {
        this.func_77655_b("swrg");
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setNoRepair();
    }

    private void tick(ItemStack stack, EntityPlayer player) {
        if (stack.func_77960_j() > 1) {
            WorldHelper.repelEntitiesInAABBFromPoint(player.field_70170_p, player.field_70121_D.func_72314_b(5.0, 5.0, 5.0), player.field_70165_t, player.field_70163_u, player.field_70161_v, true);
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (SWRG.getEmc(stack) == 0.0 && !SWRG.consumeFuel(player, stack, 64.0, false)) {
            if (stack.func_77960_j() > 0) {
                this.changeMode(stack, 0);
            }
            if (playerMP.field_71075_bZ.field_75101_c) {
                PlayerChecks.disableSwrgFlightOverride(playerMP);
            }
            return;
        }
        if (!playerMP.field_71075_bZ.field_75101_c) {
            PlayerChecks.enableSwrgFlightOverride(playerMP);
        }
        if (playerMP.field_71075_bZ.field_75100_b) {
            if (!this.isFlyingEnabled(stack)) {
                this.changeMode(stack, stack.func_77960_j() == 0 ? 1 : 3);
            }
        } else if (this.isFlyingEnabled(stack)) {
            this.changeMode(stack, stack.func_77960_j() == 1 ? 0 : 2);
        }
        float toRemove = 0.0f;
        if (playerMP.field_71075_bZ.field_75100_b) {
            toRemove = 0.32f;
        }
        if (stack.func_77960_j() == 2) {
            toRemove = 0.32f;
        } else if (stack.func_77960_j() == 3) {
            toRemove = 0.64f;
        }
        SWRG.removeEmc(stack, toRemove);
        playerMP.field_70143_R = 0.0f;
    }

    private boolean isFlyingEnabled(ItemStack stack) {
        return stack.func_77960_j() == 1 || stack.func_77960_j() == 3;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean isHeldItem) {
        if (invSlot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        this.tick(stack, (EntityPlayer)entity);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            int newMode = 0;
            switch (stack.func_77960_j()) {
                case 0: {
                    newMode = 2;
                    break;
                }
                case 1: {
                    newMode = 3;
                    break;
                }
                case 2: {
                    newMode = 0;
                    break;
                }
                case 3: {
                    newMode = 1;
                }
            }
            this.changeMode(stack, newMode);
        }
        return stack;
    }

    public void changeMode(ItemStack stack, int mode) {
        stack.func_77964_b(mode);
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, EntityPlayerMP player) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int dmg) {
        if (dmg == 0) {
            return this.ringOff;
        }
        return this.ringOn[MathHelper.func_76125_a((int)(dmg - 1), (int)0, (int)2)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.ringOff = register.func_94245_a(this.getTexture("rings", "swrg_off"));
        this.ringOn = new IIcon[3];
        for (int i = 0; i < 3; ++i) {
            this.ringOn[i] = register.func_94245_a(this.getTexture("rings", "swrg_on" + (i + 1)));
        }
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase ent) {
        if (!(ent instanceof EntityPlayer)) {
            return;
        }
        this.tick(stack, (EntityPlayer)ent);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack stack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(World world, int x, int y, int z) {
        if (!world.field_72995_K && ProjectEConfig.swrgPedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_147438_o(x, y, z);
            if (tile.getActivityCooldown() <= 0) {
                List list = world.func_72872_a(EntityLiving.class, tile.getEffectBounds());
                for (EntityLiving living : list) {
                    world.func_72942_c((Entity)new EntityLightningBolt(world, living.field_70165_t, living.field_70163_u, living.field_70161_v));
                }
                tile.setActivityCooldown(ProjectEConfig.swrgPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.swrgPedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.swrg.pedestal1"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.swrg.pedestal2"), MathUtils.tickToSecFormatted(ProjectEConfig.swrgPedCooldown)));
        }
        return list;
    }
}

