/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IExtraFunction;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MercurialEye
extends ItemMode
implements IExtraFunction {
    private final int NORMAL_MODE = 0;
    private final int TRANSMUTATION_MODE = 1;
    private final double WALL_MODE = Math.sin(Math.toRadians(45.0));

    public MercurialEye() {
        super("mercurial_eye", (byte)4, new String[]{"Normal", "Transmutation"});
        this.setNoRepair();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            MovingObjectPosition mop = this.func_77621_a(world, player, false);
            if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return stack;
            }
            ItemStack[] inventory = this.getInventory(stack);
            if (inventory[0] == null || inventory[1] == null) {
                return stack;
            }
            Block newBlock = Block.func_149634_a((Item)inventory[1].func_77973_b());
            if (newBlock == Blocks.field_150350_a) {
                return stack;
            }
            int newMeta = inventory[1].func_77960_j();
            double kleinEmc = ItemPE.getEmc(inventory[0]);
            int reqEmc = EMCHelper.getEmcValue(inventory[1]);
            byte charge = this.getCharge(stack);
            byte mode = this.getMode(stack);
            int facing = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            ForgeDirection dir = ForgeDirection.getOrientation((int)mop.field_72310_e);
            Vec3 look = player.func_70040_Z();
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d, (double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d);
            int dX = 0;
            int dY = 0;
            int dZ = 0;
            boolean lookingDown = look.field_72448_b >= -1.0 && look.field_72448_b <= -this.WALL_MODE;
            boolean lookingUp = look.field_72448_b <= 1.0 && look.field_72448_b >= this.WALL_MODE;
            boolean lookingAlongZ = facing == 0 || facing == 2;
            switch (dir) {
                case UP: {
                    if (lookingDown || mode == 1) {
                        box = box.func_72314_b((double)charge, 0.0, (double)charge);
                        dY = 1;
                        break;
                    }
                    if (lookingAlongZ) {
                        box = box.func_72314_b((double)charge, (double)(charge * 2), 0.0).func_72317_d(0.0, (double)charge, 0.0);
                        break;
                    }
                    box = box.func_72314_b(0.0, (double)(charge * 2), (double)charge).func_72317_d(0.0, (double)charge, 0.0);
                    break;
                }
                case DOWN: {
                    if (lookingUp || mode == 1) {
                        box = box.func_72314_b((double)charge, 0.0, (double)charge);
                        dY = -1;
                        break;
                    }
                    if (lookingAlongZ) {
                        box = box.func_72314_b((double)charge, (double)(charge * 2), 0.0).func_72317_d(0.0, (double)(-charge), 0.0);
                        break;
                    }
                    box = box.func_72314_b(0.0, (double)(charge * 2), (double)charge).func_72317_d(0.0, (double)(-charge), 0.0);
                    break;
                }
                case EAST: {
                    box = box.func_72314_b(0.0, (double)charge, (double)charge);
                    dX = 1;
                    break;
                }
                case WEST: {
                    box = box.func_72314_b(0.0, (double)charge, (double)charge);
                    dX = -1;
                    break;
                }
                case SOUTH: {
                    box = box.func_72314_b((double)charge, (double)charge, 0.0);
                    dZ = 1;
                    break;
                }
                case NORTH: {
                    box = box.func_72314_b((double)charge, (double)charge, 0.0);
                    dZ = -1;
                }
            }
            if (0 == mode) {
                box = box.func_72317_d((double)dX, (double)dY, (double)dZ);
            }
            if (box != null) {
                for (int x = (int)box.field_72340_a; x <= (int)box.field_72336_d; ++x) {
                    block9: for (int y = (int)box.field_72338_b; y <= (int)box.field_72337_e; ++y) {
                        for (int z = (int)box.field_72339_c; z <= (int)box.field_72334_f; ++z) {
                            int difference;
                            Block oldBlock = world.func_147439_a(x, y, z);
                            int oldMeta = oldBlock.func_149643_k(world, x, y, z);
                            if (mode == 0 && oldBlock == Blocks.field_150350_a) {
                                if (kleinEmc < (double)reqEmc) continue block9;
                                if (!PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, x, y, z, newBlock, newMeta)) continue;
                                this.removeKleinEMC(stack, reqEmc);
                                kleinEmc -= (double)reqEmc;
                                continue;
                            }
                            if (mode != 1 || oldBlock == newBlock && oldMeta == newMeta || oldBlock == Blocks.field_150350_a || world.func_147438_o(x, y, z) != null || !EMCHelper.doesItemHaveEmc(new ItemStack(oldBlock, 1, oldMeta))) continue;
                            int emc = EMCHelper.getEmcValue(new ItemStack(oldBlock, 1, oldMeta));
                            if (emc > reqEmc) {
                                if (!PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, x, y, z, newBlock, newMeta)) continue;
                                difference = emc - reqEmc;
                                kleinEmc += MathHelper.func_151237_a((double)kleinEmc, (double)0.0, (double)EMCHelper.getKleinStarMaxEmc(inventory[0]));
                                this.addKleinEMC(stack, difference);
                                continue;
                            }
                            if (emc < reqEmc) {
                                difference = reqEmc - emc;
                                if (!(kleinEmc >= (double)difference) || !PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, x, y, z, newBlock, newMeta)) continue;
                                kleinEmc -= (double)difference;
                                this.removeKleinEMC(stack, difference);
                                continue;
                            }
                            PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, x, y, z, newBlock, newMeta);
                        }
                    }
                }
                player.field_70170_p.func_72956_a((Entity)player, "projecte:item.pepower", 1.0f, 0.8f + 0.2f / (float)this.numCharges * (float)charge);
            }
        }
        return stack;
    }

    private void addKleinEMC(ItemStack eye, int amount) {
        NBTTagList list = eye.field_77990_d.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            if (nbt.func_74771_c("Slot") != 0) continue;
            ItemStack kleinStar = ItemStack.func_77949_a((NBTTagCompound)nbt);
            NBTTagCompound tag = nbt.func_74775_l("tag");
            double newEmc = MathHelper.func_151237_a((double)(tag.func_74769_h("StoredEMC") + (double)amount), (double)0.0, (double)EMCHelper.getKleinStarMaxEmc(kleinStar));
            tag.func_74780_a("StoredEMC", newEmc);
            break;
        }
    }

    private void removeKleinEMC(ItemStack eye, int amount) {
        NBTTagList list = eye.field_77990_d.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            if (nbt.func_74771_c("Slot") != 0) continue;
            NBTTagCompound tag = nbt.func_74775_l("tag");
            tag.func_74780_a("StoredEMC", tag.func_74769_h("StoredEMC") - (double)amount);
            break;
        }
    }

    private ItemStack[] getInventory(ItemStack eye) {
        ItemStack[] result = new ItemStack[2];
        if (eye.func_77942_o()) {
            NBTTagList list = eye.field_77990_d.func_150295_c("Items", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                result[nbt.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)nbt);
            }
        }
        return result;
    }

    @Override
    public void doExtraFunction(ItemStack stack, EntityPlayer player) {
        player.openGui((Object)PECore.instance, 12, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.getTexture("mercurial_eye"));
    }
}

