/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import moze_intel.projecte.gameObjs.items.CataliticLens;
import moze_intel.projecte.gameObjs.items.ItemCharge;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.ParticlePKT;
import moze_intel.projecte.utils.Coordinates;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DestructionCatalyst
extends ItemCharge {
    public DestructionCatalyst() {
        super("destruction_catalyst", (byte)3);
        this.setNoRepair();
    }

    protected DestructionCatalyst(String name, byte numCharges) {
        super(name, numCharges);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, false);
        if (mop != null && mop.field_72313_a.equals((Object)MovingObjectPosition.MovingObjectType.BLOCK)) {
            int numRows = this.calculateDepthFromCharge(stack);
            boolean hasAction = false;
            ForgeDirection direction = ForgeDirection.getOrientation((int)mop.field_72310_e);
            Coordinates coords = new Coordinates(mop);
            AxisAlignedBB box = WorldHelper.getDeepBox(coords, direction, --numRows);
            ArrayList drops = Lists.newArrayList();
            int x = (int)box.field_72340_a;
            while ((double)x <= box.field_72336_d) {
                int y = (int)box.field_72338_b;
                while ((double)y <= box.field_72337_e) {
                    int z = (int)box.field_72339_c;
                    while ((double)z <= box.field_72334_f) {
                        Block block = world.func_147439_a(x, y, z);
                        float hardness = block.func_149712_f(world, x, y, z);
                        if (block != Blocks.field_150350_a && !(hardness >= 50.0f) && hardness != -1.0f) {
                            if (!DestructionCatalyst.consumeFuel(player, stack, 8.0, true)) break;
                            if (!hasAction) {
                                hasAction = true;
                            }
                            if (PlayerHelper.hasBreakPermission((EntityPlayerMP)player, x, y, z)) {
                                ArrayList<ItemStack> list = WorldHelper.getBlockDrops(world, player, block, stack, x, y, z);
                                if (list != null && list.size() > 0) {
                                    drops.addAll(list);
                                }
                                world.func_147468_f(x, y, z);
                                if (world.field_73012_v.nextInt(8) == 0) {
                                    PacketHandler.sendToAllAround(new ParticlePKT("largesmoke", x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)(y + 1), (double)z, 32.0));
                                }
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            PlayerHelper.swingItem(player);
            if (hasAction) {
                WorldHelper.createLootDrop(drops, world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                world.func_72956_a((Entity)player, "projecte:item.pedestruct", 1.0f, 1.0f);
            }
        }
        return stack;
    }

    protected int calculateDepthFromCharge(ItemStack stack) {
        byte charge = this.getCharge(stack);
        if (charge <= 0) {
            return 1;
        }
        if (this instanceof CataliticLens) {
            return 8 + charge * 8;
        }
        return (int)Math.pow(2.0, 1 + charge);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.getTexture("destruction_catalyst"));
    }
}

