/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.world.prefabs;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public abstract class ChunkProviderSpaceNormal
extends ChunkProviderGenerate {
    protected Random field_73220_k;
    public NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves field_73214_a;
    public NoiseGeneratorOctaves field_73212_b;
    public NoiseGeneratorOctaves field_73213_c;
    protected World field_73230_p;
    private double[] stoneNoise;
    private BiomeGenBase[] biomesForGeneration;
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] squareTable;
    private NoiseGeneratorOctaves field_147431_j;
    private NoiseGeneratorOctaves field_147432_k;
    private NoiseGeneratorOctaves field_147429_l;
    private NoiseGeneratorPerlin field_147430_m;
    private double[] terrainCalcs;
    private float[] parabolicField;
    double[] field_147427_d;
    double[] field_147428_e;
    double[] field_147425_f;
    double[] field_147426_g;
    int[][] field_73219_j = new int[32][32];
    private List<MapGenBaseMeta> worldGenerators;
    public final Gradient noiseGen;

    public ChunkProviderSpaceNormal(World world, long seed, boolean flag) {
        super(world, seed, flag);
        this.stoneNoise = new double[256];
        this.field_73230_p = world;
        this.field_73220_k = new Random(seed);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.field_73220_k, 4);
        this.field_73214_a = new NoiseGeneratorOctaves(this.field_73220_k, 10);
        this.field_73212_b = new NoiseGeneratorOctaves(this.field_73220_k, 16);
        this.field_73213_c = new NoiseGeneratorOctaves(this.field_73220_k, 8);
        this.field_147431_j = new NoiseGeneratorOctaves(this.field_73220_k, 16);
        this.field_147432_k = new NoiseGeneratorOctaves(this.field_73220_k, 16);
        this.field_147429_l = new NoiseGeneratorOctaves(this.field_73220_k, 8);
        this.field_147430_m = new NoiseGeneratorPerlin(this.field_73220_k, 4);
        this.terrainCalcs = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
        this.noiseGen = new Gradient(this.field_73220_k.nextLong(), 1, 0.25f);
    }

    public Chunk func_73154_d(int x, int z) {
        this.field_73220_k.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        Block[] blockStorage = new Block[65536];
        byte[] metaStorage = new byte[65536];
        this.generateTerrain(x, z, blockStorage);
        this.biomesForGeneration = this.field_73230_p.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.func_147422_a(x, z, blockStorage, metaStorage, this.biomesForGeneration);
        Chunk chunk = new Chunk(this.field_73230_p, blockStorage, metaStorage, x, z);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)this.biomesForGeneration[i].field_76756_M;
        }
        if (this.worldGenerators == null) {
            this.worldGenerators = this.getWorldGenerators();
        }
        for (MapGenBaseMeta generator : this.worldGenerators) {
            generator.generate((IChunkProvider)this, this.field_73230_p, x, z, blockStorage, metaStorage);
        }
        this.onChunkProvide(x, z, blockStorage, metaStorage);
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] blockStorage) {
        int seaLevel = 60;
        this.biomesForGeneration = this.field_73230_p.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.makeLandPerBiome2(chunkX * 4, 0, chunkZ * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.terrainCalcs[k1 + k2];
                    double d2 = this.terrainCalcs[l1 + k2];
                    double d3 = this.terrainCalcs[i2 + k2];
                    double d4 = this.terrainCalcs[j2 + k2];
                    double d5 = (this.terrainCalcs[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.terrainCalcs[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.terrainCalcs[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.terrainCalcs[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int j3 = i3 + k * 4 << 12 | 0 + j1 * 4 << 8 | k2 * 8 + l2;
                            int short1 = 256;
                            j3 -= short1;
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                blockStorage[j3 += short1] = d > 0.0 ? Blocks.field_150348_b : (k2 * 8 + l2 < seaLevel ? Blocks.field_150355_j : null);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void makeLandPerBiome2(int x, int zero, int z) {
        this.field_147426_g = this.field_73212_b.func_76305_a(this.field_147426_g, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.field_147427_d = this.field_147429_l.func_76304_a(this.field_147427_d, x, zero, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.field_147428_e = this.field_147431_j.func_76304_a(this.field_147428_e, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.field_147425_f = this.field_147432_k.func_76304_a(this.field_147425_f, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biomegenbase1.field_76748_D;
                        float heightVariation = biomegenbase1.field_76749_E;
                        float heightFactor = this.parabolicField[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.field_147426_g[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = totalVariation;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.field_147428_e[terrainIndex] / 512.0;
                    double d8 = this.field_147425_f[terrainIndex] / 512.0;
                    double d9 = (this.field_147427_d[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.terrainCalcs[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    public void func_147422_a(int chunkX, int chunkZ, Block[] blockStorage, byte[] metaStorage, BiomeGenBase[] biomes) {
        double d0 = 0.03125;
        this.stoneNoise = this.field_147430_m.func_151599_a(this.stoneNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                BiomeGenBase biomegenbase = biomes[x + z * 16];
                biomegenbase.func_150573_a(this.field_73230_p, this.field_73220_k, blockStorage, metaStorage, chunkX * 16 + z, chunkZ * 16 + x, this.stoneNoise[x + z * 16]);
            }
        }
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public void func_73153_a(IChunkProvider chunk, int x, int z) {
        BlockFalling.field_149832_M = true;
        int var4 = x * 16;
        int var5 = z * 16;
        BiomeGenBase biomeGen = this.field_73230_p.func_72807_a(var4 + 16, var5 + 16);
        this.field_73230_p.func_72807_a(var4 + 16, var5 + 16);
        this.field_73220_k.setSeed(this.field_73230_p.func_72905_C());
        long var7 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        long var9 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        this.field_73220_k.setSeed((long)x * var7 + (long)z * var9 ^ this.field_73230_p.func_72905_C());
        biomeGen.func_76728_a(this.field_73230_p, this.field_73220_k, var4, var5);
        this.decoratePlanet(this.field_73230_p, this.field_73220_k, var4, var5);
        SpawnerAnimals.func_77191_a((World)this.field_73230_p, (BiomeGenBase)biomeGen, (int)(var4 + 8), (int)(var5 + 8), (int)16, (int)16, (Random)this.field_73220_k);
        BlockFalling.field_149832_M = false;
    }

    public int func_73152_e() {
        return 0;
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }

    public ChunkPosition func_147416_a(World world, String string, int x, int y, int z) {
        return null;
    }

    public abstract void func_82695_e(int var1, int var2);

    public abstract String func_73148_d();

    public abstract void decoratePlanet(World var1, Random var2, int var3, int var4);

    protected abstract List<MapGenBaseMeta> getWorldGenerators();

    public abstract void onChunkProvide(int var1, int var2, Block[] var3, byte[] var4);
}

