/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.tile.machines;

import com.mjr.extraplanets.api.IPowerable;
import cpw.mods.fml.relauncher.Side;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityVehicleChanger
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
ILandingPadAttachable {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    private ItemStack[] containingItems = new ItemStack[2];
    public IPowerable attachedPowerable;
    private boolean loadedPowerLastTick = false;

    public TileEntityVehicleChanger() {
        this.storage.setMaxExtract(30.0f);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.loadedPowerLastTick = false;
            if (this.ticks % 100 == 0) {
                this.attachedPowerable = null;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity pad = new BlockVec3((TileEntity)this).getTileEntityOnSide(this.field_145850_b, dir);
                    if (pad instanceof TileEntityMulti) {
                        TileEntity mainTile = ((TileEntityMulti)pad).getMainBlockTile();
                        if (!(mainTile instanceof IPowerable)) continue;
                        this.attachedPowerable = (IPowerable)mainTile;
                        break;
                    }
                    if (!(pad instanceof IPowerable)) continue;
                    this.attachedPowerable = (IPowerable)pad;
                    break;
                }
            }
            if (this.storage.getEnergyStoredGC() > 10.0f && this.attachedPowerable != null && this.hasEnoughEnergyToRun && !this.disabled) {
                float filled = this.attachedPowerable.addPower(10.0f, true);
                this.loadedPowerLastTick = filled == 10.0f;
                this.storage.setEnergyStored(this.storage.getEnergyStoredGC() - filled);
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"container.vehicle.charger.name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 1 && itemstack != null && itemstack.func_77973_b() == GCItems.fuelCanister || slotID == 0 && ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0) && this.loadedPowerLastTick;
    }

    public boolean canAttachToLandingPad(IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

