/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.planets.Ceres.spacestation.TeleportTypeCeresOrbit;
import com.mjr.extraplanets.planets.Ceres.spacestation.WorldProviderCeresOrbit;
import com.mjr.extraplanets.planets.Eris.spacestation.TeleportTypeErisOrbit;
import com.mjr.extraplanets.planets.Eris.spacestation.WorldProviderErisOrbit;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.planets.Jupiter.spacestation.TeleportTypeJupiterOrbit;
import com.mjr.extraplanets.planets.Jupiter.spacestation.WorldProviderJupiterOrbit;
import com.mjr.extraplanets.planets.Kepler22b.spacestation.TeleportTypeKepler22bOrbit;
import com.mjr.extraplanets.planets.Kepler22b.spacestation.WorldProviderKepler22bOrbit;
import com.mjr.extraplanets.planets.Mercury.spacestation.TeleportTypeMercuryOrbit;
import com.mjr.extraplanets.planets.Mercury.spacestation.WorldProviderMercuryOrbit;
import com.mjr.extraplanets.planets.Neptune.spacestation.TeleportTypeNeptuneOrbit;
import com.mjr.extraplanets.planets.Neptune.spacestation.WorldProviderNeptuneOrbit;
import com.mjr.extraplanets.planets.Pluto.spacestation.TeleportTypePlutoOrbit;
import com.mjr.extraplanets.planets.Pluto.spacestation.WorldProviderPlutoOrbit;
import com.mjr.extraplanets.planets.Saturn.spacestation.TeleportTypeSaturnOrbit;
import com.mjr.extraplanets.planets.Saturn.spacestation.WorldProviderSaturnOrbit;
import com.mjr.extraplanets.planets.Uranus.spacestation.TeleportTypeUranusOrbit;
import com.mjr.extraplanets.planets.Uranus.spacestation.WorldProviderUranusOrbit;
import com.mjr.extraplanets.planets.Venus.spacestation.TeleportTypeVenusOrbit;
import com.mjr.extraplanets.planets.Venus.spacestation.WorldProviderVenusOrbit;
import com.mjr.extraplanets.planets.mars.spacestation.TeleportTypeMarsOrbit;
import com.mjr.extraplanets.planets.mars.spacestation.WorldProviderMarsOrbit;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.util.ResourceLocation;

public class ExtraPlanets_SpaceStations {
    public static Satellite mercurySpaceStation;
    public static Satellite venusSpaceStation;
    public static Satellite ceresSpaceStation;
    public static Satellite marsSpaceStation;
    public static Satellite jupiterSpaceStation;
    public static Satellite saturnSpaceStation;
    public static Satellite uranusSpaceStation;
    public static Satellite neptuneSpaceStation;
    public static Satellite plutoSpaceStation;
    public static Satellite erisSpaceStation;
    public static Satellite kepler22bSpaceStation;

    public static void init() {
        ExtraPlanets_SpaceStations.initializeSatellites();
        ExtraPlanets_SpaceStations.registerSatellites();
    }

    private static void initializeSatellites() {
        if (Config.mercurySpaceStation && Config.mercury) {
            mercurySpaceStation = new Satellite("spaceStation.mercury").setParentBody(ExtraPlanets_Planets.mercury);
            mercurySpaceStation.setRelativeSize(0.2667f);
            mercurySpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            mercurySpaceStation.setRelativeOrbitTime(20.0f);
            mercurySpaceStation.setTierRequired(ExtraPlanets_Planets.mercury.getTierRequirement());
            mercurySpaceStation.setDimensionInfo(Config.mercurySpaceStationID, Config.mercurySpaceStationStaticID, WorldProviderMercuryOrbit.class);
            mercurySpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
        if (Config.venusSpaceStation && Config.venus) {
            venusSpaceStation = new Satellite("spaceStation.venus").setParentBody(ExtraPlanets_Planets.venus);
            venusSpaceStation.setRelativeSize(0.2667f);
            venusSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            venusSpaceStation.setRelativeOrbitTime(20.0f);
            venusSpaceStation.setTierRequired(ExtraPlanets_Planets.venus.getTierRequirement());
            venusSpaceStation.setDimensionInfo(Config.venusSpaceStationID, Config.venusSpaceStationStaticID, WorldProviderVenusOrbit.class);
            venusSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
        if (Config.ceresSpaceStation && Config.ceres) {
            ceresSpaceStation = new Satellite("spaceStation.ceres").setParentBody(ExtraPlanets_Planets.ceres);
            ceresSpaceStation.setRelativeSize(0.2667f);
            ceresSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            ceresSpaceStation.setRelativeOrbitTime(20.0f);
            ceresSpaceStation.setTierRequired(ExtraPlanets_Planets.ceres.getTierRequirement());
            ceresSpaceStation.setDimensionInfo(Config.ceresSpaceStationID, Config.ceresSpaceStationStaticID, WorldProviderCeresOrbit.class);
            ceresSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
        if (Config.marsSpaceStation && MarsModule.planetMars != null) {
            marsSpaceStation = new Satellite("spaceStation.mars").setParentBody(MarsModule.planetMars);
            marsSpaceStation.setRelativeSize(0.2667f);
            marsSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            marsSpaceStation.setRelativeOrbitTime(20.0f);
            marsSpaceStation.setTierRequired(MarsModule.planetMars.getTierRequirement());
            marsSpaceStation.setDimensionInfo(Config.marsSpaceStationID, Config.marsSpaceStationStaticID, WorldProviderMarsOrbit.class);
            marsSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
        if (Config.jupiterSpaceStation && Config.jupiter) {
            jupiterSpaceStation = new Satellite("spaceStation.jupiter").setParentBody(ExtraPlanets_Planets.jupiter);
            jupiterSpaceStation.setRelativeSize(0.2667f);
            jupiterSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            jupiterSpaceStation.setRelativeOrbitTime(20.0f);
            jupiterSpaceStation.setTierRequired(ExtraPlanets_Planets.jupiter.getTierRequirement());
            jupiterSpaceStation.setDimensionInfo(Config.jupiterSpaceStationID, Config.jupiterSpaceStationStaticID, WorldProviderJupiterOrbit.class);
            jupiterSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
        if (Config.saturnSpaceStation && Config.saturn) {
            saturnSpaceStation = new Satellite("spaceStation.saturn").setParentBody(ExtraPlanets_Planets.saturn);
            saturnSpaceStation.setRelativeSize(0.2667f);
            saturnSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            saturnSpaceStation.setRelativeOrbitTime(20.0f);
            saturnSpaceStation.setTierRequired(ExtraPlanets_Planets.saturn.getTierRequirement());
            saturnSpaceStation.setDimensionInfo(Config.saturnSpaceStationID, Config.saturnSpaceStationStaticID, WorldProviderSaturnOrbit.class);
            saturnSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
        if (Config.uranusSpaceStation && Config.uranus) {
            uranusSpaceStation = new Satellite("spaceStation.uranus").setParentBody(ExtraPlanets_Planets.uranus);
            uranusSpaceStation.setRelativeSize(0.2667f);
            uranusSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            uranusSpaceStation.setRelativeOrbitTime(20.0f);
            uranusSpaceStation.setTierRequired(ExtraPlanets_Planets.uranus.getTierRequirement());
            uranusSpaceStation.setDimensionInfo(Config.uranusSpaceStationID, Config.uranusSpaceStationStaticID, WorldProviderUranusOrbit.class);
            uranusSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
        if (Config.neptuneSpaceStation && Config.neptune) {
            neptuneSpaceStation = new Satellite("spaceStation.neptune").setParentBody(ExtraPlanets_Planets.neptune);
            neptuneSpaceStation.setRelativeSize(0.2667f);
            neptuneSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            neptuneSpaceStation.setRelativeOrbitTime(20.0f);
            neptuneSpaceStation.setTierRequired(ExtraPlanets_Planets.neptune.getTierRequirement());
            neptuneSpaceStation.setDimensionInfo(Config.neptuneSpaceStationID, Config.neptuneSpaceStationStaticID, WorldProviderNeptuneOrbit.class);
            neptuneSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
        if (Config.plutoSpaceStation && Config.pluto) {
            plutoSpaceStation = new Satellite("spaceStation.pluto").setParentBody(ExtraPlanets_Planets.pluto);
            plutoSpaceStation.setRelativeSize(0.2667f);
            plutoSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            plutoSpaceStation.setRelativeOrbitTime(20.0f);
            plutoSpaceStation.setTierRequired(ExtraPlanets_Planets.pluto.getTierRequirement());
            plutoSpaceStation.setDimensionInfo(Config.plutoSpaceStationID, Config.plutoSpaceStationStaticID, WorldProviderPlutoOrbit.class);
            plutoSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
        if (Config.erisSpaceStation && Config.eris) {
            erisSpaceStation = new Satellite("spaceStation.eris").setParentBody(ExtraPlanets_Planets.eris);
            erisSpaceStation.setRelativeSize(0.2667f);
            erisSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            erisSpaceStation.setRelativeOrbitTime(20.0f);
            erisSpaceStation.setTierRequired(ExtraPlanets_Planets.eris.getTierRequirement());
            erisSpaceStation.setDimensionInfo(Config.erisSpaceStationID, Config.erisSpaceStationStaticID, WorldProviderErisOrbit.class);
            erisSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
        if (Config.kepler22bSpaceStation && Config.kepler22b && Config.keplerSolarSystems) {
            kepler22bSpaceStation = new Satellite("spaceStation.kepler22b").setParentBody(ExtraPlanets_Planets.kepler22b);
            kepler22bSpaceStation.setRelativeSize(0.2667f);
            kepler22bSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            kepler22bSpaceStation.setRelativeOrbitTime(20.0f);
            kepler22bSpaceStation.setTierRequired(ExtraPlanets_Planets.kepler22b.getTierRequirement());
            kepler22bSpaceStation.setDimensionInfo(Config.kepler22bSpaceStationID, Config.kepler22bSpaceStationStaticID, WorldProviderKepler22bOrbit.class);
            kepler22bSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
        }
    }

    private static void registerSatellites() {
        if (Config.mercurySpaceStation && Config.mercury) {
            GalaxyRegistry.registerSatellite((Satellite)mercurySpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderMercuryOrbit.class, (ITeleportType)new TeleportTypeMercuryOrbit());
            GalacticraftRegistry.registerProvider((int)Config.mercurySpaceStationID, WorldProviderMercuryOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.mercurySpaceStationStaticID, WorldProviderMercuryOrbit.class, (boolean)true, (int)0);
        }
        if (Config.venusSpaceStation && Config.venus) {
            GalaxyRegistry.registerSatellite((Satellite)venusSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderVenusOrbit.class, (ITeleportType)new TeleportTypeVenusOrbit());
            GalacticraftRegistry.registerProvider((int)Config.venusSpaceStationID, WorldProviderVenusOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.venusSpaceStationStaticID, WorldProviderVenusOrbit.class, (boolean)true, (int)0);
        }
        if (Config.ceresSpaceStation && Config.ceres) {
            GalaxyRegistry.registerSatellite((Satellite)ceresSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderCeresOrbit.class, (ITeleportType)new TeleportTypeCeresOrbit());
            GalacticraftRegistry.registerProvider((int)Config.ceresSpaceStationID, WorldProviderCeresOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.ceresSpaceStationStaticID, WorldProviderCeresOrbit.class, (boolean)true, (int)0);
        }
        if (Config.marsSpaceStation && MarsModule.planetMars != null) {
            GalaxyRegistry.registerSatellite((Satellite)marsSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderMarsOrbit.class, (ITeleportType)new TeleportTypeMarsOrbit());
            GalacticraftRegistry.registerProvider((int)Config.marsSpaceStationID, WorldProviderMarsOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.marsSpaceStationStaticID, WorldProviderMarsOrbit.class, (boolean)true, (int)0);
        }
        if (Config.jupiterSpaceStation && Config.jupiter) {
            GalaxyRegistry.registerSatellite((Satellite)jupiterSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderJupiterOrbit.class, (ITeleportType)new TeleportTypeJupiterOrbit());
            GalacticraftRegistry.registerProvider((int)Config.jupiterSpaceStationID, WorldProviderJupiterOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.jupiterSpaceStationStaticID, WorldProviderJupiterOrbit.class, (boolean)true, (int)0);
        }
        if (Config.saturnSpaceStation && Config.saturn) {
            GalaxyRegistry.registerSatellite((Satellite)saturnSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderSaturnOrbit.class, (ITeleportType)new TeleportTypeSaturnOrbit());
            GalacticraftRegistry.registerProvider((int)Config.saturnSpaceStationID, WorldProviderSaturnOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.saturnSpaceStationStaticID, WorldProviderSaturnOrbit.class, (boolean)true, (int)0);
        }
        if (Config.uranusSpaceStation && Config.uranus) {
            GalaxyRegistry.registerSatellite((Satellite)uranusSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderUranusOrbit.class, (ITeleportType)new TeleportTypeUranusOrbit());
            GalacticraftRegistry.registerProvider((int)Config.uranusSpaceStationID, WorldProviderUranusOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.uranusSpaceStationStaticID, WorldProviderUranusOrbit.class, (boolean)true, (int)0);
        }
        if (Config.neptuneSpaceStation && Config.neptune) {
            GalaxyRegistry.registerSatellite((Satellite)neptuneSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderNeptuneOrbit.class, (ITeleportType)new TeleportTypeNeptuneOrbit());
            GalacticraftRegistry.registerProvider((int)Config.neptuneSpaceStationID, WorldProviderNeptuneOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.neptuneSpaceStationStaticID, WorldProviderNeptuneOrbit.class, (boolean)true, (int)0);
        }
        if (Config.plutoSpaceStation && Config.pluto) {
            GalaxyRegistry.registerSatellite((Satellite)plutoSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderPlutoOrbit.class, (ITeleportType)new TeleportTypePlutoOrbit());
            GalacticraftRegistry.registerProvider((int)Config.plutoSpaceStationID, WorldProviderPlutoOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.plutoSpaceStationStaticID, WorldProviderPlutoOrbit.class, (boolean)true, (int)0);
        }
        if (Config.erisSpaceStation && Config.eris) {
            GalaxyRegistry.registerSatellite((Satellite)erisSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderErisOrbit.class, (ITeleportType)new TeleportTypeErisOrbit());
            GalacticraftRegistry.registerProvider((int)Config.erisSpaceStationID, WorldProviderErisOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.erisSpaceStationStaticID, WorldProviderErisOrbit.class, (boolean)true, (int)0);
        }
        if (Config.kepler22bSpaceStation && Config.kepler22b && Config.keplerSolarSystems) {
            GalaxyRegistry.registerSatellite((Satellite)kepler22bSpaceStation);
            GalacticraftRegistry.registerTeleportType(WorldProviderKepler22bOrbit.class, (ITeleportType)new TeleportTypeKepler22bOrbit());
            GalacticraftRegistry.registerProvider((int)Config.kepler22bSpaceStationID, WorldProviderKepler22bOrbit.class, (boolean)false, (int)0);
            GalacticraftRegistry.registerProvider((int)Config.kepler22bSpaceStationStaticID, WorldProviderKepler22bOrbit.class, (boolean)true, (int)0);
        }
    }
}

