/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.moons.Io.worldgen;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.moons.Io.worldgen.BiomeDecoratorIo;
import com.mjr.extraplanets.moons.Io.worldgen.biomes.BiomeGenIo;
import com.mjr.extraplanets.moons.Io.worldgen.biomes.BiomeGenIoAshLands;
import com.mjr.extraplanets.moons.Io.worldgen.biomes.BiomeGenIoBurningPlains;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;

public class IoBiomes
extends BiomeGenBase {
    public static final BiomeGenBase io = new BiomeGenIo(Config.ioBiomeID).func_76735_a("io").func_150570_a(new BiomeGenBase.Height(0.125f, 0.05f));
    public static final BiomeGenBase ioAshLands = new BiomeGenIoAshLands(Config.ioAshLandsBiomeID).func_76735_a("ioAshLands").func_150570_a(new BiomeGenBase.Height(2.0f, 2.0f));
    public static final BiomeGenBase ioBurningPlains = new BiomeGenIoBurningPlains(Config.ioBurningPlainsBiomeID).func_76735_a("ioBurningPlains").func_150570_a(new BiomeGenBase.Height(0.125f, 0.015f));
    protected Block stoneBlock;
    protected byte topMeta;
    protected byte fillerMeta;
    protected byte stoneMeta;

    protected IoBiomes(int id) {
        super(id);
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76762_K.clear();
        this.field_82914_M.clear();
        this.field_76751_G = 0.0f;
        this.field_76765_S = false;
        this.field_76766_R = false;
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 10, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 10, 4, 4));
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorIo();
    }

    protected BiomeDecorator getBiomeDecorator() {
        return this.field_76760_I;
    }

    public void func_150573_a(World world, Random rand, Block[] block, byte[] meta, int x, int z, double stoneNoise) {
        this.generateBiomeTerrain(world, rand, block, meta, x, z, stoneNoise);
    }

    public void generateBiomeTerrain(World world, Random rand, Block[] block, byte[] meta, int x, int z, double stoneNoise) {
        Block topBlock = this.field_76752_A;
        byte topMeta = this.topMeta;
        Block fillerBlock = this.field_76753_B;
        byte fillerMeta = this.fillerMeta;
        int currentFillerDepth = -1;
        int maxFillerDepth = (int)(stoneNoise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int maskX = x & 0xF;
        int maskZ = z & 0xF;
        int worldHeight = block.length / 256;
        int seaLevel = 63;
        for (int y = 255; y >= 0; --y) {
            int index = (maskZ * 16 + maskX) * worldHeight + y;
            if (y <= 0 + rand.nextInt(5)) {
                block[index] = Blocks.field_150357_h;
                continue;
            }
            Block currentBlock = block[index];
            if (currentBlock == null || currentBlock.func_149688_o() == Material.field_151579_a || currentBlock != Blocks.field_150348_b) continue;
            if (this.stoneBlock != null) {
                block[index] = this.stoneBlock;
                meta[index] = this.stoneMeta;
            }
            if (currentFillerDepth == -1) {
                if (maxFillerDepth <= 0) {
                    topBlock = null;
                    topMeta = 0;
                    fillerBlock = ExtraPlanets_Blocks.ioBlocks;
                    fillerMeta = 1;
                } else if (y >= seaLevel - 4 && y <= seaLevel) {
                    topBlock = this.field_76752_A;
                    topMeta = this.topMeta;
                    fillerBlock = this.field_76753_B;
                    fillerMeta = 0;
                }
                if (y < seaLevel && (topBlock == null || topBlock.func_149688_o() == Material.field_151579_a)) {
                    if (this.func_150564_a(x, y, z) < 0.15f) {
                        topBlock = Blocks.field_150432_aD;
                        topMeta = 0;
                    } else {
                        topBlock = Blocks.field_150355_j;
                        topMeta = 0;
                    }
                }
                currentFillerDepth = maxFillerDepth;
                if (y >= seaLevel - 2) {
                    block[index] = topBlock;
                    meta[index] = topMeta;
                    continue;
                }
                if (y < seaLevel - 0 - maxFillerDepth) {
                    topBlock = null;
                    fillerBlock = ExtraPlanets_Blocks.ioBlocks;
                    fillerMeta = 1;
                    block[index] = Blocks.field_150351_n;
                    continue;
                }
                block[index] = fillerBlock;
                meta[index] = fillerMeta;
                continue;
            }
            if (currentFillerDepth <= 0) continue;
            block[index] = fillerBlock;
            meta[index] = fillerMeta;
            if (--currentFillerDepth != 0 || fillerBlock != Blocks.field_150354_m) continue;
            currentFillerDepth = rand.nextInt(4) + Math.max(0, y - (seaLevel - 1));
            fillerBlock = Blocks.field_150322_A;
            fillerMeta = 0;
        }
    }
}

