/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.moons;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.moons.Callisto.TeleportTypeCallisto;
import com.mjr.extraplanets.moons.Callisto.WorldProviderCallisto;
import com.mjr.extraplanets.moons.Deimos.TeleportTypeDeimos;
import com.mjr.extraplanets.moons.Deimos.WorldProviderDeimos;
import com.mjr.extraplanets.moons.Europa.TeleportTypeEuropa;
import com.mjr.extraplanets.moons.Europa.WorldProviderEuropa;
import com.mjr.extraplanets.moons.Ganymede.TeleportTypeGanymede;
import com.mjr.extraplanets.moons.Ganymede.WorldProviderGanymede;
import com.mjr.extraplanets.moons.Iapetus.TeleportTypeIapetus;
import com.mjr.extraplanets.moons.Iapetus.WorldProviderIapetus;
import com.mjr.extraplanets.moons.Io.TeleportTypeIo;
import com.mjr.extraplanets.moons.Io.WorldProviderIo;
import com.mjr.extraplanets.moons.Oberon.TeleportTypeOberon;
import com.mjr.extraplanets.moons.Oberon.WorldProviderOberon;
import com.mjr.extraplanets.moons.Phobos.TeleportTypePhobos;
import com.mjr.extraplanets.moons.Phobos.WorldProviderPhobos;
import com.mjr.extraplanets.moons.Rhea.TeleportTypeRhea;
import com.mjr.extraplanets.moons.Rhea.WorldProviderRhea;
import com.mjr.extraplanets.moons.Titan.TeleportTypeTitan;
import com.mjr.extraplanets.moons.Titan.WorldProviderTitan;
import com.mjr.extraplanets.moons.Titania.TeleportTypeTitania;
import com.mjr.extraplanets.moons.Titania.WorldProviderTitania;
import com.mjr.extraplanets.moons.Triton.TeleportTypeTriton;
import com.mjr.extraplanets.moons.Triton.WorldProviderTriton;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.util.RegisterHelper;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.util.ResourceLocation;

public class ExtraPlanets_Moons {
    public static Moon triton;
    public static Moon callisto;
    public static Moon europa;
    public static Moon ganymede;
    public static Moon io;
    public static Moon deimos;
    public static Moon phobos;
    public static Moon iapetus;
    public static Moon rhea;
    public static Moon titan;
    public static Moon oberon;
    public static Moon titania;
    public static Moon charon;
    public static Moon nix;
    public static Moon hydra;
    public static Moon dysnomia;

    public static void init() {
        ExtraPlanets_Moons.initializeMoons();
        ExtraPlanets_Moons.registerMoons();
        ExtraPlanets_Moons.initializeUnReachableMoons();
    }

    public static void initializeUnReachableMoons() {
        charon = RegisterHelper.registerUnreachableMoon("charon", ExtraPlanets_Planets.pluto);
        if (charon != null) {
            charon.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f)).setRelativeOrbitTime(25.578575f);
        }
        if ((nix = RegisterHelper.registerUnreachableMoon("nix", ExtraPlanets_Planets.pluto)) != null) {
            nix.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(18.0f, 18.0f)).setRelativeOrbitTime(57.415455f);
        }
        if ((hydra = RegisterHelper.registerUnreachableMoon("hydra", ExtraPlanets_Planets.pluto)) != null) {
            hydra.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(27.0f, 27.0f)).setRelativeOrbitTime(123.252594f);
        }
        if ((dysnomia = RegisterHelper.registerUnreachableMoon("dysnomia", ExtraPlanets_Planets.eris)) != null) {
            dysnomia.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f)).setRelativeOrbitTime(25.578575f);
        }
    }

    private static void initializeMoons() {
        if (Config.triton) {
            triton = new Moon("triton").setParentPlanet(ExtraPlanets_Planets.neptune);
            triton.setPhaseShift(2.436f);
            triton.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
            triton.setRelativeOrbitTime(75.0f);
            triton.setTierRequired(7);
            triton.setRelativeSize(0.3867f);
            triton.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            triton.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/triton.png"));
            triton.setDimensionInfo(Config.tritonID, WorldProviderTriton.class);
        }
        if (Config.phobos) {
            phobos = new Moon("phobos").setParentPlanet(MarsModule.planetMars);
            phobos.setPhaseShift(2.436f);
            phobos.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
            phobos.setRelativeOrbitTime(25.578575f);
            phobos.setTierRequired(2);
            phobos.setRelativeSize(0.3867f);
            phobos.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            phobos.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/phobos.png"));
            phobos.setDimensionInfo(Config.phobosID, WorldProviderPhobos.class);
        }
        if (Config.deimos) {
            deimos = new Moon("deimos").setParentPlanet(MarsModule.planetMars);
            deimos.setPhaseShift(2.436f);
            deimos.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(18.0f, 18.0f));
            deimos.setRelativeOrbitTime(57.415455f);
            deimos.setTierRequired(2);
            deimos.setRelativeSize(0.3867f);
            deimos.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            deimos.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/deimos.png"));
            deimos.setDimensionInfo(Config.deimosID, WorldProviderDeimos.class);
        }
        if (Config.io) {
            io = new Moon("io").setParentPlanet(ExtraPlanets_Planets.jupiter);
            io.setPhaseShift(2.436f);
            io.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
            io.setRelativeOrbitTime(43.59977f);
            io.setTierRequired(4);
            io.setRelativeSize(0.3867f);
            io.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            io.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/io.png"));
            io.setDimensionInfo(Config.ioID, WorldProviderIo.class);
        }
        if (Config.europa) {
            europa = new Moon("europa").setParentPlanet(ExtraPlanets_Planets.jupiter);
            europa.setPhaseShift(2.436f);
            europa.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(18.0f, 18.0f));
            europa.setRelativeOrbitTime(87.55354f);
            europa.setTierRequired(4);
            europa.setRelativeSize(0.3867f);
            europa.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            europa.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/europa.png"));
            europa.setDimensionInfo(Config.europaID, WorldProviderEuropa.class);
        }
        if (Config.ganymede) {
            ganymede = new Moon("ganymede").setParentPlanet(ExtraPlanets_Planets.jupiter);
            ganymede.setPhaseShift(2.436f);
            ganymede.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(27.0f, 27.0f));
            ganymede.setRelativeOrbitTime(123.252594f);
            ganymede.setTierRequired(4);
            ganymede.setRelativeSize(0.3867f);
            ganymede.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            ganymede.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/ganymede.png"));
            ganymede.setDimensionInfo(Config.ganymedeID, WorldProviderGanymede.class);
        }
        if (Config.callisto) {
            callisto = new Moon("callisto").setParentPlanet(ExtraPlanets_Planets.jupiter);
            callisto.setPhaseShift(2.436f);
            callisto.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(36.0f, 36.0f));
            callisto.setRelativeOrbitTime(157.84525f);
            callisto.setTierRequired(4);
            callisto.setRelativeSize(0.3867f);
            callisto.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            callisto.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/callisto.png"));
            callisto.setDimensionInfo(Config.callistoID, WorldProviderCallisto.class);
        }
        if (Config.rhea) {
            rhea = new Moon("rhea").setParentPlanet(ExtraPlanets_Planets.saturn);
            rhea.setPhaseShift(1.45f);
            rhea.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
            rhea.setRelativeOrbitTime(42.74915f);
            rhea.setTierRequired(5);
            rhea.setRelativeSize(0.3867f);
            rhea.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            rhea.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/rhea.png"));
            rhea.setDimensionInfo(Config.rheaID, WorldProviderRhea.class);
        }
        if (Config.titan) {
            titan = new Moon("titan").setParentPlanet(ExtraPlanets_Planets.saturn);
            titan.setPhaseShift(1.45f);
            titan.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(18.0f, 18.0f));
            titan.setRelativeOrbitTime(71.452415f);
            titan.setTierRequired(5);
            titan.setRelativeSize(0.3867f);
            titan.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            titan.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/titan.png"));
            titan.setDimensionInfo(Config.titanID, WorldProviderTitan.class);
        }
        if (Config.oberon) {
            oberon = new Moon("oberon").setParentPlanet(ExtraPlanets_Planets.uranus);
            oberon.setPhaseShift(1.45f);
            oberon.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(18.0f, 18.0f));
            oberon.setRelativeOrbitTime(68.54119f);
            oberon.setTierRequired(6);
            oberon.setRelativeSize(0.3867f);
            oberon.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            oberon.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/oberon.png"));
            oberon.setDimensionInfo(Config.oberonID, WorldProviderOberon.class);
        }
        if (Config.titania) {
            titania = new Moon("titania").setParentPlanet(ExtraPlanets_Planets.uranus);
            titania.setPhaseShift(1.45f);
            titania.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
            titania.setRelativeOrbitTime(68.54119f);
            titania.setTierRequired(6);
            titania.setRelativeSize(0.3867f);
            titania.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            titania.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/titania.png"));
            titania.setDimensionInfo(Config.titaniaID, WorldProviderTitania.class);
        }
        if (Config.iapetus) {
            iapetus = new Moon("iapetus").setParentPlanet(ExtraPlanets_Planets.saturn);
            iapetus.setPhaseShift(1.45f);
            iapetus.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(27.0f, 27.0f));
            iapetus.setRelativeOrbitTime(68.54119f);
            iapetus.setTierRequired(6);
            iapetus.setRelativeSize(0.3867f);
            iapetus.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.METHANE);
            iapetus.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/iapetus.png"));
            iapetus.setDimensionInfo(Config.iapetusID, WorldProviderIapetus.class);
        }
    }

    private static void registerMoons() {
        if (Config.triton) {
            GalaxyRegistry.registerMoon((Moon)triton);
            GalacticraftRegistry.registerTeleportType(WorldProviderTriton.class, (ITeleportType)new TeleportTypeTriton());
            GalacticraftRegistry.registerRocketGui(WorldProviderTriton.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/triton_rocket_gui.png"));
        }
        if (Config.europa) {
            GalaxyRegistry.registerMoon((Moon)europa);
            GalacticraftRegistry.registerTeleportType(WorldProviderEuropa.class, (ITeleportType)new TeleportTypeEuropa());
            GalacticraftRegistry.registerRocketGui(WorldProviderEuropa.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/europa_rocket_gui.png"));
        }
        if (Config.io) {
            GalaxyRegistry.registerMoon((Moon)io);
            GalacticraftRegistry.registerTeleportType(WorldProviderIo.class, (ITeleportType)new TeleportTypeIo());
            GalacticraftRegistry.registerRocketGui(WorldProviderIo.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/io_rocket_gui.png"));
        }
        if (Config.deimos) {
            GalaxyRegistry.registerMoon((Moon)deimos);
            GalacticraftRegistry.registerTeleportType(WorldProviderDeimos.class, (ITeleportType)new TeleportTypeDeimos());
            GalacticraftRegistry.registerRocketGui(WorldProviderDeimos.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/deimos_rocket_gui.png"));
        }
        if (Config.phobos) {
            GalaxyRegistry.registerMoon((Moon)phobos);
            GalacticraftRegistry.registerTeleportType(WorldProviderPhobos.class, (ITeleportType)new TeleportTypePhobos());
            GalacticraftRegistry.registerRocketGui(WorldProviderPhobos.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/phobos_rocket_gui.png"));
        }
        if (Config.callisto) {
            GalaxyRegistry.registerMoon((Moon)callisto);
            GalacticraftRegistry.registerTeleportType(WorldProviderCallisto.class, (ITeleportType)new TeleportTypeCallisto());
            GalacticraftRegistry.registerRocketGui(WorldProviderCallisto.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/callisto_rocket_gui.png"));
        }
        if (Config.ganymede) {
            GalaxyRegistry.registerMoon((Moon)ganymede);
            GalacticraftRegistry.registerTeleportType(WorldProviderGanymede.class, (ITeleportType)new TeleportTypeGanymede());
            GalacticraftRegistry.registerRocketGui(WorldProviderGanymede.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/ganymede_rocket_gui.png"));
        }
        if (Config.rhea) {
            GalaxyRegistry.registerMoon((Moon)rhea);
            GalacticraftRegistry.registerTeleportType(WorldProviderRhea.class, (ITeleportType)new TeleportTypeRhea());
            GalacticraftRegistry.registerRocketGui(WorldProviderRhea.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/rhea_rocket_gui.png"));
        }
        if (Config.titan) {
            GalaxyRegistry.registerMoon((Moon)titan);
            GalacticraftRegistry.registerTeleportType(WorldProviderTitan.class, (ITeleportType)new TeleportTypeTitan());
            GalacticraftRegistry.registerRocketGui(WorldProviderTitan.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/titan_rocket_gui.png"));
        }
        if (Config.oberon) {
            GalaxyRegistry.registerMoon((Moon)oberon);
            GalacticraftRegistry.registerTeleportType(WorldProviderOberon.class, (ITeleportType)new TeleportTypeOberon());
            GalacticraftRegistry.registerRocketGui(WorldProviderOberon.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/oberon_rocket_gui.png"));
        }
        if (Config.titania) {
            GalaxyRegistry.registerMoon((Moon)titania);
            GalacticraftRegistry.registerTeleportType(WorldProviderTitania.class, (ITeleportType)new TeleportTypeTitania());
            GalacticraftRegistry.registerRocketGui(WorldProviderTitania.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/titania_rocket_gui.png"));
        }
        if (Config.iapetus) {
            GalaxyRegistry.registerMoon((Moon)iapetus);
            GalacticraftRegistry.registerTeleportType(WorldProviderIapetus.class, (ITeleportType)new TeleportTypeIapetus());
            GalacticraftRegistry.registerRocketGui(WorldProviderIapetus.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/iapetus_rocket_gui.png"));
        }
    }
}

