/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.blocks.machines;

import com.mjr.extraplanets.ExtraPlanets;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.proxy.ClientProxy;
import com.mjr.extraplanets.tileEntities.machines.TileEntityVehicleChanger;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class VehicleCharger
extends BlockAdvancedTile {
    private IIcon iconMachineSide;
    private IIcon iconInput;
    private IIcon iconFront;
    private IIcon iconFuelInput;

    public VehicleCharger(String assetName) {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
        this.func_149647_a(ExtraPlanets.BlocksTab);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return ClientProxy.getBlockRender((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_input");
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.iconFront = par1IconRegister.func_94245_a("extraplanets:machine_vehicle_charger");
        this.iconFuelInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityVehicleChanger();
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)ExtraPlanets.instance, -1, world, x, y, z);
        return true;
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.iconMachineSide;
        }
        if (side == metadata + 2) {
            return this.iconInput;
        }
        if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
            return this.iconFuelInput;
        }
        return this.iconFront;
    }

    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int change = 0;
        switch (par1World.func_72805_g(x, y, z)) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        par1World.func_72921_c(x, y, z, change, 3);
        TileEntity te = par1World.func_147438_o(x, y, z);
        if (te instanceof TileBaseUniversalElectrical) {
            ((TileBaseUniversalElectrical)te).updateFacing();
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, change, 3);
        for (int dX = -2; dX < 3; ++dX) {
            for (int dZ = -2; dZ < 3; ++dZ) {
                Block block = world.func_147439_a(x + dX, y, z + dZ);
                if (block != ExtraPlanets_Blocks.advancedLaunchPadFull) continue;
                world.func_147471_g(x + dX, y, z + dZ);
            }
        }
    }

    public void func_149664_b(World world, int x, int y, int z, int par5) {
        super.func_149664_b(world, x, y, z, par5);
        for (int dX = -2; dX < 3; ++dX) {
            for (int dZ = -2; dZ < 3; ++dZ) {
                Block block = world.func_147439_a(x + dX, y, z + dZ);
                if (block != ExtraPlanets_Blocks.advancedLaunchPadFull) continue;
                world.func_147471_g(x + dX, y, z + dZ);
            }
        }
    }
}

