/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets;

import com.mjr.extraplanets.Config;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.util.ResourceLocation;

public class ExtraPlanets_SolarSystems {
    public static SolarSystem kepler22;
    public static SolarSystem kepler47;
    public static SolarSystem kepler62;
    public static SolarSystem kepler69;

    public static void init() {
        ExtraPlanets_SolarSystems.initializeSolarSystems();
        ExtraPlanets_SolarSystems.registerSolarSystems();
    }

    private static void initializeSolarSystems() {
        if (Config.keplerSolarSystems) {
            kepler22 = new SolarSystem("kepler22", "milkyWay").setMapPosition(new Vector3(90.0f + Config.kepler22SystemYawOffset, 30.0f + Config.kepler22SystemPitchOffset));
            Star starSol = (Star)new Star("kepler22").setParentSolarSystem(kepler22).setTierRequired(-1);
            starSol.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/sun.png"));
            kepler22.setMainStar(starSol);
            kepler47 = new SolarSystem("kepler47", "milkyWay").setMapPosition(new Vector3(-40.0f + Config.kepler47SystemYawOffset, -120.0f + Config.kepler47SystemPitchOffset));
            Star starSol2 = (Star)new Star("kepler47").setParentSolarSystem(kepler47).setTierRequired(-1);
            starSol2.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/sun.png"));
            kepler47.setMainStar(starSol2);
            kepler62 = new SolarSystem("kepler62", "milkyWay").setMapPosition(new Vector3(90.0f + Config.kepler62SystemYawOffset, -90.0f + Config.kepler62SystemPitchOffset));
            Star starSol3 = (Star)new Star("kepler62").setParentSolarSystem(kepler62).setTierRequired(-1);
            starSol3.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/sun.png"));
            kepler62.setMainStar(starSol3);
            kepler69 = new SolarSystem("kepler69", "milkyWay").setMapPosition(new Vector3(-60.0f + Config.kepler69SystemYawOffset, 0.0f + Config.kepler69SystemPitchOffset));
            Star starSol4 = (Star)new Star("kepler69").setParentSolarSystem(kepler69).setTierRequired(-1);
            starSol4.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/sun.png"));
            kepler69.setMainStar(starSol4);
        }
    }

    private static void registerSolarSystems() {
        if (Config.keplerSolarSystems) {
            GalaxyRegistry.registerSolarSystem((SolarSystem)kepler22);
            GalaxyRegistry.registerSolarSystem((SolarSystem)kepler47);
            GalaxyRegistry.registerSolarSystem((SolarSystem)kepler62);
            GalaxyRegistry.registerSolarSystem((SolarSystem)kepler69);
        }
    }
}

