/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.network.serverSide;

import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.entities.EntityChocoboRideable;
import chococraft.common.network.PacketHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class ChocoboMount
implements IMessage {
    public int entityID;
    public String playerName;
    public int dimensionId;

    public ChocoboMount() {
    }

    public ChocoboMount(EntityChocoboRideable chocobo) {
        this.entityID = chocobo.func_145782_y();
        this.playerName = FMLClientHandler.instance().getClient().field_71439_g.getDisplayName();
        this.dimensionId = chocobo.field_70170_p.field_73011_w.field_76574_g;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playerName);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboMount, IMessage> {
        public IMessage onMessage(ChocoboMount message, MessageContext ctx) {
            EntityAnimalChocobo chocobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chocobo != null && chocobo instanceof EntityChocoboRideable) {
                EntityChocoboRideable chocoboRideable = (EntityChocoboRideable)chocobo;
                if (message.playerName.isEmpty()) {
                    chocoboRideable.field_70153_n = null;
                    chocoboRideable.func_70637_d(false);
                    chocoboRideable.setStepHeight(false);
                    chocoboRideable.setLandSpeedFactor(false);
                    chocoboRideable.setJumpHigh(false);
                } else {
                    EntityPlayer rider = PacketHelper.getPlayer(message.playerName, message.dimensionId);
                    rider.func_70031_b(false);
                    rider.func_70078_a((Entity)chocoboRideable);
                    chocoboRideable.setStepHeight(true);
                    chocoboRideable.setLandSpeedFactor(true);
                    chocoboRideable.setJumpHigh(true);
                }
            }
            return null;
        }
    }
}

