/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.network.clientSide;

import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.network.PacketHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class ChocoboHunger
implements IMessage {
    public int entityID;
    public int hungerTime;
    public int dimensionId;

    public ChocoboHunger() {
    }

    public ChocoboHunger(EntityAnimalChocobo chocobo) {
        this.entityID = chocobo.func_145782_y();
        this.hungerTime = chocobo.getTimeUntilHunger();
        this.dimensionId = chocobo.field_70170_p.field_73011_w.field_76574_g;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeInt(this.hungerTime);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.hungerTime = buffer.readInt();
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboHunger, IMessage> {
        public IMessage onMessage(ChocoboHunger message, MessageContext ctx) {
            EntityAnimalChocobo chocobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chocobo != null) {
                chocobo.setTimeUntilHunger(message.hungerTime);
            }
            return null;
        }
    }
}

