/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.entities.spawner;

import chococraft.common.ModChocoCraft;
import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.entities.EntityChocobo;
import chococraft.common.entities.FactoryEntityChocobo;
import chococraft.common.helper.ChocoboBiomeHelper;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public final class ChocoboSpawner {
    public static void doChocoboSpawning(World world, double posX, double posY, double posZ) {
        if (!world.field_72995_K) {
            int chunkPosZ_0;
            int maxTries = 20;
            int d100 = world.field_73012_v.nextInt(100);
            if (d100 > ModChocoCraft.spawnProbability) {
                ModChocoCraft.spawnDbStatus = "< prob";
                return;
            }
            int outerSpawnRadius = 64;
            int innerSpawnRadius = 32;
            if (ChocoboBiomeHelper.isWorldHell(world)) {
                outerSpawnRadius = 48;
                innerSpawnRadius = 32;
            }
            int randDeltaX = 0;
            int randDeltaZ = 0;
            Boolean canSpawnHere = false;
            for (int i = 0; i < maxTries; ++i) {
                randDeltaX = world.field_73012_v.nextInt(outerSpawnRadius) + innerSpawnRadius;
                randDeltaZ = world.field_73012_v.nextInt(outerSpawnRadius) + innerSpawnRadius;
                if (world.field_73012_v.nextBoolean()) {
                    randDeltaX *= -1;
                }
                if (world.field_73012_v.nextBoolean()) {
                    randDeltaZ *= -1;
                }
                canSpawnHere = ChocoboSpawner.canChocoboSpawnInBiome(world, posX + (double)randDeltaX, posZ + (double)randDeltaZ);
                if (ChocoboBiomeHelper.isWorldHell(world)) {
                    canSpawnHere = true;
                }
                boolean otherPlayerNear = ChocoboSpawner.isOtherPlayerNear(world, posX + (double)randDeltaX, posZ + (double)randDeltaZ, innerSpawnRadius / 2);
                if (canSpawnHere.booleanValue() && otherPlayerNear) {
                    canSpawnHere = false;
                }
                if (canSpawnHere.booleanValue()) break;
            }
            if (!canSpawnHere.booleanValue()) {
                ModChocoCraft.spawnDbStatus = "not found";
                return;
            }
            int chunkPosX_0 = MathHelper.func_76128_c((double)(posX + (double)randDeltaX));
            int wildInChunks = ChocoboSpawner.countWildInChunkRadius(world, chunkPosX_0, chunkPosZ_0 = MathHelper.func_76128_c((double)(posZ + (double)randDeltaZ)), ModChocoCraft.spawnLimitChunkRadius);
            if (wildInChunks > ModChocoCraft.spawnTotalMax) {
                ModChocoCraft.spawnDbStatus = "to many (" + wildInChunks + ")";
                return;
            }
            int distanceNextWild = ChocoboSpawner.distanceToNextWild(world, chunkPosX_0, chunkPosZ_0);
            if (distanceNextWild < ModChocoCraft.spawnDistanceNextWild) {
                ModChocoCraft.spawnDbStatus = "to close (" + distanceNextWild + ")";
                return;
            }
            int spawnedChocobos = 0;
            int randomGroupSize = ModChocoCraft.spawnGroupMin;
            int groupSizeDelta = ModChocoCraft.spawnGroupMax - ModChocoCraft.spawnGroupMin;
            if (groupSizeDelta > 0) {
                randomGroupSize += world.field_73012_v.nextInt(groupSizeDelta);
            }
            for (int i = 0; i < maxTries; ++i) {
                int chocoPosX = (int)posX + randDeltaX + world.field_73012_v.nextInt(6);
                int chocoPosZ = (int)posZ + randDeltaZ + world.field_73012_v.nextInt(6);
                int chocoPosY = ChocoboBiomeHelper.isWorldHell(world) ? world.func_72825_h(chocoPosX, chocoPosZ) : world.func_72825_h(chocoPosX, chocoPosZ);
                int chocoRotYawn = world.field_73012_v.nextInt(360);
                Boolean canSpawnLoc = ChocoboSpawner.canChocoboSpawnAtLocation(world, chocoPosX, chocoPosY, chocoPosZ);
                if (canSpawnLoc.booleanValue()) {
                    EntityAnimalChocobo.chocoboColor color = ChocoboBiomeHelper.isWorldHell(world) ? EntityAnimalChocobo.chocoboColor.PURPLE : EntityAnimalChocobo.chocoboColor.YELLOW;
                    EntityChocobo newChocobo = FactoryEntityChocobo.createNewChocobo(world, color);
                    newChocobo.func_70012_b(chocoPosX, chocoPosY, chocoPosZ, chocoRotYawn, 0.0f);
                    world.func_72838_d((Entity)newChocobo);
                    if (++spawnedChocobos < randomGroupSize) continue;
                    break;
                }
                ModChocoCraft.spawnDbStatus = "not spawn at loc";
            }
            if (spawnedChocobos > 0) {
                ModChocoCraft.spawnDbStatus = spawnedChocobos + " spawned";
            }
        }
    }

    private static int countWildInChunkRadius(World world, int posX_0, int posZ_0, int chunkRadius) {
        int amount = 0;
        ArrayList<Chunk> targetChunks = new ArrayList<Chunk>();
        for (int posX = posX_0 - chunkRadius; posX <= posX_0 + chunkRadius; ++posX) {
            for (int posZ = posZ_0 - chunkRadius; posZ <= posZ_0 + chunkRadius; ++posZ) {
                Chunk tmpChunk = world.func_72938_d(posX, posZ);
                targetChunks.add(tmpChunk);
            }
        }
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Chunk entityChunk;
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityChocobo) || ((EntityChocobo)entity).func_70909_n() || !targetChunks.contains(entityChunk = world.func_72938_d(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70161_v)))) continue;
            ++amount;
        }
        return amount;
    }

    private static boolean isOtherPlayerNear(World world, double posX, double posZ, int distance) {
        int tmpPosX = MathHelper.func_76128_c((double)posX);
        int tmpPosZ = MathHelper.func_76128_c((double)posZ);
        int tmpPosY = ChocoboBiomeHelper.isWorldHell(world) ? world.func_72825_h(tmpPosX, tmpPosZ) : world.func_72825_h(tmpPosX, tmpPosZ);
        return world.func_72977_a((double)tmpPosX, (double)tmpPosY, (double)tmpPosZ, (double)distance) != null;
    }

    private static boolean canChocoboSpawnAtLocation(World world, int posX, int posY, int posZ) {
        if (!ChocoboSpawner.isNormalCubesAround(world, posX, posY - 1, posZ)) {
            return false;
        }
        if (ChocoboSpawner.isNormalCubesAround(world, posX, posY, posZ)) {
            return false;
        }
        if (world.func_147439_a(posX, posY, posZ).func_149688_o().func_76224_d()) {
            return false;
        }
        if (ChocoboSpawner.isNormalCubesAround(world, posX, posY + 1, posZ)) {
            return false;
        }
        return !ChocoboSpawner.isNormalCubesAround(world, posX, posY + 2, posZ);
    }

    private static boolean isNormalCubesAround(World world, int posX, int posY, int posZ) {
        for (int x = posX - 1; x <= posX + 1; ++x) {
            for (int z = posZ - 1; z <= posZ + 1; ++z) {
                if (world.func_147439_a(x, posY, z).func_149721_r()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canChocoboSpawnInBiome(World world, double posX, double posZ) {
        int intPosX = MathHelper.func_76128_c((double)posX);
        int intPosZ = MathHelper.func_76128_c((double)posZ);
        BiomeGenBase chocoBgb = world.func_72807_a(intPosX, intPosZ);
        if (null != ModChocoCraft.spawnBiomes) {
            for (int i = 0; i < ModChocoCraft.spawnBiomes.length; ++i) {
                if (!ModChocoCraft.spawnBiomes[i].equals(chocoBgb)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private static int distanceToNextWild(World world, double posX, double posZ) {
        double distance = 10000.0;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            double sqDistZ;
            double sqDistX;
            double tmpDistance;
            EntityChocobo chocobo;
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityChocobo) || (chocobo = (EntityChocobo)entity).func_70909_n() || !((tmpDistance = Math.sqrt((sqDistX = (posX - chocobo.field_70165_t) * (posX - chocobo.field_70165_t)) + (sqDistZ = (posZ - chocobo.field_70161_v) * (posZ - chocobo.field_70161_v)))) < distance)) continue;
            distance = tmpDistance;
        }
        return MathHelper.func_76128_c((double)distance);
    }
}

