/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.entities;

import chococraft.common.config.ChocoCraftItems;
import chococraft.common.config.Constants;
import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.entities.EntityChocobo;
import chococraft.common.entities.FactoryEntityChocobo;
import chococraft.common.helper.ChocoboEntityHelper;
import chococraft.common.network.PacketRegistry;
import chococraft.common.network.clientSide.ChicoboCanGrowUp;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityChicobo
extends EntityAnimalChocobo {
    public boolean growUp;

    public EntityChicobo(World world) {
        super(world);
        this.field_70180_af.func_75682_a(Constants.DW_ID_CHIC_FLAGS, (Object)0);
        this.field_70180_af.func_75682_a(Constants.DW_ID_CHIC_TIMEUNTILADULT, (Object)(this.field_70146_Z.nextInt(2000) + 27000));
        this.field_70180_af.func_75682_a(Constants.DW_ID_CHIC_COLOUR, (Object)this.color.ordinal());
        this.setColor(EntityAnimalChocobo.chocoboColor.YELLOW);
        this.func_70105_a(0.5f, 0.5f);
        this.growUp = false;
        this.canCrossWater = false;
        this.canFly = false;
        this.canClimb = false;
        this.field_70138_W = 0.5f;
        this.canJumpHigh = false;
        this.func_70873_a(this.getTimeUntilAdult());
    }

    @Override
    public boolean func_70650_aV() {
        return true;
    }

    public void setColor(EntityAnimalChocobo.chocoboColor color) {
        this.color = color;
        this.field_70180_af.func_75692_b(Constants.DW_ID_CHIC_COLOUR, (Object)color.ordinal());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getColorMaxHealth());
        this.func_70606_j(this.getColorMaxHealth());
        if (color == EntityAnimalChocobo.chocoboColor.PURPLE) {
            this.field_70178_ae = true;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeInt(this.color.ordinal());
        data.writeBoolean(this.growUp);
        data.writeBoolean(this.isCanGrowUp());
        data.writeInt(this.getTimeUntilAdult());
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        try {
            this.setColor(EntityAnimalChocobo.chocoboColor.values()[data.readInt()]);
            this.growUp = data.readBoolean();
            this.setCanGrowUp(data.readBoolean());
            this.setTimeUntilAdult(data.readInt());
        }
        catch (Exception e) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("TimeToAdult", this.getTimeUntilAdult());
        nbttagcompound.func_74778_a("Color", this.color.toString());
        nbttagcompound.func_74757_a("CanGrow", this.isCanGrowUp());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setTimeUntilAdult(nbttagcompound.func_74762_e("TimeToAdult"));
        this.setColor(EntityAnimalChocobo.chocoboColor.valueOf(nbttagcompound.func_74779_i("Color")));
        this.setCanGrowUp(nbttagcompound.func_74767_n("CanGrow"));
        this.setWander(this.isFollowing() == false);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("chococraft", this.getEntityTexture());
    }

    @Override
    public String getEntityTexture() {
        String s = Constants.CHICOBO_ENTITY_TEXTURES;
        if (this.func_70909_n()) {
            s = s + Constants.CHICOBO_ETXT_TAMED;
        }
        this.color = this.getColour();
        switch (this.color) {
            case YELLOW: {
                return s + "chocobo.png";
            }
            case GREEN: {
                return s + "greenchocobo.png";
            }
            case BLUE: {
                return s + "bluechocobo.png";
            }
            case WHITE: {
                return s + "whitechocobo.png";
            }
            case BLACK: {
                return s + "blackchocobo.png";
            }
            case GOLD: {
                return s + "goldchocobo.png";
            }
            case PINK: {
                return s + "pinkchocobo.png";
            }
            case RED: {
                return s + "redchocobo.png";
            }
            case PURPLE: {
                return s + "purplechocobo.png";
            }
        }
        return "";
    }

    public float getColorMaxHealth() {
        switch (this.color) {
            case YELLOW: 
            case GREEN: 
            case BLUE: {
                return 10.0f;
            }
            case WHITE: 
            case BLACK: {
                return 15.0f;
            }
            case GOLD: 
            case PINK: 
            case RED: 
            case PURPLE: {
                return 20.0f;
            }
        }
        return 10.0f;
    }

    public boolean isCanGrowUp() {
        return (this.field_70180_af.func_75683_a(Constants.DW_ID_CHIC_FLAGS) & 4) != 0;
    }

    public void setCanGrowUp(boolean canGrowUp) {
        byte watchedFlags = this.field_70180_af.func_75683_a(Constants.DW_ID_CHIC_FLAGS);
        if (canGrowUp) {
            this.field_70180_af.func_75692_b(Constants.DW_ID_CHIC_FLAGS, (Object)((byte)(watchedFlags | 4)));
        } else {
            this.field_70180_af.func_75692_b(Constants.DW_ID_CHIC_FLAGS, (Object)((byte)(watchedFlags & 0xFFFFFFFB)));
        }
    }

    public void setTimeUntilAdult(int timeUntilAdult) {
        this.field_70180_af.func_75692_b(Constants.DW_ID_CHIC_TIMEUNTILADULT, (Object)timeUntilAdult);
    }

    public int getTimeUntilAdult() {
        return this.field_70180_af.func_75679_c(Constants.DW_ID_CHIC_TIMEUNTILADULT);
    }

    public EntityAnimalChocobo.chocoboColor getColour() {
        int ordinal = this.field_70180_af.func_75679_c(Constants.DW_ID_CHIC_COLOUR);
        return EntityAnimalChocobo.chocoboColor.values()[ordinal];
    }

    @Override
    public boolean func_70631_g_() {
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.growUp) {
            this.setTimeUntilAdult(this.func_70874_b());
            this.setTimeUntilAdult(this.getTimeUntilAdult() - 1);
            this.func_70873_a(this.getTimeUntilAdult());
            if (this.getTimeUntilAdult() <= 0) {
                this.growUp = true;
                this.setCanGrowUp(true);
            }
        }
        this.doGrowUp();
    }

    protected void doGrowUp() {
        if (this.isServer() && this.growUp && this.isCanGrowUp() && ChocoboEntityHelper.isSpaceAroundFree(this.field_70170_p, (EntityLiving)this, 1, 3, 1)) {
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            EntityChocobo grownUpChocobo = FactoryEntityChocobo.createChocoboFromChocobo(this.field_70170_p, this);
            grownUpChocobo.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            grownUpChocobo.func_70873_a(6000);
            this.field_70170_p.func_72838_d((Entity)grownUpChocobo);
            this.sendParticleUpdate(Constants.PARTICLE_EXPLODE, grownUpChocobo, 7);
            this.func_70606_j(0.0f);
            this.func_70106_y();
            this.growUp = false;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected String func_70639_aQ() {
        if (this.field_70146_Z.nextInt(2) == 0) {
            return "chococraft:chico_kweh";
        }
        return null;
    }

    protected String func_70621_aR() {
        return "chococraft:chico_kweh";
    }

    protected String func_70673_aS() {
        return "chococraft:chico_kweh";
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack;
        boolean interacted = super.func_70085_c(entityplayer);
        if (!interacted && (itemstack = entityplayer.field_71071_by.func_70448_g()) != null) {
            if (itemstack.func_77973_b().equals(ChocoCraftItems.gysahlCakeItem)) {
                this.onGysahlCakeUse(entityplayer);
                interacted = true;
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.chocoboFeatherItem)) {
                this.onFeatherUse(entityplayer);
                interacted = true;
            }
        }
        return interacted;
    }

    protected void onGysahlCakeUse(EntityPlayer player) {
        if (this.isServer()) {
            if (this.func_70909_n() && this.isOwner(player)) {
                this.useItem(player);
                this.setCanGrowUp(true);
                this.growUp = true;
                this.sendCanGrowUpUpdate();
            } else {
                this.showAmountHeartsOrSmokeFx(false, 7);
            }
        }
    }

    public void onFeatherUse(EntityPlayer player) {
        if (this.func_70909_n() && this.isOwner(player)) {
            this.toggleFollowWanderStay();
        } else {
            this.showAmountHeartsOrSmokeFx(false, 7);
        }
    }

    @Override
    public void func_70626_be() {
        if (!this.func_70781_l() && this.isFollowing().booleanValue() && this.func_70909_n()) {
            EntityPlayer owner = this.getOwner();
            if (owner != null) {
                if (owner.field_70128_L) {
                    this.setFollowing(false);
                    this.setWander(false);
                    return;
                }
                float distanceToOwner = owner.func_70032_d((Entity)this);
                if (distanceToOwner > 10.0f) {
                    this.getPathOrWalkableBlock((Entity)owner, distanceToOwner);
                } else {
                    super.func_70626_be();
                    if (this.func_70090_H()) {
                        this.field_70181_x = 0.1;
                        this.func_70637_d(true);
                    }
                }
            }
        } else {
            super.func_70626_be();
            if (this.func_70090_H()) {
                this.field_70181_x = 0.1;
                this.func_70637_d(true);
            }
        }
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean canRenderName() {
        return super.canRenderName() && !this.getName().equals("");
    }

    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    public boolean func_70878_b(EntityAnimal entityAnimal) {
        return false;
    }

    protected void sendCanGrowUpUpdate() {
        if (this.isClient()) {
            ChicoboCanGrowUp packet = new ChicoboCanGrowUp(this);
            PacketRegistry.INSTANCE.sendToServer((IMessage)packet);
        }
    }
}

