/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.worldgen;

import com.gildedgames.util.core.nbt.NBT;
import com.gildedgames.util.core.nbt.NBTFactory;
import com.gildedgames.util.io_manager.factory.IOFactory;
import com.gildedgames.util.io_manager.util.IOUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.blocks.BlockAetherPortal;
import net.aetherteam.aether.data.AetherPortalPosition;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.world.ChunkEvent;

public class TeleporterAether
extends Teleporter
implements NBT {
    private WorldServer worldServerInstance;
    private final Random random;
    private static final int DOWN = 0;
    private static final int RIGHT = 1;
    private static final int UP = 2;
    private static final int LEFT = 3;
    private Map<AetherPortalPosition, AetherPortalPosition> portalPairsKV = new HashMap<AetherPortalPosition, AetherPortalPosition>();
    private HashMap<AetherPortalPosition, AetherPortalPosition> portalPairsVK = new HashMap();
    private World previousWorld;
    public static HashMap<ChunkCoordinates, Boolean> chunksMarkedForPortal = new HashMap();
    public boolean createPortal = true;

    public TeleporterAether(WorldServer worldServer) {
        super(worldServer);
        this.worldServerInstance = worldServer;
        this.worldServerInstance.customTeleporters.add(this);
        this.random = new Random(worldServer.func_72905_C());
    }

    public void markForPortals(int chunkX, int chunkZ) {
        int x = chunkX << 4;
        int z = chunkZ << 4;
        ChunkCoordinates chunkPosition = new ChunkCoordinates(chunkX, 0, chunkZ);
        for (int count = 0; count < 16; ++count) {
            int z1;
            int y1;
            int x1 = x + this.random.nextInt(16);
            Block block = this.worldServerInstance.func_147439_a(x1, y1 = this.getFirstUncoveredCoord((World)this.worldServerInstance, x1, z1 = z + this.random.nextInt(16)), z1);
            if (block == Blocks.field_150350_a || !block.func_149747_d((IBlockAccess)this.worldServerInstance, x1, y1, z1, 0) || !block.func_149688_o().func_76218_k()) continue;
            chunksMarkedForPortal.put(chunkPosition, true);
            return;
        }
        chunksMarkedForPortal.put(chunkPosition, false);
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        ChunkCoordinates chunkPosition = new ChunkCoordinates(event.getChunk().field_76635_g, 0, event.getChunk().field_76647_h);
        if (chunksMarkedForPortal.containsKey(chunkPosition)) {
            chunksMarkedForPortal.remove(chunkPosition);
        }
    }

    public void func_77185_a(Entity entity, double x, double y, double z, float entityRotation) {
        this.previousWorld = entity.field_70170_p;
        if (entity.field_71093_bK != this.worldServerInstance.field_73011_w.field_76574_g) {
            this.worldServerInstance = MinecraftServer.func_71276_C().func_71218_a(entity.field_71093_bK);
            boolean teleporterRegistered = false;
            for (Teleporter teleporter : this.worldServerInstance.customTeleporters) {
                if (!(teleporter instanceof TeleporterAether)) continue;
                teleporterRegistered = true;
            }
            if (!teleporterRegistered) {
                this.worldServerInstance.customTeleporters.add(this);
            }
        }
        entity.func_70029_a((World)this.worldServerInstance);
        if (!this.func_77184_b(entity, x, y, z, entityRotation)) {
            this.func_85188_a(entity);
            this.func_77184_b(entity, x, y, z, entityRotation);
        }
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public AetherPortalPosition getPortalPosition(World world, int x, int y, int z, boolean findPortalBlock) {
        int radius = 2;
        AetherPortalPosition check = new AetherPortalPosition(x, y, z, world.field_73011_w.field_76574_g);
        block0: for (int ix = x - radius; ix < x + radius; ++ix) {
            for (int iz = z - radius; iz < z + radius; ++iz) {
                for (int iy = y - radius; iy < y + radius; ++iy) {
                    check.field_71574_a = ix;
                    check.field_71572_b = iy;
                    check.field_71573_c = iz;
                    if ((this.portalPairsKV.containsKey((Object)check) || this.portalPairsVK.containsKey((Object)check)) && !findPortalBlock || findPortalBlock && world.func_147439_a(ix, iy, iz) == AetherBlocks.AetherPortal) break block0;
                }
            }
        }
        return check;
    }

    public boolean func_77184_b(Entity entity, double x, double y, double z, float entityRotation) {
        int posZ;
        int posY;
        int posX = MathHelper.func_76128_c((double)entity.field_70165_t);
        AetherPortalPosition previousPortal = this.getPortalPosition(this.previousWorld, posX, posY = MathHelper.func_76128_c((double)entity.field_70163_u), posZ = MathHelper.func_76128_c((double)entity.field_70161_v), false);
        AetherPortalPosition linkedPortal = this.getLinkedPortal(previousPortal);
        if (linkedPortal != null) {
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                WorldServer world = MinecraftServer.func_71276_C().func_71218_a(linkedPortal.dimensionID);
                player.func_70634_a((double)linkedPortal.field_71574_a + 1.5, (double)linkedPortal.field_71572_b, (double)linkedPortal.field_71573_c + 1.5);
                this.worldServerInstance.func_72866_a((Entity)player, true);
                while (!world.func_72945_a((Entity)player, player.field_70121_D).isEmpty()) {
                    player.func_70107_b(player.field_70165_t, player.field_70163_u + 0.2, player.field_70161_v);
                }
            }
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            return true;
        }
        return false;
    }

    public boolean hasSolidBlocks(World world, AxisAlignedBB boundingBox) {
        int x = (int)boundingBox.field_72340_a;
        while ((double)x < boundingBox.field_72336_d) {
            int y = (int)boundingBox.field_72338_b;
            while ((double)y < boundingBox.field_72337_e) {
                int z = (int)boundingBox.field_72339_c;
                while ((double)z < boundingBox.field_72334_f) {
                    Block block = world.func_147439_a(x, y, z);
                    if (!world.func_147437_c(x, y, z) && !(block instanceof BlockFlower)) {
                        return false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    public boolean func_85188_a(Entity entity) {
        World world = entity.field_70170_p;
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        boolean isSolidChunk = false;
        int attempts = 0;
        int maxAttempts = 250;
        int outerDirection = entity.field_70170_p.field_73012_v.nextInt(4);
        while (!isSolidChunk || attempts < 250) {
            ChunkCoordinates outerPosition = new ChunkCoordinates(chunkX, 0, chunkZ);
            this.setNextCoordinate(outerPosition, outerDirection + entity.field_70170_p.field_73012_v.nextInt(2));
            chunkX = outerPosition.field_71574_a;
            chunkZ = outerPosition.field_71573_c;
            if (this.worldServerInstance.field_73011_w.field_76574_g == Aether.getDimensionID()) {
                IChunkProvider chunkProvider = entity.field_70170_p.func_72863_F();
                chunkProvider.func_73158_c(chunkX, chunkZ);
                this.markForPortals(chunkX, chunkZ);
            }
            if (chunksMarkedForPortal.containsKey(outerPosition) || this.worldServerInstance.field_73011_w.field_76574_g != Aether.getDimensionID()) {
                boolean bl = isSolidChunk = this.worldServerInstance.field_73011_w.field_76574_g != Aether.getDimensionID() || chunksMarkedForPortal.get(outerPosition) != false;
                if (isSolidChunk) {
                    boolean hasFoundPosition = false;
                    int innerAttempts = 0;
                    int maxInnerAttempts = 4;
                    int innerDirection = 0;
                    while (!hasFoundPosition) {
                        int y1;
                        Block block;
                        x = (chunkX << 4) + 8;
                        z = (chunkZ << 4) + 8;
                        ChunkCoordinates innerPosition = new ChunkCoordinates(x, 0, z);
                        this.setNextCoordinate(innerPosition, innerDirection);
                        x = innerPosition.field_71574_a;
                        z = innerPosition.field_71573_c;
                        if (++innerDirection > 3) {
                            innerDirection = 0;
                        }
                        if ((block = world.func_147439_a(x, y1 = this.getFirstUncoveredCoord(world, x, z), z)) != Blocks.field_150350_a && block.func_149747_d((IBlockAccess)world, x, y1, z, 0) && block.func_149688_o().func_76218_k()) {
                            hasFoundPosition = true;
                        }
                        if (hasFoundPosition && this.hasSolidBlocks(world, AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y1 + 1), (double)(z - 1), (double)x, (double)(y1 + 4), (double)(z + 4))) || attempts > 235) {
                            int posX = MathHelper.func_76128_c((double)entity.field_70165_t);
                            int posY = MathHelper.func_76128_c((double)entity.field_70163_u);
                            int posZ = MathHelper.func_76128_c((double)entity.field_70161_v);
                            AetherPortalPosition oldPortal = this.getPortalPosition(this.previousWorld, posX, posY, posZ, true);
                            AetherPortalPosition linkedPortal = new AetherPortalPosition(x, y1 + 1, z, world.field_73011_w.field_76574_g);
                            this.portalPairsKV.put(oldPortal, linkedPortal);
                            this.portalPairsVK.put(linkedPortal, oldPortal);
                            this.createPortalFrame(world, x, y1, z);
                            Aether.print("Created portal using " + (attempts + 1) + " attempts.");
                            return true;
                        }
                        if (++innerAttempts < maxInnerAttempts) continue;
                        break;
                    }
                }
            }
            if (++attempts < 250) continue;
            Aether.print("Breaking outer loop trying to generate portal");
            isSolidChunk = false;
            break;
        }
        return isSolidChunk;
    }

    public boolean createPortalFrame(World world, int x, int y, int z) {
        boolean flag;
        int i4;
        int j3;
        int k3;
        int l2;
        int i3;
        int k2;
        if (!this.createPortal) {
            return false;
        }
        int posX = x;
        int posY = y + 1;
        int posZ = z;
        int k1 = 0;
        int j2 = posZ;
        int k5 = k1 % 2;
        int l5 = 1 - k5;
        if (k1 % 4 >= 2) {
            k5 = -k5;
            l5 = -l5;
        }
        Block frameBlockID = Blocks.field_150426_aN;
        BlockAetherPortal portalBlockID = (BlockAetherPortal)AetherBlocks.AetherPortal;
        int j5 = posY;
        for (k2 = -1; k2 <= 1; ++k2) {
            for (i3 = 1; i3 < 3; ++i3) {
                for (l2 = -1; l2 < 3; ++l2) {
                    k3 = posX + (i3 - 1) * k5 + k2 * l5;
                    j3 = j5 + l2;
                    i4 = j2 + (i3 - 1) * l5 - k2 * k5;
                    flag = l2 < 0;
                    this.worldServerInstance.func_147465_d(k3, j3, i4, flag ? frameBlockID : Blocks.field_150350_a, 0, 2);
                }
            }
        }
        for (k2 = 0; k2 < 4; ++k2) {
            for (i3 = 0; i3 < 4; ++i3) {
                for (l2 = -1; l2 < 4; ++l2) {
                    k3 = posX + (i3 - 1) * k5;
                    j3 = j5 + l2;
                    i4 = j2 + (i3 - 1) * l5;
                    flag = i3 == 0 || i3 == 3 || l2 == -1 || l2 == 3;
                    this.worldServerInstance.func_147465_d(k3, j3, i4, (Block)(flag ? frameBlockID : portalBlockID), 0, 2);
                }
            }
            for (i3 = 0; i3 < 4; ++i3) {
                for (l2 = -1; l2 < 4; ++l2) {
                    k3 = posX + (i3 - 1) * k5;
                    j3 = j5 + l2;
                    i4 = j2 + (i3 - 1) * l5;
                    this.worldServerInstance.func_147459_d(k3, j3, i4, this.worldServerInstance.func_147439_a(k3, j3, i4));
                }
            }
        }
        return true;
    }

    public void func_85189_a(long totalWorldTime) {
        Iterator<Map.Entry<AetherPortalPosition, AetherPortalPosition>> iterator = this.portalPairsVK.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AetherPortalPosition, AetherPortalPosition> entry = iterator.next();
            AetherPortalPosition portal1 = entry.getKey();
            AetherPortalPosition portal2 = entry.getValue();
            AetherPortalPosition ourPortal = portal1.dimensionID == this.worldServerInstance.field_73011_w.field_76574_g ? portal1 : portal2;
            AetherPortalPosition checkPosition = this.getPortalPosition((World)this.worldServerInstance, ourPortal.field_71574_a, ourPortal.field_71572_b, ourPortal.field_71573_c, false);
            if (this.worldServerInstance.func_147439_a(checkPosition.field_71574_a, checkPosition.field_71572_b, checkPosition.field_71573_c) == AetherBlocks.AetherPortal) continue;
            iterator.remove();
            this.portalPairsKV.remove((Object)portal2);
        }
    }

    public int getFirstUncoveredCoord(World world, int x, int z) {
        int y;
        for (y = world.func_72800_K(); (world.func_147437_c(x, y - 1, z) || world.func_147439_a(x, y - 1, z) instanceof BlockLeavesBase || world.func_147439_a(x, y - 1, z) instanceof BlockFlower) && y > 0; --y) {
        }
        return y - 1;
    }

    public void setNextCoordinate(ChunkCoordinates outerPosition, int direction) {
        if (direction > 3) {
            direction = 0;
        }
        switch (direction) {
            case 2: {
                ++outerPosition.field_71573_c;
                break;
            }
            case 0: {
                --outerPosition.field_71573_c;
                break;
            }
            case 1: {
                --outerPosition.field_71574_a;
                break;
            }
            case 3: {
                ++outerPosition.field_71574_a;
            }
        }
    }

    private void setPortalLinks(Map<AetherPortalPosition, AetherPortalPosition> linkKV) {
        this.portalPairsKV = linkKV;
        this.portalPairsVK = new HashMap();
        for (Map.Entry<AetherPortalPosition, AetherPortalPosition> entry : linkKV.entrySet()) {
            this.portalPairsVK.put(entry.getValue(), entry.getKey());
        }
    }

    public Map<AetherPortalPosition, AetherPortalPosition> getPortalLinks() {
        return this.portalPairsKV;
    }

    public AetherPortalPosition getLinkedPortal(AetherPortalPosition previousPortal) {
        AetherPortalPosition linkedPortal = null;
        if (this.portalPairsVK.containsKey((Object)previousPortal)) {
            linkedPortal = this.portalPairsVK.get((Object)previousPortal);
        } else if (this.portalPairsKV.containsKey((Object)previousPortal)) {
            linkedPortal = this.portalPairsKV.get((Object)previousPortal);
        }
        return linkedPortal;
    }

    public void write(NBTTagCompound output) {
        NBTFactory factory = new NBTFactory();
        IOUtil.setIOMap((String)"portalLinks", this.getPortalLinks(), (IOFactory)factory, (Object)output);
    }

    public void read(NBTTagCompound input) {
        NBTFactory factory = new NBTFactory();
        Map portalLinks = IOUtil.getIOMap((String)"portalLinks", (IOFactory)factory, (Object)input);
        this.setPortalLinks(portalLinks);
    }
}

