/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.worldgen;

import java.util.Random;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class AetherGenMassiveTree
extends WorldGenAbstractTree {
    Block leaves;
    int randHeight;
    boolean branches;

    public AetherGenMassiveTree(Block leafID, int heightWeight, boolean branchFlag) {
        super(true);
        this.leaves = leafID;
        this.randHeight = heightWeight;
        this.branches = branchFlag;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        boolean cangen = true;
        int height = random.nextInt(this.randHeight) + (this.branches ? 8 : 4);
        for (int x1 = x - 3; x1 < x + 3; ++x1) {
            for (int y1 = y + 1; y1 < y + (height + 2); ++y1) {
                for (int z1 = z - 3; z1 < z + 3; ++z1) {
                    if (world.func_147439_a(x1, y1, z1) == Blocks.field_150350_a) continue;
                    cangen = false;
                }
            }
        }
        if (y + (height + 2) <= world.func_72800_K() && cangen) {
            int y2;
            Block y1 = world.func_147439_a(x, y - 1, z);
            if (y1 != AetherBlocks.AetherGrass && y1 != AetherBlocks.AetherDirt) {
                return false;
            }
            world.func_147449_b(x, y - 1, z, AetherBlocks.AetherDirt);
            for (y2 = y; y2 <= y + height; ++y2) {
                world.func_147449_b(x, y2, z, AetherBlocks.AetherLog);
            }
            if (this.branches) {
                world.func_147449_b(x + 1, y, z, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x + 1, y + 1, z, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x + 2, y, z, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x - 1, y, z, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x - 1, y + 1, z, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x - 2, y, z, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x, y, z + 1, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x, y + 1, z + 1, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x, y, z + 2, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x, y, z - 1, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x, y + 1, z - 1, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x, y, z - 2, AetherBlocks.SkyrootLogWall);
                world.func_147449_b(x + 1, y - 1, z, AetherBlocks.AetherGrass);
                world.func_147449_b(x + 2, y - 1, z, AetherBlocks.AetherGrass);
                world.func_147449_b(x - 1, y - 1, z, AetherBlocks.AetherGrass);
                world.func_147449_b(x - 2, y - 1, z, AetherBlocks.AetherGrass);
                world.func_147449_b(x, y - 1, z + 1, AetherBlocks.AetherGrass);
                world.func_147449_b(x, y - 1, z + 2, AetherBlocks.AetherGrass);
                world.func_147449_b(x, y - 1, z - 1, AetherBlocks.AetherGrass);
                world.func_147449_b(x, y - 1, z - 2, AetherBlocks.AetherGrass);
                world.func_147449_b(x + 1, y - 2, z, AetherBlocks.AetherDirt);
                world.func_147449_b(x + 2, y - 2, z, AetherBlocks.AetherDirt);
                world.func_147449_b(x - 1, y - 2, z, AetherBlocks.AetherDirt);
                world.func_147449_b(x - 2, y - 2, z, AetherBlocks.AetherDirt);
                world.func_147449_b(x, y - 2, z + 1, AetherBlocks.AetherDirt);
                world.func_147449_b(x, y - 2, z + 2, AetherBlocks.AetherDirt);
                world.func_147449_b(x, y - 2, z - 1, AetherBlocks.AetherDirt);
                world.func_147449_b(x, y - 2, z - 2, AetherBlocks.AetherDirt);
            }
            this.setBlockAirCheck(world, x, y + (height + 1), z, this.leaves);
            this.setBlockAirCheck(world, x, y + (height + 2), z, this.leaves);
            for (y2 = y + 2; y2 <= y + (height + 1); ++y2) {
                this.setBlockAirCheck(world, x + 1, y2, z, this.leaves);
                this.setBlockAirCheck(world, x - 1, y2, z, this.leaves);
                this.setBlockAirCheck(world, x, y2, z + 1, this.leaves);
                this.setBlockAirCheck(world, x, y2, z - 1, this.leaves);
            }
            for (y2 = y + 3; y2 <= y + height; y2 += 2) {
                this.setBlockAirCheck(world, x + 1, y2, z + 1, this.leaves);
                this.setBlockAirCheck(world, x - 1, y2, z - 1, this.leaves);
                this.setBlockAirCheck(world, x + 1, y2, z - 1, this.leaves);
                this.setBlockAirCheck(world, x - 1, y2, z + 1, this.leaves);
                this.setBlockAirCheck(world, x + 2, y2, z, this.leaves);
                this.setBlockAirCheck(world, x - 2, y2, z, this.leaves);
                this.setBlockAirCheck(world, x, y2, z + 2, this.leaves);
                this.setBlockAirCheck(world, x, y2, z - 2, this.leaves);
            }
            if (this.branches) {
                int side = random.nextInt(3);
                for (int y22 = y + (random.nextInt(2) + 3); y22 <= y + height - 2; y22 += 1 + random.nextInt(3)) {
                    int branchLength = random.nextInt(4) + 1;
                    switch (side) {
                        case 0: {
                            for (int x2 = x; x2 <= x + branchLength; ++x2) {
                                world.func_147449_b(x2, y22, z, AetherBlocks.AetherLog);
                                this.setBlockAirCheck(world, x2, y22 + 1, z, this.leaves);
                                this.setBlockAirCheck(world, x2, y22 - 1, z, this.leaves);
                                this.setBlockAirCheck(world, x2 + 1, y22, z + 1, this.leaves);
                                this.setBlockAirCheck(world, x2 - 1, y22, z - 1, this.leaves);
                            }
                            world.func_147449_b(x + (branchLength + 1), y22 + 1, z, AetherBlocks.AetherLog);
                            world.func_147449_b(x + (branchLength + 2), y22 + 2, z, AetherBlocks.AetherLog);
                            world.func_147449_b(x + (branchLength + 2), y22 + 3, z, AetherBlocks.AetherLog);
                            this.setBlockAirCheck(world, x + (branchLength + 1), y22 + 2, z, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 1), y22 + 3, z, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 2), y22 + 4, z, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 3), y22 + 2, z, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 3), y22 + 3, z, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 2), y22 + 2, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 2), y22 + 3, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 2), y22 + 2, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 2), y22 + 3, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 1), y22 + 1, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 1), y22 + 2, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 1), y22 + 1, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 1), y22 + 2, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x + branchLength, y22, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x + branchLength, y22 + 1, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x + branchLength, y22, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x + branchLength, y22 + 1, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength - 1), y22, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength - 1), y22, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength - 2), y22 - 1, z, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength - 1), y22 - 1, z, this.leaves);
                            this.setBlockAirCheck(world, x + branchLength, y22 - 1, z, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 1), y22, z, this.leaves);
                            this.setBlockAirCheck(world, x + (branchLength + 2), y22 + 1, z, this.leaves);
                            break;
                        }
                        case 1: {
                            for (int x3 = x; x3 >= x - branchLength; --x3) {
                                world.func_147449_b(x3, y22, z, AetherBlocks.AetherLog);
                                this.setBlockAirCheck(world, x3, y22 + 1, z, this.leaves);
                                this.setBlockAirCheck(world, x3, y22 - 1, z, this.leaves);
                                this.setBlockAirCheck(world, x3 + 1, y22, z + 1, this.leaves);
                                this.setBlockAirCheck(world, x3 - 1, y22, z - 1, this.leaves);
                            }
                            world.func_147449_b(x - (branchLength + 1), y22 + 1, z, AetherBlocks.AetherLog);
                            world.func_147449_b(x - (branchLength + 2), y22 + 2, z, AetherBlocks.AetherLog);
                            world.func_147449_b(x - (branchLength + 2), y22 + 3, z, AetherBlocks.AetherLog);
                            this.setBlockAirCheck(world, x - (branchLength + 1), y22 + 2, z, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 1), y22 + 3, z, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 2), y22 + 4, z, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 3), y22 + 2, z, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 3), y22 + 3, z, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 2), y22 + 2, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 2), y22 + 3, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 2), y22 + 2, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 2), y22 + 3, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 1), y22 + 1, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 1), y22 + 2, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 1), y22 + 1, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 1), y22 + 2, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x - branchLength, y22, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x - branchLength, y22 + 1, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x - branchLength, y22, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x - branchLength, y22 + 1, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength - 1), y22, z - 1, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength - 1), y22, z + 1, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength - 2), y22 - 1, z, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength - 1), y22 - 1, z, this.leaves);
                            this.setBlockAirCheck(world, x - branchLength, y22 - 1, z, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 1), y22, z, this.leaves);
                            this.setBlockAirCheck(world, x - (branchLength + 2), y22 + 1, z, this.leaves);
                            break;
                        }
                        case 2: {
                            for (int z2 = z; z2 <= z + branchLength; ++z2) {
                                world.func_147449_b(x, y22, z2, AetherBlocks.AetherLog);
                                this.setBlockAirCheck(world, x, y22 + 1, z2, this.leaves);
                                this.setBlockAirCheck(world, x, y22 - 1, z2, this.leaves);
                                this.setBlockAirCheck(world, x + 1, y22, z2, this.leaves);
                                this.setBlockAirCheck(world, x - 1, y22, z2, this.leaves);
                            }
                            world.func_147449_b(x, y22 + 1, z + (branchLength + 1), AetherBlocks.AetherLog);
                            world.func_147449_b(x, y22 + 2, z + (branchLength + 2), AetherBlocks.AetherLog);
                            world.func_147449_b(x, y22 + 3, z + (branchLength + 2), AetherBlocks.AetherLog);
                            this.setBlockAirCheck(world, x, y22 + 2, z + (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x, y22 + 3, z + (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x, y22 + 4, z + (branchLength + 2), this.leaves);
                            this.setBlockAirCheck(world, x, y22 + 2, z + (branchLength + 3), this.leaves);
                            this.setBlockAirCheck(world, x, y22 + 3, z + (branchLength + 3), this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22 + 2, z + (branchLength + 2), this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22 + 3, z + (branchLength + 2), this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22 + 2, z + (branchLength + 2), this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22 + 3, z + (branchLength + 2), this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22 + 1, z + (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22 + 2, z + (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22 + 1, z + (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22 + 2, z + (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22, z + branchLength, this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22 + 1, z + branchLength, this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22, z + branchLength, this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22 + 1, z + branchLength, this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22, z + (branchLength - 1), this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22, z + (branchLength - 1), this.leaves);
                            this.setBlockAirCheck(world, x, y22 - 1, z + (branchLength - 2), this.leaves);
                            this.setBlockAirCheck(world, x, y22 - 1, z + (branchLength - 1), this.leaves);
                            this.setBlockAirCheck(world, x, y22 - 1, z + branchLength, this.leaves);
                            this.setBlockAirCheck(world, x, y22, z + (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x, y22 + 1, z + (branchLength + 2), this.leaves);
                            break;
                        }
                        case 3: {
                            for (int z3 = z; z3 >= z - branchLength; --z3) {
                                world.func_147449_b(x, y22, z3, AetherBlocks.AetherLog);
                                this.setBlockAirCheck(world, x, y22 + 1, z3, this.leaves);
                                this.setBlockAirCheck(world, x, y22 - 1, z3, this.leaves);
                                this.setBlockAirCheck(world, x + 1, y22, z3, this.leaves);
                                this.setBlockAirCheck(world, x - 1, y22, z3, this.leaves);
                            }
                            world.func_147449_b(x, y22 + 1, z - (branchLength + 1), AetherBlocks.AetherLog);
                            world.func_147449_b(x, y22 + 2, z - (branchLength + 2), AetherBlocks.AetherLog);
                            world.func_147449_b(x, y22 + 3, z - (branchLength + 2), AetherBlocks.AetherLog);
                            this.setBlockAirCheck(world, x, y22 + 2, z - (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x, y22 + 3, z - (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x, y22 + 4, z - (branchLength + 2), this.leaves);
                            this.setBlockAirCheck(world, x, y22 + 2, z - (branchLength + 3), this.leaves);
                            this.setBlockAirCheck(world, x, y22 + 3, z - (branchLength + 3), this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22 + 2, z - (branchLength + 2), this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22 + 3, z - (branchLength + 2), this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22 + 2, z - (branchLength + 2), this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22 + 3, z - (branchLength + 2), this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22 + 1, z - (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22 + 2, z - (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22 + 1, z - (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22 + 2, z - (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22, z - branchLength, this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22 + 1, z - branchLength, this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22, z - branchLength, this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22 + 1, z - branchLength, this.leaves);
                            this.setBlockAirCheck(world, x - 1, y22, z - (branchLength - 1), this.leaves);
                            this.setBlockAirCheck(world, x + 1, y22, z - (branchLength - 1), this.leaves);
                            this.setBlockAirCheck(world, x, y22 - 1, z - (branchLength - 2), this.leaves);
                            this.setBlockAirCheck(world, x, y22 - 1, z - (branchLength - 1), this.leaves);
                            this.setBlockAirCheck(world, x, y22 - 1, z - branchLength, this.leaves);
                            this.setBlockAirCheck(world, x, y22, z - (branchLength + 1), this.leaves);
                            this.setBlockAirCheck(world, x, y22 + 1, z - (branchLength + 2), this.leaves);
                        }
                    }
                    if (++side <= 3) continue;
                    side = 0;
                }
            }
            return true;
        }
        return false;
    }

    public void setBlockAirCheck(World world, int x, int y, int z, Block blockID) {
        if (world.func_147439_a(x, y, z) == Blocks.field_150350_a) {
            world.func_147449_b(x, y, z, blockID);
        }
    }
}

