/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.server.cloud_network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import net.aetherteam.aether.server.cloud_network.CloudServer;
import net.aetherteam.aether.server.cloud_network.CloudServerStatus;
import net.aetherteam.aether.server.cloud_network.ServerCloudNetwork;
import net.minecraft.server.dedicated.DedicatedServer;
import org.apache.commons.io.IOUtils;

public class CloudUpdateThread
implements Runnable {
    private final Gson gson = new Gson();
    private final JsonParser parser = new JsonParser();
    private final Charset charset = Charset.forName("UTF-8");
    private boolean hasAlreadyWarned = false;

    @Override
    public void run() {
        if (ServerCloudNetwork.serverStatus != CloudServerStatus.BANNED) {
            DedicatedServer dedicatedServer = (DedicatedServer)FMLCommonHandler.instance().getMinecraftServerInstance();
            if (!dedicatedServer.func_71266_T() || dedicatedServer.func_71203_ab().func_72383_n()) {
                if (!this.hasAlreadyWarned) {
                    ServerCloudNetwork.LOGGER.error("Your server needs to be in online mode and non-whitelisted to be added to the Cloud Network.");
                    this.hasAlreadyWarned = true;
                }
                ServerCloudNetwork.serverStatus = CloudServerStatus.NOT_REGISTERED;
                ServerCloudNetwork.removeCloudServer();
                return;
            }
            this.hasAlreadyWarned = false;
            if (ServerCloudNetwork.serverStatus == CloudServerStatus.REGISTERED) {
                try {
                    ServerCloudNetwork.serverStatus = ServerCloudNetwork.serverID == null ? CloudServerStatus.NOT_REGISTERED : this.heartbeatCloud(ServerCloudNetwork.serverID);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ServerCloudNetwork.LOGGER.warn("Cloud server heartbeat failed, we'll try to re-register.");
                    ServerCloudNetwork.serverStatus = CloudServerStatus.NOT_REGISTERED;
                }
            }
            if (ServerCloudNetwork.serverStatus == CloudServerStatus.NOT_REGISTERED) {
                try {
                    ServerCloudNetwork.LOGGER.info("Registering Cloud Server on the network...");
                    ServerCloudNetwork.serverStatus = this.registerCloud(ServerCloudNetwork.server);
                }
                catch (IOException ignored) {
                    ignored.printStackTrace();
                }
            }
            if (ServerCloudNetwork.serverStatus == CloudServerStatus.BANNED) {
                ServerCloudNetwork.LOGGER.warn("##### Your cloud server has been banned from the Cloud Network. #####");
            }
        }
    }

    private CloudServerStatus heartbeatCloud(String serverID) throws IOException {
        HttpURLConnection connection = this.createConnection(String.format("http://gilded-games.com/cloudnetwork/heartbeat?id=%s", serverID));
        if (connection.getResponseCode() >= 200 && connection.getResponseCode() < 300) {
            return CloudServerStatus.REGISTERED;
        }
        ServerCloudNetwork.serverID = null;
        return CloudServerStatus.NOT_REGISTERED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudServerStatus registerCloud(CloudServer server) throws IOException {
        InputStream inputStream;
        block6: {
            block5: {
                JsonObject serverObject;
                HttpURLConnection connection;
                block4: {
                    CloudServerStatus cloudServerStatus;
                    String cloudData = this.gson.toJson((Object)server);
                    inputStream = null;
                    try {
                        connection = this.createConnection("http://gilded-games.com/cloudnetwork/addCloud");
                        connection.setRequestMethod("POST");
                        connection.setRequestProperty("Content-Type", "application/json");
                        connection.setDoOutput(true);
                        connection.getOutputStream().write(cloudData.getBytes(this.charset));
                        inputStream = connection.getErrorStream() != null ? connection.getErrorStream() : connection.getInputStream();
                        serverObject = this.parser.parse(IOUtils.toString((InputStream)inputStream, (Charset)this.charset)).getAsJsonObject();
                        if (connection.getResponseCode() < 200 || connection.getResponseCode() >= 300) break block4;
                        ServerCloudNetwork.serverID = serverObject.get("id").getAsString();
                        cloudServerStatus = CloudServerStatus.REGISTERED;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                    return cloudServerStatus;
                }
                if (connection.getResponseCode() < 400 || connection.getResponseCode() >= 500) break block5;
                if (!serverObject.has("isBanned") || !serverObject.get("isBanned").getAsBoolean()) break block6;
                CloudServerStatus cloudServerStatus = CloudServerStatus.BANNED;
                IOUtils.closeQuietly((InputStream)inputStream);
                return cloudServerStatus;
            }
            CloudServerStatus cloudServerStatus = CloudServerStatus.SERVER_ERROR;
            IOUtils.closeQuietly((InputStream)inputStream);
            return cloudServerStatus;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return CloudServerStatus.NOT_REGISTERED;
    }

    private HttpURLConnection createConnection(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        return connection;
    }
}

