/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.player.abilities;

import net.aetherteam.aether.containers.inventory.InventoryAccessories;
import net.aetherteam.aether.items.AetherItems;
import net.aetherteam.aether.items.ItemAccessory;
import net.aetherteam.aether.player.PlayerAether;
import net.aetherteam.aether.player.abilities.Ability;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;

public class AbilityAccessories
extends Ability {
    public ItemStack[] accessories;
    public InventoryAccessories reference;
    private int foodLevel;
    private float foodSaturation;
    private boolean candyRingOn;

    public AbilityAccessories(PlayerAether player) {
        super(player);
        this.accessories = this.player.getAccessoryStacks();
        this.reference = this.player.accessories;
    }

    @Override
    public boolean isWearing() {
        return true;
    }

    public ItemStack getAccessory(Item itemId) {
        for (ItemStack itemStack : this.accessories) {
            if (itemStack == null || itemStack.func_77973_b() != itemId) continue;
            return itemStack;
        }
        return null;
    }

    public void damageItemStackIfWearing(ItemStack itemStack, ItemAccessory.AccessoryType type) {
        Item currentAccessory = itemStack.func_77973_b();
        if (this.reference.getStackFromID(currentAccessory) != null && !this.entityPlayer.field_71075_bZ.field_75098_d) {
            this.reference.getStackFromID(currentAccessory).func_77972_a(1, (EntityLivingBase)this.entityPlayer);
            if (this.reference.getStackFromID(currentAccessory).func_77952_i() <= 0) {
                this.reference.breakItem(currentAccessory, type);
            }
        }
    }

    @Override
    public void onUpdate() {
        if (this.entityPlayer == null) {
            return;
        }
        if (this.entityPlayer.field_70173_aa % 400 == 0) {
            this.damageItemStackIfWearing(new ItemStack(AetherItems.ZanitePendant, 1, 0), ItemAccessory.AccessoryType.PENDANT);
            this.damageItemStackIfWearing(new ItemStack(AetherItems.ZaniteRing, 1, 0), ItemAccessory.AccessoryType.RING);
        }
        if (!this.worldObj.field_72995_K) {
            if (this.player.wearingAccessory(AetherItems.CandyRing)) {
                if (!this.candyRingOn || this.entityPlayer.func_71024_bL().func_75116_a() > this.foodLevel || this.entityPlayer.func_71024_bL().func_75115_e() > this.foodSaturation) {
                    this.foodLevel = this.entityPlayer.func_71024_bL().func_75116_a();
                    this.foodSaturation = this.entityPlayer.func_71024_bL().func_75115_e();
                    this.candyRingOn = true;
                }
                if (this.entityPlayer.func_71024_bL().func_75116_a() < this.foodLevel) {
                    int dif = this.entityPlayer.func_71024_bL().func_75116_a() - this.foodLevel;
                    this.entityPlayer.func_71024_bL().func_75122_a(-dif, 0.0f);
                }
                if (this.entityPlayer.func_71024_bL().func_75115_e() < this.foodSaturation) {
                    float dif = this.entityPlayer.func_71024_bL().func_75115_e() - this.foodSaturation;
                    this.entityPlayer.func_71024_bL().func_75122_a(0, -dif);
                }
            } else {
                this.foodLevel = 0;
                this.foodSaturation = 0.0f;
                this.candyRingOn = false;
            }
        }
        if (!this.worldObj.field_72995_K && (this.player.wearingAccessory(AetherItems.IceRing) || this.player.wearingAccessory(AetherItems.IcePendant))) {
            int i = MathHelper.func_76128_c((double)this.entityPlayer.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.entityPlayer.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.entityPlayer.field_70161_v);
            for (int l = i - 1; l <= i + 1; ++l) {
                for (int i1 = j - 1; i1 <= j + 1; ++i1) {
                    for (int j1 = k - 1; j1 <= k + 1; ++j1) {
                        Block block = this.worldObj.func_147439_a(l, i1, j1);
                        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                            this.worldObj.func_147449_b(l, i1, j1, Blocks.field_150432_aD);
                            continue;
                        }
                        if (block != Blocks.field_150356_k && block != Blocks.field_150353_l) continue;
                        this.worldObj.func_147449_b(l, i1, j1, Blocks.field_150343_Z);
                    }
                }
            }
        }
        if (this.player.wearingAccessory(AetherItems.IronBubble)) {
            this.entityPlayer.func_70050_g(0);
        }
        if (this.player.wearingAccessory(AetherItems.RegenerationStone) && this.entityPlayer.func_110143_aJ() < this.entityPlayer.func_110138_aP() && this.entityPlayer.func_70660_b(Potion.field_76428_l) == null) {
            this.entityPlayer.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 80, 0));
        }
        if (this.player.wearingAccessory(AetherItems.OrbOfArkenzus)) {
            if (!this.entityPlayer.field_70122_E && this.entityPlayer.field_70181_x < 0.0 && !this.entityPlayer.func_70090_H() && !this.entityPlayer.func_70093_af()) {
                this.entityPlayer.field_70181_x *= 0.6;
            }
            this.entityPlayer.field_70143_R = -1.0f;
        }
    }

    @Override
    public void onDeath() {
        float exp = this.entityPlayer.field_71106_cc;
        int expLevel = this.entityPlayer.field_71068_ca;
        for (int index = 0; index < 8; ++index) {
            if (this.accessories[index] != null && this.accessories[index].func_77973_b() == AetherItems.CrystalBottle) {
                if (this.accessories[index].func_77978_p() != null) {
                    this.accessories[index].func_77978_p().func_74776_a("Experience", this.accessories[index].func_77978_p().func_74760_g("Experience") + (float)(expLevel * 2) + (float)Math.round(exp * 10.0f) * 0.1f);
                    continue;
                }
                this.accessories[index].func_77982_d(new NBTTagCompound());
                this.accessories[index].func_77978_p().func_74776_a("Experience", this.accessories[index].func_77978_p().func_74760_g("Experience") + (float)(expLevel * 2) + (float)Math.round(exp * 10.0f) * 0.1f);
                continue;
            }
            if (this.accessories[index] == null || this.accessories[index].func_77973_b() != AetherItems.PiggieBank) continue;
            if (this.accessories[index].func_77978_p() != null) {
                this.accessories[index].func_77978_p().func_74768_a("Coins", this.accessories[index].func_77978_p().func_74762_e("Coins") + this.player.getAetherCoins());
                continue;
            }
            this.accessories[index].func_77982_d(new NBTTagCompound());
            this.accessories[index].func_77978_p().func_74768_a("Coins", this.accessories[index].func_77978_p().func_74762_e("Coins") + this.player.getAetherCoins());
        }
        if (this.player.wearingAccessory(AetherItems.PiggieBank)) {
            this.player.setAetherCoins(0);
        }
        if (this.player.wearingAccessory(AetherItems.CrystalBottle)) {
            this.entityPlayer.field_71106_cc = 0.0f;
            this.entityPlayer.field_71068_ca = 0;
        }
    }
}

