/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.notifications;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Iterator;
import net.aetherteam.aether.client.gui.notifications.ClientNotificationHandler;
import net.aetherteam.aether.notifications.Notification;
import net.aetherteam.aether.notifications.NotificationType;
import net.aetherteam.aether.packets.AetherPacketHandler;
import net.aetherteam.aether.packets.PacketNotificationChange;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.player.PlayerAether;

public class NotificationHandler {
    private ArrayList<Notification> receivedList = new ArrayList();
    private ArrayList<Notification> sentList = new ArrayList();
    private static NotificationHandler clientNotifications = new NotificationHandler();
    private static NotificationHandler serverNotifications = new NotificationHandler();

    public static NotificationHandler instance() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side.isClient()) {
            return clientNotifications;
        }
        return serverNotifications;
    }

    public void sendNotification(Notification notification) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (!this.hasSentToBefore(notification.getReceiver(), notification.getType(), notification.getSender())) {
            this.sentList.add(notification);
        }
        if (side.isClient()) {
            AetherPacketHandler.sendToServer(new PacketNotificationChange(notification, true));
            ClientNotificationHandler.queueSentNotification(new Notification(NotificationType.GENERIC, "Request Sent!", notification.getReceiver(), notification.getReceiver()));
        }
    }

    public void receiveNotification(Notification notification) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        ArrayList receivedList = new ArrayList();
        for (Notification oldNotification : receivedList) {
            if (oldNotification.getType() != notification.getType() || oldNotification.getSender() != notification.getSender()) continue;
            receivedList.remove(oldNotification);
        }
        this.receivedList = receivedList;
        this.receivedList.add(notification);
        if (side.isClient()) {
            ClientNotificationHandler.queueReceivedNotification(notification);
        }
    }

    public void removeNotification(Notification notification) {
        this.receivedList.remove(notification);
    }

    public void removeSentNotification(Notification notification, boolean sendPackets) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        Iterator<Notification> iter = this.sentList.iterator();
        while (iter.hasNext()) {
            Notification notif = iter.next();
            if (notif.getType() != notification.getType() || notif.getReceiver() != notification.getReceiver() || notif.getSender() != notification.getReceiver()) continue;
            iter.remove();
        }
        if (sendPackets && side == Side.CLIENT) {
            AetherPacketHandler.sendToServer(new PacketNotificationChange(notification, false));
        }
    }

    public boolean hasSentToBefore(PlayerAether receivingPlayer, NotificationType type, PlayerAether sendingPlayer) {
        for (Notification notification : this.sentList) {
            if (notification.getType() != type || notification.getReceiver() != receivingPlayer || notification.getSender() != sendingPlayer) continue;
            return true;
        }
        return false;
    }

    public boolean hasReceivedFromBefore(PlayerAether sendingPlayer, NotificationType type) {
        for (Notification notification : this.receivedList) {
            if (notification.getType() != type || notification.getSender() != sendingPlayer) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.receivedList.isEmpty();
    }

    public ArrayList<Notification> getNotifications() {
        return this.receivedList;
    }

    public void clearNotifications() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side.isClient() && this.getNotifications().size() > 0) {
            Iterator<Notification> it = this.getNotifications().iterator();
            while (it.hasNext()) {
                Notification notification = it.next();
                this.removeSentNotification(notification, true);
                Party party = notification.getSender().getParty();
                if (party != null) {
                    party.sendRemovePlayerRequestPacket(notification.getReceiver());
                }
                it.remove();
            }
        }
    }
}

