/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities.companion;

import net.aetherteam.aether.entities.ai.AICompanionFollow;
import net.aetherteam.aether.items.ItemAccessory;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public abstract class EntityCompanion
extends EntityCreature {
    public static boolean invRender = false;
    protected EntityPlayer owner;

    public EntityCompanion(World world) {
        super(world);
        this.initAI();
    }

    public EntityCompanion(World world, EntityPlayer player, ItemStack summoner) {
        this(world);
        this.setOwner(player);
        this.setSummoner(summoner);
    }

    protected void initAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AICompanionFollow(this, 0.5, 6.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)String.valueOf(this.getDefaultName()));
        this.field_70180_af.func_75682_a(19, (Object)(this.owner != null ? String.valueOf(PlayerAether.get(this.owner).getProfile().getUsername()) : ""));
        this.field_70180_af.func_82709_a(20, 5);
    }

    public String getCompanionName() {
        return this.field_70180_af.func_75681_e(18);
    }

    public void setCompanionName(String name) {
        this.field_70180_af.func_75692_b(18, (Object)name);
    }

    public void setOwnerName(String name) {
        this.field_70180_af.func_75692_b(19, (Object)name);
    }

    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(19);
    }

    public void setSummoner(ItemStack summoner) {
        this.field_70180_af.func_75692_b(20, (Object)summoner);
    }

    public ItemStack getSummoner() {
        return this.field_70180_af.func_82710_f(20);
    }

    public void func_70071_h_() {
        this.field_70143_R = 0.0f;
        super.func_70071_h_();
        this.executeEffect();
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.owner == null || this.owner.field_70128_L) {
                this.unsummon();
            } else {
                this.field_70180_af.func_75692_b(19, (Object)PlayerAether.get(this.owner).getProfile().getUsername());
                PlayerAether player = PlayerAether.get(this.owner);
                ItemStack stack = player.accessories.getStackFromType(ItemAccessory.AccessoryType.COMPANION);
                if (stack == null) {
                    this.unsummon();
                }
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        return super.func_70085_c(player);
    }

    public void summon(ItemStack summoner) {
        this.setSummoner(summoner);
    }

    public void unsummon() {
        this.removeEffect();
        this.field_70128_L = true;
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.removeEffect();
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player;
        this.setOwnerName(PlayerAether.get(player).getProfile().getUsername());
    }

    public EntityPlayer getOwner() {
        return this.owner;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public boolean func_70094_T() {
        return this.getOwner() == null && super.func_70094_T();
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (damagesource.func_76346_g() instanceof EntityPlayer && this.getOwner() == damagesource.func_76346_g()) {
            return super.func_70097_a(damagesource, 0.0f);
        }
        return super.func_70097_a(damagesource, i);
    }

    public boolean func_110164_bC() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(this.getSummonerItem(), 1, 0);
    }

    public abstract String getDefaultName();

    public abstract Item getSummonerItem();

    public abstract void executeEffect();

    public abstract void removeEffect();

    public abstract String getEffectDescription();
}

