/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities.bosses;

import java.util.ArrayList;
import java.util.List;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.AetherNameGen;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.dungeons.DungeonHandler;
import net.aetherteam.aether.entities.bosses.EntityBossMob;
import net.aetherteam.aether.entities.bosses.EntityHostEye;
import net.aetherteam.aether.enums.EnumBossType;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySliderHostMimic
extends EntityBossMob {
    public boolean hasBeenAttacked;
    public int eyeCap = 4;
    public List<EntityHostEye> eyes = new ArrayList<EntityHostEye>();
    public int scareTime;
    public String bossName;
    public int sendDelay = 15;
    public int sendRespawnDelay = 10;
    private int chatTime;

    public EntitySliderHostMimic(World world) {
        super(world);
        this.func_70105_a(2.0f, 2.5f);
        this.bossName = AetherNameGen.gen();
        this.field_70178_ae = true;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(175.0);
        this.func_70606_j(175.0f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)1.2f);
        this.hasBeenAttacked = false;
        this.scareTime = 0;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    public boolean isAwake() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public void setAwake(boolean awake) {
        if (awake) {
            this.scareItUp();
            this.field_70170_p.func_72956_a((Entity)this, "aether:aeboss.slider.awake", 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70180_af.func_75692_b(16, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(16, (Object)0);
        }
    }

    public boolean isSendMode() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    public void setSendMode(boolean sendMode) {
        if (sendMode) {
            this.field_70180_af.func_75692_b(17, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(17, (Object)0);
        }
    }

    @Override
    protected Entity func_70782_k() {
        EntityPlayer var1 = this.field_70170_p.func_72856_b((Entity)this, 8.5);
        return var1 != null && this.func_70685_l((Entity)var1) ? var1 : null;
    }

    protected String func_70639_aQ() {
        return "ambient.cave.cave";
    }

    protected String func_70621_aR() {
        return "step.stone";
    }

    protected String func_70673_aS() {
        return "aether:aeboss.slider.die";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.field_70170_p.func_72956_a((Entity)this, "mob.cow.step", 0.15f, 1.0f);
    }

    protected void func_70064_a(double par1, boolean par3) {
        if (this.isAwake()) {
            super.func_70064_a(par1, par3);
        }
    }

    protected void func_70069_a(float par1) {
        if (this.isAwake()) {
            super.func_70069_a(par1);
        }
    }

    @Override
    public boolean func_70692_ba() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70066_B();
        if (this.chatTime >= 0) {
            --this.chatTime;
        }
        if (!this.isAwake()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70747_aH = 0.0f;
            this.field_70177_z = 0.0f;
            this.field_70125_A = 0.0f;
            this.field_70761_aq = 0.0f;
        }
        EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 8.5);
        if (this.field_70789_a == null && entityplayer != null && this.func_70685_l((Entity)entityplayer) && !entityplayer.field_70128_L && !entityplayer.field_71075_bZ.field_75098_d) {
            this.field_70789_a = entityplayer;
            this.setSendMode(true);
        }
        if (this.field_70789_a != null && this.field_70789_a instanceof EntityLivingBase && this.func_70685_l(this.field_70789_a) && !this.field_70789_a.field_70128_L) {
            this.func_70625_a(this.field_70789_a, 10.0f, 10.0f);
            if (!this.hasBeenAttacked) {
                this.hasBeenAttacked = true;
            }
            if (this.isSendMode()) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                this.field_70747_aH = 0.0f;
                this.field_70177_z = 0.0f;
                this.field_70125_A = 0.0f;
                this.field_70761_aq = 0.0f;
                if (this.eyes.size() < this.eyeCap) {
                    if (this.sendDelay <= 0 && !this.field_70170_p.field_72995_K) {
                        this.sendEye((EntityLivingBase)this.field_70789_a);
                    }
                } else if (this.sendRespawnDelay <= 0) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.sendEye((EntityLivingBase)this.field_70789_a);
                        this.sendRespawnDelay = 100;
                    }
                } else {
                    this.setSendMode(false);
                }
            }
        } else {
            this.field_70789_a = null;
            this.hasBeenAttacked = false;
            this.killEyes();
            this.setAwake(false);
            this.setSendMode(false);
        }
        if (!this.hasBeenAttacked && this.isAwake()) {
            this.killEyes();
        }
        if (this.eyes.size() > this.eyeCap) {
            this.eyes.remove(0).func_70106_y();
        }
        if (this.scareTime > 0) {
            --this.scareTime;
        }
        if (this.sendDelay > 0) {
            --this.sendDelay;
        }
        if (this.sendRespawnDelay > 0) {
            --this.sendRespawnDelay;
        }
    }

    @Override
    protected void func_70785_a(Entity entity, float f) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)entity;
            if (f < 8.5f && this.func_70685_l((Entity)target)) {
                double d = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70161_v - this.field_70161_v;
                if (target.field_70128_L || !this.func_70685_l((Entity)target)) {
                    target = null;
                }
                this.field_70177_z = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
                this.field_70787_b = true;
            }
        }
    }

    public void sendEye(EntityLivingBase target) {
        while (this.eyes.size() > this.eyeCap) {
            this.eyes.remove(0).func_70106_y();
        }
        this.hasBeenAttacked = true;
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        EntityHostEye eye = new EntityHostEye(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v + 1.5, this.field_70177_z, this.field_70125_A, this, target);
        this.field_70170_p.func_72838_d((Entity)eye);
        this.field_70170_p.func_72956_a((Entity)this, "aether:aeboss.slider.awake", 2.5f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.eyes.add(eye);
        this.sendDelay = 30;
        if (this.func_70610_aX()) {
            this.killEyes();
        }
    }

    public void killEyes() {
        while (this.eyes.size() != 0) {
            this.eyes.remove(0).func_70106_y();
        }
    }

    private void scareItUp() {
        if (this.scareTime <= 0) {
            this.field_70170_p.func_72956_a((Entity)this, "aether:aemob.sentryGolem.creepySeen", 5.0f, 1.0f);
            this.scareTime = 2000;
        }
    }

    public void func_70024_g(double d, double d1, double d2) {
        if (this.isAwake() && !this.isSendMode()) {
            super.func_70024_g(d, d1, d2);
        }
    }

    public void func_70018_K() {
        if (this.isAwake() && !this.isSendMode()) {
            super.func_70018_K();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        this.hasBeenAttacked = true;
        Entity entity = source.func_76364_f();
        Entity attacker = source.func_76346_g();
        if (entity != null && source.func_76352_a()) {
            if (attacker instanceof EntityPlayer && ((EntityPlayer)attacker).func_71045_bC() != null) {
                this.chatItUp((EntityPlayer)attacker, "Better switch to a sword, my " + ((EntityPlayer)attacker).func_71045_bC().func_77973_b().func_77653_i(((EntityPlayer)attacker).func_71045_bC()) + " doesn't seem to affect it.");
                this.chatTime = 60;
            }
            return false;
        }
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            PlayerAether playerInfo = PlayerAether.get(player);
            if (!player.field_70128_L) {
                if (!this.isAwake()) {
                    this.setAwake(true);
                }
                if (this.eyes.size() <= 0 && this.func_70685_l((Entity)player)) {
                    this.setSendMode(true);
                }
                playerInfo.setCurrentBoss(this);
            }
        }
        return super.func_70097_a(source, damage);
    }

    private void chatItUp(EntityPlayer player, String s) {
        if (this.chatTime <= 0) {
            Aether.proxy.displayMessage(player, s);
            this.chatTime = 60;
        }
    }

    @Override
    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.field_70146_Z.nextInt(25) == 0 && this.func_70783_a(i, j, k) >= 0.0f && this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D) && this.field_70170_p.field_73013_u.func_151525_a() > 0;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.hasBeenAttacked = nbttagcompound.func_74767_n("HasBeenAttacked");
        this.killEyes();
        this.setAwake(nbttagcompound.func_74767_n("Awake"));
        this.setSendMode(nbttagcompound.func_74767_n("SendMode"));
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        nbttagcompound.func_74757_a("HasBeenAttacked", this.hasBeenAttacked);
        nbttagcompound.func_74757_a("Awake", this.isAwake());
        nbttagcompound.func_74757_a("SendMode", this.isSendMode());
    }

    @Override
    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            Dungeon dungeon;
            if (source.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer attackingPlayer = (EntityPlayer)source.func_76346_g();
                dungeon = PlayerAether.get(attackingPlayer).getDungeon();
            } else {
                dungeon = DungeonHandler.instance().getDungeonAt((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            }
            if (dungeon != null) {
                dungeon.addKeyFragment();
            }
        }
        this.killEyes();
        super.func_70645_a(source);
    }

    @Override
    public String getBossTitle() {
        return this.bossName + ", the Slider Host Mimic";
    }

    @Override
    public int getBossStage() {
        return 0;
    }

    @Override
    public EnumBossType getBossType() {
        return EnumBossType.MINI;
    }

    @Override
    public int getCoinDrops() {
        return 0;
    }

    @Override
    public int spawnEggID() {
        return 20;
    }
}

