/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities.bosses;

import java.util.List;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.AetherNameGen;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.dungeons.DungeonHandler;
import net.aetherteam.aether.entities.ai.AIEntityArrowAttackCog;
import net.aetherteam.aether.entities.bosses.EntityBossMob;
import net.aetherteam.aether.entities.bosses.EntityCog;
import net.aetherteam.aether.enums.EnumBossType;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityLabyrinthEye
extends EntityBossMob
implements IRangedAttackMob {
    public String bossName;
    private int chatTime;
    public int timeUntilShoot = 30;
    private final boolean[] stageDone = new boolean[13];
    private int stage;

    public EntityLabyrinthEye(World par1World) {
        super(par1World);
        this.field_70178_ae = true;
        this.bossName = AetherNameGen.gen();
        for (int i = 0; i < 12; ++i) {
            this.stageDone[i] = false;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_70105_a(2.0f, 2.0f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0);
        this.func_70606_j(250.0f);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIEntityArrowAttackCog(this, 0.5f, 60, 10.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public boolean func_70692_ba() {
        return false;
    }

    @Override
    protected void func_70785_a(Entity entity, float f) {
        if (entity instanceof EntityLivingBase) {
            this.func_70784_b(entity);
            if (f < 10.0f) {
                double d = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70161_v - this.field_70161_v;
                if (this.func_70777_m() != null) {
                    if (this.func_70777_m().field_70128_L || (double)this.func_70777_m().func_70032_d((Entity)this) > 12.0) {
                        this.func_70784_b(null);
                        this.field_70724_aR = 0;
                    } else if (this.getAwake() && this.field_70724_aR >= this.timeUntilShoot) {
                        this.attackEntity(this.func_70777_m());
                    }
                    if (this.field_70724_aR >= this.timeUntilShoot && this.func_70685_l(this.func_70777_m())) {
                        this.field_70724_aR = -10;
                    }
                    if (this.field_70724_aR < this.timeUntilShoot) {
                        this.field_70724_aR += 2;
                    }
                    for (int stage = 0; stage < 13; ++stage) {
                        if (!this.isBossStage(stage) || this.stageDone[stage]) continue;
                        this.setStage(stage);
                        this.spawnLargeCog(this.func_70777_m(), stage);
                    }
                }
                this.field_70177_z = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
                int x = MathHelper.func_76128_c((double)entity.field_70165_t);
                int y = MathHelper.func_76128_c((double)entity.field_70163_u);
                int n = MathHelper.func_76128_c((double)entity.field_70161_v);
            }
        }
    }

    private void setStage(int stage) {
        this.field_70180_af.func_75692_b(17, (Object)stage);
        this.stage = stage;
    }

    public int getStage() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void attackEntity(Entity entityToAttack) {
        EntityCog entityarrow = new EntityCog(this.field_70170_p, this.field_70165_t - 0.25, this.field_70163_u + 2.35, this.field_70161_v - 0.25, false, (EntityLiving)this);
        entityarrow.field_70177_z = this.field_70761_aq;
        entityarrow.field_70761_aq = this.field_70761_aq;
        entityarrow.field_70125_A = this.field_70125_A;
        double var3 = entityToAttack.field_70165_t + entityToAttack.field_70159_w - this.field_70165_t;
        double var5 = entityToAttack.field_70163_u + -this.field_70163_u;
        double var7 = entityToAttack.field_70161_v + entityToAttack.field_70179_y - this.field_70161_v;
        float var9 = MathHelper.func_76133_a((double)(var3 * var3 + var7 * var7));
        if (!this.field_70170_p.field_72995_K) {
            float distance = var9 * 0.075f;
            entityarrow.setThrowableHeading(var3, var5 + (double)(var9 * 0.2f), var7, distance, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entityarrow);
        }
    }

    public void spawnLargeCog(Entity entityToAttack, int stage) {
        if (this.stageDone[stage]) {
            return;
        }
        EntityCog entityarrow = new EntityCog(this.field_70170_p, this.field_70165_t - 0.25, this.field_70163_u + 2.35, this.field_70161_v - 0.25, true, (EntityLiving)this);
        entityarrow.field_70177_z = this.field_70761_aq;
        entityarrow.field_70761_aq = this.field_70761_aq;
        entityarrow.field_70125_A = this.field_70125_A;
        double var3 = entityToAttack.field_70165_t + entityToAttack.field_70159_w - this.field_70165_t;
        double var5 = entityToAttack.field_70163_u + -this.field_70163_u;
        double var7 = entityToAttack.field_70161_v + entityToAttack.field_70179_y - this.field_70161_v;
        float var9 = MathHelper.func_76133_a((double)(var3 * var3 + var7 * var7));
        if (!this.field_70170_p.field_72995_K) {
            float distance = var9 * 0.075f;
            entityarrow.setThrowableHeading(var3, var5 + (double)(var9 * 0.2f), var7, distance, 0.0f);
            this.field_70170_p.func_72956_a((Entity)this, "aether:aemob.labyrinthsEye.cogloss", 2.0f, 1.0f);
            this.func_85030_a("random.break", 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            this.field_70170_p.func_72838_d((Entity)entityarrow);
        }
        this.stageDone[stage] = true;
    }

    protected String func_70673_aS() {
        return "aether:aemob.labyrinthsEye.eyedeath";
    }

    protected String func_70639_aQ() {
        return "aether:aemob.labyrinthsEye.move";
    }

    @Override
    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            Dungeon dungeon;
            if (source.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer attackingPlayer = (EntityPlayer)source.func_76346_g();
                dungeon = PlayerAether.get(attackingPlayer).getDungeon();
            } else {
                dungeon = DungeonHandler.instance().getDungeonAt((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
            }
            if (dungeon != null) {
                dungeon.addKeyFragment();
            }
        }
        super.func_70645_a(source);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.getAwake()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        this.func_70066_B();
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72314_b(1.0, 1.0, 1.0);
        List entityInBounds = this.field_70170_p.func_72839_b((Entity)this, bounds);
        if (entityInBounds.size() > 0 && this.getAwake()) {
            for (Object entityInBound : entityInBounds) {
                Entity attackedEntity = (Entity)entityInBound;
                if (!(attackedEntity instanceof EntityLiving)) continue;
                attackedEntity.func_70097_a(DamageSource.field_76377_j, (float)MathHelper.func_76125_a((int)this.field_70146_Z.nextInt(6), (int)4, (int)6));
                attackedEntity.field_70159_w *= 1.2432525;
                attackedEntity.field_70181_x *= 1.2432525;
                attackedEntity.field_70179_y *= 1.2432525;
                attackedEntity.field_70133_I = true;
            }
        }
        if (this.func_70777_m() != null && this.chatTime >= 0) {
            --this.chatTime;
        }
        this.field_70143_R = 0.0f;
        if (this.field_70789_a != null && this.getAwake()) {
            this.func_70785_a(this.field_70789_a, this.func_70032_d(this.field_70789_a));
            if (this.field_70789_a instanceof EntityPlayer) {
                // empty if block
            }
        }
    }

    private boolean isBossStage(int stage) {
        switch (stage) {
            case 1: {
                return this.func_110143_aJ() <= 250.0f && this.func_110143_aJ() >= 231.0f;
            }
            case 2: {
                return this.func_110143_aJ() < 231.0f && this.func_110143_aJ() >= 212.0f;
            }
            case 3: {
                return this.func_110143_aJ() < 212.0f && this.func_110143_aJ() >= 193.0f;
            }
            case 4: {
                return this.func_110143_aJ() < 193.0f && this.func_110143_aJ() >= 174.0f;
            }
            case 5: {
                return this.func_110143_aJ() < 174.0f && this.func_110143_aJ() >= 155.0f;
            }
            case 6: {
                return this.func_110143_aJ() < 155.0f && this.func_110143_aJ() >= 136.0f;
            }
            case 7: {
                return this.func_110143_aJ() < 136.0f && this.func_110143_aJ() >= 117.0f;
            }
            case 8: {
                return this.func_110143_aJ() < 117.0f && this.func_110143_aJ() >= 98.0f;
            }
            case 9: {
                return this.func_110143_aJ() < 98.0f && this.func_110143_aJ() >= 79.0f;
            }
            case 10: {
                return this.func_110143_aJ() < 79.0f && this.func_110143_aJ() >= 60.0f;
            }
            case 11: {
                return this.func_110143_aJ() < 60.0f && this.func_110143_aJ() >= 41.0f;
            }
            case 12: {
                return this.func_110143_aJ() < 41.0f && this.func_110143_aJ() >= 22.0f;
            }
            case 13: {
                return this.func_110143_aJ() < 3.0f;
            }
        }
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        Entity entity = source.func_76364_f();
        Entity attacker = source.func_76346_g();
        if (entity != null && source.func_76352_a()) {
            if (attacker instanceof EntityPlayer && ((EntityPlayer)attacker).func_71045_bC() != null) {
                this.chatItUp((EntityPlayer)attacker, "Better switch to a sword, my " + ((EntityPlayer)attacker).func_71045_bC().func_77973_b().func_77653_i(((EntityPlayer)attacker).func_71045_bC()) + " doesn't seem to affect it.");
                this.chatTime = 60;
            }
            return false;
        }
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            PlayerAether playerInfo = PlayerAether.get(player);
            playerInfo.setCurrentBoss(this);
        }
        this.setAwake(true);
        this.func_70784_b(attacker);
        return super.func_70097_a(source, damage);
    }

    private void chatItUp(EntityPlayer player, String s) {
        if (this.chatTime <= 0) {
            Aether.proxy.displayMessage(player, s);
            this.chatTime = 60;
        }
    }

    @Override
    protected Entity func_70782_k() {
        if (this.getAwake()) {
            EntityPlayer var1 = this.field_70170_p.func_72856_b((Entity)this, 16.0);
            return var1 != null && this.func_70685_l((Entity)var1) ? var1 : null;
        }
        return null;
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("Awake", this.getAwake());
        par1NBTTagCompound.func_74768_a("Stage", this.stage);
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setAwake(par1NBTTagCompound.func_74767_n("Awake"));
        this.setStage(par1NBTTagCompound.func_74762_e("Stage"));
    }

    public boolean getAwake() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public void setAwake(boolean awake) {
        if (awake) {
            this.field_70180_af.func_75692_b(16, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(16, (Object)0);
        }
    }

    @Override
    public String getBossTitle() {
        return this.bossName + ", the Labyrinth's Eye";
    }

    public void func_82196_d(EntityLivingBase entityliving, float f) {
    }

    @Override
    public int getCoinDrops() {
        return 3 + this.random.nextInt(4);
    }

    @Override
    public int getBossStage() {
        return 0;
    }

    @Override
    public EnumBossType getBossType() {
        return EnumBossType.MINI;
    }

    @Override
    public int spawnEggID() {
        return 22;
    }
}

