/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.entities.ai;

import java.util.List;
import java.util.Random;
import net.aetherteam.aether.entities.util.IFlyingMob;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;

public class AIEntityFlyingMob
extends EntityAIBase {
    public EntityLiving flyingMob;
    public Entity targetedEntity = null;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    public double targetX;
    public double targetY;
    public double targetZ;
    public double distReqForTarget = 15.0;
    public boolean divepointSet = false;
    public boolean dive = false;
    public boolean shouldLook = true;
    public Random rand;
    public int xpov = 1;
    public int zpov = 1;
    public int updateTime = 0;
    public int aggroCooldown = 0;
    public int attackCounter = 0;
    public float sinage;

    public AIEntityFlyingMob(Random rand, EntityLiving flyingMob) {
        this.flyingMob = flyingMob;
        this.rand = rand;
        this.xpov = this.rand.nextBoolean() ? -1 : 1;
        this.zpov = this.rand.nextBoolean() ? -1 : 1;
    }

    public boolean func_75250_a() {
        return this.flyingMob instanceof IFlyingMob && ((IFlyingMob)this.flyingMob).fly();
    }

    public void func_75246_d() {
        if (this.targetedEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.targetedEntity;
            if (player.field_71075_bZ.field_75098_d) {
                this.targetedEntity = null;
            }
        }
        super.func_75246_d();
        ((IFlyingMob)this.flyingMob).setSinage(this.sinage);
        double d = this.waypointX - this.flyingMob.field_70165_t;
        double d2 = this.waypointZ - this.flyingMob.field_70161_v;
        float rotateTo = -((float)Math.atan2(d, d2));
        this.flyingMob.func_70671_ap().func_75650_a(this.waypointX, this.waypointY, this.waypointZ, rotateTo, 0.0f);
        this.sinage = this.flyingMob.field_70737_aN > 0 ? (this.sinage += 0.9f) : (this.sinage += 0.2f);
        if (this.sinage > 6.283186f) {
            this.sinage -= 6.283186f;
        }
        if (this.targetedEntity != null && (this.targetedEntity.field_70128_L || Math.abs(this.flyingMob.field_70165_t - this.targetedEntity.field_70165_t) > this.distReqForTarget || Math.abs(this.flyingMob.field_70161_v - this.targetedEntity.field_70161_v) > this.distReqForTarget)) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null || this.aggroCooldown-- <= 0) {
            AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)this.flyingMob.field_70165_t, (double)this.flyingMob.field_70163_u, (double)this.flyingMob.field_70161_v, (double)this.flyingMob.field_70165_t, (double)this.flyingMob.field_70163_u, (double)this.flyingMob.field_70161_v).func_72314_b(this.distReqForTarget, 200.0, this.distReqForTarget);
            List list = this.flyingMob.field_70170_p.func_72872_a(EntityPlayer.class, bounds);
            for (int i = 0; i < list.size(); ++i) {
                if (list.size() <= 0 || ((EntityPlayer)list.get((int)i)).field_71075_bZ.field_75098_d) continue;
                this.targetedEntity = (EntityPlayer)list.get(i);
            }
            if (this.targetedEntity != null) {
                this.aggroCooldown = 20;
            }
        }
        if (this.targetedEntity == null || !((IFlyingMob)this.flyingMob).hostileMob()) {
            this.randomMovement();
        } else if (this.targetedEntity != null) {
            if (this.dive) {
                this.dive();
            } else {
                this.orbitPlayer();
            }
        }
    }

    private boolean isCourseTraversable(double d, double d1, double d2, double d3) {
        double d4 = (this.waypointX - this.flyingMob.field_70165_t) / d3;
        double d5 = (this.waypointY - this.flyingMob.field_70163_u) / d3;
        double d6 = (this.waypointZ - this.flyingMob.field_70161_v) / d3;
        AxisAlignedBB axisalignedbb = this.flyingMob.field_70121_D.func_72329_c();
        int i = 1;
        while ((double)i < d3) {
            axisalignedbb.func_72317_d(d4, d5, d6);
            if (this.flyingMob.field_70170_p.func_72945_a((Entity)this.flyingMob, axisalignedbb).size() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void randomMovement() {
        double d = this.waypointX - this.flyingMob.field_70165_t;
        double d1 = this.waypointY - this.flyingMob.field_70163_u;
        double d2 = this.waypointZ - this.flyingMob.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        if (d3 < 4.0 || d3 > 40.0) {
            this.waypointX = this.flyingMob.field_70165_t + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 30.0f);
            this.waypointY = this.flyingMob.field_70163_u + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 30.0f);
            this.waypointZ = this.flyingMob.field_70161_v + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 30.0f);
        }
        if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d3)) {
            float speed = ((IFlyingMob)this.flyingMob).getFlySpeed();
            this.flyingMob.field_70159_w = d / d3 * (double)speed;
            this.flyingMob.field_70181_x = d1 / d3 * (double)speed;
            this.flyingMob.field_70179_y = d2 / d3 * (double)speed;
        } else {
            this.waypointX = this.flyingMob.field_70165_t + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointY = this.flyingMob.field_70163_u + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointZ = this.flyingMob.field_70161_v + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
    }

    private void dive() {
        float speed = ((IFlyingMob)this.flyingMob).getFlySpeed();
        if (!this.divepointSet) {
            double randomHeight = (double)this.rand.nextFloat() * 2.0;
            double distance = MathHelper.func_76133_a((double)(9.0 - randomHeight * randomHeight));
            double x = (double)this.rand.nextFloat() * distance;
            double y = MathHelper.func_76133_a((double)(distance * distance - x * x));
            this.waypointX = this.targetedEntity.field_70165_t + x * (double)this.xpov;
            this.waypointY = this.targetedEntity.field_70163_u + randomHeight;
            this.waypointZ = this.targetedEntity.field_70161_v + y * (double)this.zpov;
            this.targetX = this.targetedEntity.field_70165_t;
            this.targetY = this.targetedEntity.field_70163_u;
            this.targetZ = this.targetedEntity.field_70161_v;
            this.divepointSet = true;
            double d = this.waypointX - this.flyingMob.field_70165_t;
            double d1 = this.waypointY - this.flyingMob.field_70163_u;
            double d2 = this.waypointZ - this.flyingMob.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
            if (!this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d3)) {
                this.divepointSet = false;
            }
        } else {
            double d = this.waypointX - this.flyingMob.field_70165_t;
            double d1 = this.waypointY - this.flyingMob.field_70163_u;
            double d2 = this.waypointZ - this.flyingMob.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d3)) {
                this.flyingMob.field_70159_w = d / d3 * (double)speed;
                this.flyingMob.field_70181_x = d1 / d3 * (double)speed;
                this.flyingMob.field_70179_y = d2 / d3 * (double)speed;
            } else {
                this.divepointSet = false;
                this.dive = false;
                this.updateTime = -1;
            }
            if (d3 < 1.0) {
                if (!this.flyingMob.field_70170_p.field_72995_K) {
                    ((IFlyingMob)this.flyingMob).setAttacking(true);
                }
                this.divepointSet = true;
            }
        }
    }

    private void orbitPlayer() {
        double d = this.waypointX - this.flyingMob.field_70165_t;
        double d1 = this.waypointY - this.flyingMob.field_70163_u;
        double d2 = this.waypointZ - this.flyingMob.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        this.flyingMob.field_70177_z = (float)Math.toDegrees(Math.atan2(d2, d));
        if (this.updateTime-- < 0) {
            this.updateTime = this.rand.nextInt(5) + 40;
            double randomHeight = (double)this.rand.nextFloat() * 10.0;
            double distance = MathHelper.func_76133_a((double)(196.0 - randomHeight * randomHeight));
            double x = (double)this.rand.nextFloat() * distance;
            double y = MathHelper.func_76133_a((double)(distance * distance - x * x));
            if (this.rand.nextInt(8) == 0) {
                this.xpov = this.rand.nextBoolean() ? -1 : 1;
                this.zpov = this.rand.nextBoolean() ? -1 : 1;
            }
            this.waypointX = this.targetedEntity.field_70165_t + x * (double)this.xpov;
            this.waypointY = this.targetedEntity.field_70163_u + randomHeight;
            this.waypointZ = this.targetedEntity.field_70161_v + y * (double)this.zpov;
        }
        if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d3)) {
            float speed = ((IFlyingMob)this.flyingMob).getFlySpeed();
            this.flyingMob.field_70159_w = d / d3 * (double)speed;
            this.flyingMob.field_70181_x = d1 / d3 * (double)speed;
            this.flyingMob.field_70179_y = d2 / d3 * (double)speed;
        }
        if (d3 < 1.0) {
            if (this.rand.nextInt(6) == 0) {
                this.dive = true;
            }
            this.flyingMob.field_70159_w = 0.0;
            this.flyingMob.field_70181_x = 0.0;
            this.flyingMob.field_70179_y = 0.0;
        }
    }
}

