/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.client.gui.util;

import java.util.Random;
import net.aetherteam.aether.client.gui.GuiCustomScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public abstract class GuiPanoramaScreen
extends GuiCustomScreen {
    private static final Random rand = new Random();
    private float updateCounter = rand.nextFloat();
    private int panoramaTimer = 0;
    private ResourceLocation viewportTextureLocation;

    public GuiPanoramaScreen() {
        super(null, null, 0, 0);
    }

    @Override
    public void func_73876_c() {
        ++this.panoramaTimer;
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        DynamicTexture viewportTexture = new DynamicTexture(256, 256);
        this.viewportTextureLocation = this.field_146297_k.field_71446_o.func_110578_a("aether_background", viewportTexture);
    }

    protected void drawPanorama(int par1, int par2, float par3) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        int b0 = 8;
        for (int k = 0; k < b0 * b0; ++k) {
            GL11.glPushMatrix();
            float f1 = ((float)(k % b0) / (float)b0 - 0.5f) / 64.0f;
            float f2 = ((float)(k / b0) / (float)b0 - 0.5f) / 64.0f;
            float f3 = 0.0f;
            GL11.glTranslatef((float)f1, (float)f2, (float)f3);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)(((float)this.panoramaTimer + par3) / 400.0f)) * 25.0f + 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-((float)this.panoramaTimer + par3) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int l = 0; l < 6; ++l) {
                GL11.glPushMatrix();
                if (l == 1) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (l == 2) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (l == 3) {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (l == 4) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (l == 5) {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                this.field_146297_k.field_71446_o.func_110577_a(this.getPanoramaPaths()[l]);
                tessellator.func_78382_b();
                tessellator.func_78384_a(0xFFFFFF, 255 / (k + 1));
                float f4 = 0.0f;
                tessellator.func_78374_a(-1.0, -1.0, 1.0, (double)(0.0f + f4), (double)(0.0f + f4));
                tessellator.func_78374_a(1.0, -1.0, 1.0, (double)(1.0f - f4), (double)(0.0f + f4));
                tessellator.func_78374_a(1.0, 1.0, 1.0, (double)(1.0f - f4), (double)(1.0f - f4));
                tessellator.func_78374_a(-1.0, 1.0, 1.0, (double)(0.0f + f4), (double)(1.0f - f4));
                tessellator.func_78381_a();
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2929);
    }

    private void rotateAndBlurSkybox(float par1) {
        this.field_146297_k.field_71446_o.func_110577_a(this.viewportTextureLocation);
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        int b0 = 3;
        for (int i = 0; i < b0; ++i) {
            tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f / (float)(i + 1));
            int j = this.field_146294_l;
            int k = this.field_146295_m;
            float f1 = (float)(i - b0 / 2) / 256.0f;
            tessellator.func_78374_a((double)j, (double)k, (double)this.field_73735_i, (double)(0.0f + f1), 0.0);
            tessellator.func_78374_a((double)j, 0.0, (double)this.field_73735_i, (double)(1.0f + f1), 0.0);
            tessellator.func_78374_a(0.0, 0.0, (double)this.field_73735_i, (double)(1.0f + f1), 1.0);
            tessellator.func_78374_a(0.0, (double)k, (double)this.field_73735_i, (double)(0.0f + f1), 1.0);
        }
        tessellator.func_78381_a();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    protected void renderSkybox(int par1, int par2, float par3) {
        GL11.glViewport((int)0, (int)0, (int)256, (int)256);
        this.drawPanorama(par1, par2, par3);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3553);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        GL11.glViewport((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        float f1 = this.field_146294_l > this.field_146295_m ? 120.0f / (float)this.field_146294_l : 120.0f / (float)this.field_146295_m;
        float f2 = (float)this.field_146295_m * f1 / 256.0f;
        float f3 = (float)this.field_146294_l * f1 / 256.0f;
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        int k = this.field_146294_l;
        int l = this.field_146295_m;
        tessellator.func_78374_a(0.0, (double)l, (double)this.field_73735_i, (double)(0.5f - f2), (double)(0.5f + f3));
        tessellator.func_78374_a((double)k, (double)l, (double)this.field_73735_i, (double)(0.5f - f2), (double)(0.5f - f3));
        tessellator.func_78374_a((double)k, 0.0, (double)this.field_73735_i, (double)(0.5f + f2), (double)(0.5f - f3));
        tessellator.func_78374_a(0.0, 0.0, (double)this.field_73735_i, (double)(0.5f + f2), (double)(0.5f + f3));
        tessellator.func_78381_a();
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        if (this.shouldDrawPanorama()) {
            this.renderSkybox(par1, par2, par3);
            Tessellator tessellator = Tessellator.field_78398_a;
            int short1 = 274;
            int k = this.field_146294_l / 2 - short1 / 2;
            int b0 = 30;
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -2130706433, 0xFFFFFF);
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, 0, Integer.MIN_VALUE);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if ((double)this.updateCounter < 1.0E-4) {
                this.func_73729_b(k, b0, 0, 0, 99, 44);
                this.func_73729_b(k + 99, b0, 129, 0, 27, 44);
                this.func_73729_b(k + 99 + 26, b0, 126, 0, 3, 44);
                this.func_73729_b(k + 99 + 26 + 3, b0, 99, 0, 26, 44);
                this.func_73729_b(k + 155, b0, 0, 45, 155, 44);
            }
            tessellator.func_78378_d(0xFFFFFF);
        }
        super.func_73863_a(par1, par2, par3);
    }

    public boolean shouldDrawPanorama() {
        return true;
    }

    public abstract ResourceLocation[] getPanoramaPaths();
}

