/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.client.gui.notifications;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.aetherteam.aether.data.AetherOptions;
import net.aetherteam.aether.notifications.Notification;
import net.aetherteam.aether.notifications.NotificationType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiNotification
extends Gui {
    private static final ResourceLocation TEXTURE_NOTIFICATIONS = new ResourceLocation("aether", "textures/gui/notification/notifications.png");
    private Minecraft theGame;
    private int gameWindowWidth;
    private int gameWindowHeight;
    private String headerText;
    private String senderName;
    private Notification theNotification;
    private long notificationTime;
    private RenderItem itemRender;
    private boolean haveNotification;

    public GuiNotification(Minecraft mc) {
        this.theGame = mc;
        this.itemRender = new RenderItem();
    }

    public void queueReceivedNotification(Notification notification) {
        if (AetherOptions.getShowNotifications()) {
            this.headerText = notification.getHeaderText();
            this.senderName = notification.getType() == NotificationType.GENERIC ? notification.getSender().getUsername() : (notification.getSender() == null ? "To " + notification.getReceiver().getUsername() : "From " + notification.getSender().getUsername());
            this.notificationTime = Minecraft.func_71386_F();
            this.theNotification = notification;
            this.haveNotification = false;
        }
    }

    public void queueSentNotification(Notification notification) {
        if (AetherOptions.getShowNotifications()) {
            this.headerText = notification.getHeaderText();
            this.senderName = "";
            this.notificationTime = Minecraft.func_71386_F();
            this.theNotification = notification;
            this.haveNotification = false;
        }
    }

    public void queueAchievementInformation(Notification notification) {
        this.headerText = notification.getHeaderText();
        this.senderName = notification.getType() == NotificationType.GENERIC ? notification.getSender().getUsername() : (notification.getSender() == null ? "To " + notification.getReceiver().getUsername() : "From " + notification.getSender().getUsername());
        this.notificationTime = Minecraft.func_71386_F() - 2500L;
        this.theNotification = notification;
        this.haveNotification = true;
    }

    private void updateAchievementWindowScale() {
        GL11.glViewport((int)0, (int)0, (int)this.theGame.field_71443_c, (int)this.theGame.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.gameWindowWidth = this.theGame.field_71443_c;
        this.gameWindowHeight = this.theGame.field_71440_d;
        ScaledResolution scaledresolution = new ScaledResolution(this.theGame, this.theGame.field_71443_c, this.theGame.field_71440_d);
        this.gameWindowWidth = scaledresolution.func_78326_a();
        this.gameWindowHeight = scaledresolution.func_78328_b();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.gameWindowWidth, (double)this.gameWindowHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void updateNotificationWindow() {
        if (this.theNotification != null && this.notificationTime != 0L) {
            double d0 = (double)(Minecraft.func_71386_F() - this.notificationTime) / 3000.0;
            if (!this.haveNotification && (d0 < 0.0 || d0 > 1.0)) {
                this.notificationTime = 0L;
            } else {
                this.updateAchievementWindowScale();
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                double d1 = d0 * 2.0;
                if (d1 > 1.0) {
                    d1 = 2.0 - d1;
                }
                d1 *= 4.0;
                if ((d1 = 1.0 - d1) < 0.0) {
                    d1 = 0.0;
                }
                d1 *= d1;
                d1 *= d1;
                int i = 0;
                int j = 0 - (int)(d1 * 36.0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3553);
                this.theGame.field_71446_o.func_110577_a(TEXTURE_NOTIFICATIONS);
                GL11.glDisable((int)2896);
                this.func_73729_b(i, j, 96, 202, 160, 32);
                int textOffsetX = 45;
                if (this.haveNotification) {
                    this.theGame.field_71466_p.func_78279_b(this.senderName, i + textOffsetX, j + 7, 120, -1);
                } else {
                    this.theGame.field_71466_p.func_78276_b(this.headerText, i + textOffsetX, j + 7, -256);
                    this.theGame.field_71466_p.func_78276_b(this.senderName, i + textOffsetX, j + 18, -1);
                }
                RenderHelper.func_74520_c();
                GL11.glDisable((int)2896);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2903);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)2896);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
            }
        }
    }
}

