/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.common.config.Configuration;

public class AetherConfig {
    public static File cfglocation;
    public static final SpawningConfig aechorPlantConfig;
    public static final SpawningConfig aerbunnyConfig;
    public static final SpawningConfig carrionSproutConfig;
    public static final SpawningConfig cockatriceConfig;
    public static final SpawningConfig flyingCowConfig;
    public static final SpawningConfig moaConfig;
    public static final SpawningConfig phygConfig;
    public static final SpawningConfig sheepuffConfig;
    public static final SpawningConfig swetConfig;
    public static final SpawningConfig tempestConfig;
    public static final SpawningConfig zephyrConfig;
    public static final SpawningConfig zephyrooConfig;
    public static boolean UseAetherMenu;
    public static int AetherDimensionID;
    public static int DungeonDimensionID;
    public static int AetherBiomeID;
    public static int DungeonBiomeID;
    public static int SlowfallPotionID;
    public static int HighStepsPotionID;
    public static boolean GenerateAetherPortals;
    public static boolean EnableChristmasEvent;

    public static void initProps(File location) {
        File newFile = new File(location + "/aether" + "/Aether II.cfg");
        try {
            if (!newFile.exists() && !newFile.createNewFile()) {
                throw new IOException("Couldn't create file!");
            }
        }
        catch (IOException e) {
            System.out.println("Could not create configuration file for Aether II. Reason: ");
            e.printStackTrace();
        }
        Configuration config = new Configuration(newFile);
        cfglocation = location;
        config.load();
        String MenuConfig = "Menu Configuration";
        UseAetherMenu = config.getBoolean(MenuConfig, "Use Aether Menu System", true, "");
        String AetherDimID = "Dimension IDs";
        AetherDimensionID = config.get(AetherDimID, "Aether Dimension ID", 3).getInt(3);
        DungeonDimensionID = config.get(AetherDimID, "Dungeon Dimension ID", 4).getInt(4);
        String BiomeID = "Biome IDs";
        AetherBiomeID = config.get(BiomeID, "Aether Biome ID", 237).getInt(237);
        DungeonBiomeID = config.get(BiomeID, "Dungeon Biome ID", 200).getInt(200);
        String PotionID = "Potion IDs";
        SlowfallPotionID = config.get(PotionID, "Slowfall Potion ID", 25).getInt(25);
        HighStepsPotionID = config.get(PotionID, "High Steps Potion ID", 26).getInt(26);
        String AetherPortalGeneration = "Aether Portal Options";
        GenerateAetherPortals = config.getBoolean("Generate Aether Portals", AetherPortalGeneration, true, "Decides wether or not the Aether will generate portals. (allow player created portals only)");
        EnableChristmasEvent = config.get("Christmas Event", "Enable", false, "Aggressive mobs will randomly drop presents without a Lucky Bell").getBoolean();
        zephyrConfig.readConfig(config);
        cockatriceConfig.readConfig(config);
        tempestConfig.readConfig(config);
        aechorPlantConfig.readConfig(config);
        swetConfig.readConfig(config);
        carrionSproutConfig.readConfig(config);
        moaConfig.readConfig(config);
        zephyrooConfig.readConfig(config);
        flyingCowConfig.readConfig(config);
        phygConfig.readConfig(config);
        aerbunnyConfig.readConfig(config);
        sheepuffConfig.readConfig(config);
        config.save();
    }

    static {
        aechorPlantConfig = new SpawningConfig("Aechor Plant Configuration", 2, 4, 0.4f);
        aerbunnyConfig = new SpawningConfig("Aerbunny Configuration", 2, 5, 0.3f);
        carrionSproutConfig = new SpawningConfig("Carrion Sprout Configuration", 2, 3, 0.4f);
        cockatriceConfig = new SpawningConfig("Cockatrice Configuration", 1, 2, 0.9f);
        flyingCowConfig = new SpawningConfig("Flying Cow Configuration", 1, 4, 0.65f);
        moaConfig = new SpawningConfig("Moa Configuration", 1, 4, 0.44f);
        phygConfig = new SpawningConfig("Phyg Configuration", 1, 4, 0.35f);
        sheepuffConfig = new SpawningConfig("Sheepuff Configuration", 3, 5, 0.5f);
        swetConfig = new SpawningConfig("Swet Configuration", 2, 5, 0.3f);
        tempestConfig = new SpawningConfig("Tempest Configuration", 1, 3, 0.4f);
        zephyrConfig = new SpawningConfig("Zephyr Configuration", 1, 4, 0.4f);
        zephyrooConfig = new SpawningConfig("Zephyroo Configuration", 1, 4, 0.01f);
    }

    public static class SpawningConfig {
        public final String configName;
        private int minGroupSize;
        private int maxGroupSize;
        private float avgAmountOfGroups;

        public SpawningConfig(String configName, int minGroupSize, int maxGroupSize, float avgAmountOfGroups) {
            this.configName = configName;
            this.minGroupSize = minGroupSize;
            this.maxGroupSize = maxGroupSize;
            this.avgAmountOfGroups = avgAmountOfGroups;
        }

        protected void readConfig(Configuration config) {
            this.minGroupSize = config.get(this.configName, "Minimum Group Size", this.minGroupSize).getInt(this.minGroupSize);
            this.maxGroupSize = config.get(this.configName, "Maximum Group Size", this.maxGroupSize).getInt(this.maxGroupSize);
            this.avgAmountOfGroups = (float)config.get(this.configName, "Average Amount of groups in Area", (double)this.avgAmountOfGroups).getDouble((double)this.avgAmountOfGroups);
        }

        public int minGroupSize() {
            return this.minGroupSize;
        }

        public int maxGroupSize() {
            return this.maxGroupSize;
        }

        public float avgAmountOfGroups() {
            return this.avgAmountOfGroups;
        }
    }
}

