/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.TileEntityProjector;
import cuchaz.ships.render.ModelProjector;
import cuchaz.ships.render.RenderShip;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class TileEntityProjectorRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation Texture = new ResourceLocation("ships", "textures/models/projector.png");
    private RenderShip m_shipRenderer;
    private ModelProjector m_model;
    private RenderBlocks m_renderBlocks;
    private Random m_rand;

    public TileEntityProjectorRenderer(RenderShip shipRenderer) {
        this.m_shipRenderer = shipRenderer;
        this.m_model = new ModelProjector();
        this.m_renderBlocks = new RenderBlocks();
        this.m_rand = new Random();
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTickTime) {
        this.renderTileEntityAt((TileEntityProjector)tileEntity, x, y, z, partialTickTime);
    }

    public void renderTileEntityAt(TileEntityProjector projector, double x, double y, double z, float partialTickTime) {
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass == 0) {
            float scaleFactor = 0.0625f;
            this.func_147499_a(Texture);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            this.m_model.render(scaleFactor);
            GL11.glPopMatrix();
        }
        float alpha = 0.5f;
        if ((double)this.m_rand.nextFloat() > 0.01) {
            alpha = 1.0f;
        }
        if (pass == 1) {
            GL11.glEnable((int)3042);
            ShipWorld shipWorld = projector.getShipWorld();
            if (shipWorld != null) {
                this.func_147499_a(TextureMap.field_110575_b);
                GL11.glPushMatrix();
                GL11.glTranslated((double)x, (double)y, (double)z);
                Coords translation = projector.getShipTranslation();
                GL11.glTranslatef((float)translation.x, (float)translation.y, (float)translation.z);
                GL14.glBlendColor((float)(0.19215687f * alpha), (float)(0.53333336f * alpha), (float)alpha, (float)0.0f);
                GL11.glBlendFunc((int)32769, (int)32770);
                this.m_renderBlocks.field_147837_f = true;
                GL11.glCallList((int)this.m_shipRenderer.getDisplayList(this.m_renderBlocks, shipWorld));
                for (Coords coords : shipWorld.coords()) {
                    TileEntity tileEntity = shipWorld.getTileEntity(coords);
                    if (tileEntity == null || !TileEntityRendererDispatcher.field_147556_a.func_147545_a(tileEntity)) continue;
                    TileEntityRendererDispatcher.field_147556_a.func_147549_a(tileEntity, (double)tileEntity.field_145851_c, (double)tileEntity.field_145848_d, (double)tileEntity.field_145849_e, partialTickTime);
                }
                GL11.glPopMatrix();
            }
            this.func_147499_a(Texture);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 1.25), (double)(z + 0.5));
            GL11.glRotatef((float)((float)Math.toDegrees(Math.atan2(x + 0.5, z + 0.5))), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a(-0.5, 0.0, 0.0, 0.5, 0.0);
            tessellator.func_78374_a(-0.5, 1.0, 0.0, 0.5, 1.0);
            tessellator.func_78374_a(0.5, 1.0, 0.0, 1.0, 1.0);
            tessellator.func_78374_a(0.5, 0.0, 0.0, 1.0, 0.0);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
        }
    }
}

