/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.Coords;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;

@SideOnly(value=Side.CLIENT)
public class ShipDebugRenderInfo {
    private boolean m_isRendered = false;
    private BlockSet m_collidedCoords = new BlockSet();
    private Map<Entity, AxisAlignedBB> m_queryBoxes = new HashMap<Entity, AxisAlignedBB>();

    public static boolean isDebugRenderingOn() {
        return Minecraft.func_71410_x().field_71474_y.field_74330_P;
    }

    public BlockSet getCollidedCoords() {
        return this.m_collidedCoords;
    }

    public Iterable<AxisAlignedBB> getQueryBoxes() {
        return this.m_queryBoxes.values();
    }

    public void setRendered() {
        this.m_isRendered = true;
    }

    public void addCollidedCoord(Coords coords) {
        if (this.m_isRendered) {
            this.reset();
        }
        this.m_collidedCoords.add(coords);
    }

    public void setQueryBox(Entity entity, AxisAlignedBB box) {
        if (this.m_isRendered) {
            this.reset();
        }
        this.m_queryBoxes.put(entity, box);
    }

    private void reset() {
        this.m_isRendered = false;
        this.m_collidedCoords.clear();
        this.m_queryBoxes.clear();
    }
}

