/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.render;

import cuchaz.modsShared.ColorUtils;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.math.BoxCorner;
import cuchaz.modsShared.math.CompareReal;
import cuchaz.modsShared.math.Matrix3;
import cuchaz.modsShared.math.RotatedBB;
import cuchaz.modsShared.math.Vector3;
import java.util.Arrays;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static void renderPosition(Entity entity) {
        RenderUtils.renderPoint(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ColorUtils.getColor(0, 255, 0));
    }

    public static void renderPoint(double x, double y, double z, int color) {
        double Halfwidth = 0.05;
        RenderUtils.renderBox(x - 0.05, x + 0.05, y - 0.05, y + 0.05, z - 0.05, z + 0.05, color);
    }

    public static void renderAxis(Entity entity) {
        double Halfwidth = 0.05;
        double HalfHeight = 2.0;
        RenderUtils.renderBox(entity.field_70165_t - 0.05, entity.field_70165_t + 0.05, entity.field_70163_u - 2.0, entity.field_70163_u + 2.0, entity.field_70161_v - 0.05, entity.field_70161_v + 0.05, ColorUtils.getGrey(180));
    }

    public static void renderHitbox(RotatedBB box, int color) {
        double delta = 0.01;
        box.getAABox().field_72340_a -= 0.01;
        box.getAABox().field_72338_b -= 0.01;
        box.getAABox().field_72339_c -= 0.01;
        box.getAABox().field_72336_d += 0.01;
        box.getAABox().field_72337_e += 0.01;
        box.getAABox().field_72334_f += 0.01;
        RenderUtils.renderRotatedBox(box, color);
        box.getAABox().field_72340_a += 0.01;
        box.getAABox().field_72338_b += 0.01;
        box.getAABox().field_72339_c += 0.01;
        box.getAABox().field_72336_d -= 0.01;
        box.getAABox().field_72337_e -= 0.01;
        box.getAABox().field_72334_f -= 0.01;
    }

    public static void renderHitbox(AxisAlignedBB box, int color) {
        double delta = 0.01;
        RenderUtils.renderBox(box.field_72340_a - 0.01, box.field_72336_d + 0.01, box.field_72338_b - 0.01, box.field_72337_e + 0.01, box.field_72339_c - 0.01, box.field_72334_f + 0.01, color);
    }

    public static void renderBox(AxisAlignedBB box, int color, double delta) {
        RenderUtils.renderBox(box.field_72340_a - delta, box.field_72336_d + delta, box.field_72338_b - delta, box.field_72337_e + delta, box.field_72339_c - delta, box.field_72334_f + delta, color);
    }

    public static void renderBox(double xm, double xp, double ym, double yp, double zm, double zp, int color) {
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78384_a(color, 128);
        tessellator.func_78377_a(xm, yp, zm);
        tessellator.func_78377_a(xm, ym, zm);
        tessellator.func_78377_a(xp, ym, zm);
        tessellator.func_78377_a(xp, yp, zm);
        tessellator.func_78377_a(xp, yp, zp);
        tessellator.func_78377_a(xp, ym, zp);
        tessellator.func_78377_a(xm, ym, zp);
        tessellator.func_78377_a(xm, yp, zp);
        tessellator.func_78377_a(xp, yp, zm);
        tessellator.func_78377_a(xp, ym, zm);
        tessellator.func_78377_a(xp, ym, zp);
        tessellator.func_78377_a(xp, yp, zp);
        tessellator.func_78377_a(xm, yp, zp);
        tessellator.func_78377_a(xm, ym, zp);
        tessellator.func_78377_a(xm, ym, zm);
        tessellator.func_78377_a(xm, yp, zm);
        tessellator.func_78377_a(xm, yp, zm);
        tessellator.func_78377_a(xp, yp, zm);
        tessellator.func_78377_a(xp, yp, zp);
        tessellator.func_78377_a(xm, yp, zp);
        tessellator.func_78377_a(xm, ym, zm);
        tessellator.func_78377_a(xp, ym, zm);
        tessellator.func_78377_a(xp, ym, zp);
        tessellator.func_78377_a(xm, ym, zp);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    public static void renderRotatedBox(RotatedBB box, int color) {
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78384_a(color, 128);
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (BlockSide side : Arrays.asList(BlockSide.North, BlockSide.South, BlockSide.East, BlockSide.West)) {
            for (BoxCorner corner : side.getCorners()) {
                box.getCorner(p, corner);
                tessellator.func_78377_a(p.field_72450_a, p.field_72448_b, p.field_72449_c);
            }
        }
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    public static void renderVector(double x, double y, double z, double dx, double dy, double dz, int color) {
        Vector3 v = new Vector3(dx, dy, dz);
        if (CompareReal.eq(v.getSquaredLength(), 0.0)) {
            return;
        }
        double halfWidth = 0.2;
        Vector3[] vertices = new Vector3[]{new Vector3(halfWidth, halfWidth, 0.0), new Vector3(-halfWidth, halfWidth, 0.0), new Vector3(-halfWidth, -halfWidth, 0.0), new Vector3(halfWidth, -halfWidth, 0.0), new Vector3(0.0, 0.0, v.getLength())};
        v.normalize();
        Matrix3 basis = new Matrix3();
        Matrix3.getArbitraryBasisFromZ(basis, v);
        for (Vector3 p : vertices) {
            basis.multiply(p);
            p.x += x;
            p.y += y;
            p.z += z;
        }
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(6);
        tessellator.func_78384_a(color, 128);
        tessellator.func_78377_a(vertices[4].x, vertices[4].y, vertices[4].z);
        tessellator.func_78377_a(vertices[0].x, vertices[0].y, vertices[0].z);
        tessellator.func_78377_a(vertices[1].x, vertices[1].y, vertices[1].z);
        tessellator.func_78377_a(vertices[2].x, vertices[2].y, vertices[2].z);
        tessellator.func_78377_a(vertices[3].x, vertices[3].y, vertices[3].z);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }
}

