/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.render;

import cuchaz.modsShared.ColorUtils;
import cuchaz.modsShared.blocks.BlockArray;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.gui.GuiString;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderShip2D {
    private static final int WaterColor = ColorUtils.getColor(43, 99, 225);
    private static final int SinkColor = ColorUtils.getColor(203, 113, 113);
    private static final ResourceLocation ShipTexture = TextureMap.field_110575_b;

    public static void drawWater(BlockArray envelope, Double waterHeight, Integer sinkHeight, int x, int y, double z, int maxWidth, int maxHeight) {
        double blockSize = RenderShip2D.getBlockSize(maxWidth, maxHeight, envelope);
        double shipHeight = (double)envelope.getHeight() * blockSize;
        int waterRectHeight = maxHeight;
        if (waterHeight != null) {
            waterRectHeight = (int)((waterHeight - (double)envelope.getVMin()) * blockSize + ((double)maxHeight - shipHeight) / 2.0);
            waterRectHeight = Math.min(maxHeight, waterRectHeight);
        }
        RenderShip2D.drawWater(x, y + maxHeight - waterRectHeight, z, maxWidth, waterRectHeight);
        if (waterHeight != null && sinkHeight != null) {
            int sinkLineY = (int)((double)(sinkHeight - envelope.getVMin()) * blockSize + ((double)maxHeight - shipHeight) / 2.0);
            RenderShip2D.drawColoredBlock(x, y + maxHeight - sinkLineY, z, maxWidth, 1.0, SinkColor);
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_78276_b(GuiString.Sink.getLocalizedText(), x, y + maxHeight - sinkLineY - fontRenderer.field_78288_b, SinkColor);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void drawWater(int x, int y, double z, int maxWidth, int maxHeight) {
        RenderShip2D.drawColoredBlock(x, y, z, maxWidth, maxHeight, WaterColor);
    }

    public static void drawShip(BlockArray envelope, BlockSide side, World world, int x, int y, double z, int maxWidth, int maxHeight) {
        double blockSize = RenderShip2D.getBlockSize(maxWidth, maxHeight, envelope);
        double shipWidth = (double)envelope.getWidth() * blockSize;
        double shipHeight = (double)envelope.getHeight() * blockSize;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ShipTexture);
        for (int u = envelope.getUMin(); u <= envelope.getUMax(); ++u) {
            for (int v = envelope.getVMin(); v <= envelope.getVMax(); ++v) {
                Block block;
                IIcon icon;
                Coords coords = envelope.getBlock(u, v);
                if (coords == null || (icon = (block = world.func_147439_a(coords.x, coords.y, coords.z)).func_149673_e((IBlockAccess)world, coords.x, coords.y, coords.z, side.getId())) == null) continue;
                int blockX = envelope.toZeroBasedU(u);
                if (side == BlockSide.North || side == BlockSide.East) {
                    blockX = envelope.getWidth() - blockX - 1;
                }
                int blockY = envelope.getHeight() - envelope.toZeroBasedV(v) - 1;
                RenderShip2D.drawTexturedBlock(((double)maxWidth - shipWidth) / 2.0 + (double)x + (double)blockX * blockSize, ((double)maxHeight - shipHeight) / 2.0 + (double)y + (double)blockY * blockSize, z, blockSize, blockSize, icon);
            }
        }
    }

    public static void drawShipAsColor(BlockArray envelope, int color, int x, int y, double z, int maxWidth, int maxHeight) {
        double blockSize = RenderShip2D.getBlockSize(maxWidth, maxHeight, envelope);
        double shipWidth = (double)envelope.getWidth() * blockSize;
        double shipHeight = (double)envelope.getHeight() * blockSize;
        for (int u = envelope.getUMin(); u <= envelope.getUMax(); ++u) {
            for (int v = envelope.getVMin(); v <= envelope.getVMax(); ++v) {
                Coords coords = envelope.getBlock(u, v);
                if (coords == null) continue;
                RenderShip2D.drawColoredBlock(((double)maxWidth - shipWidth) / 2.0 + (double)x + (double)envelope.toZeroBasedU(u) * blockSize, ((double)maxHeight - shipHeight) / 2.0 + (double)y + (double)(envelope.getHeight() - envelope.toZeroBasedV(v) - 1) * blockSize, z, blockSize, blockSize, color);
            }
        }
    }

    private static double getBlockSize(int maxWidth, int maxHeight, BlockArray envelope) {
        double blockSize = Math.min((double)maxWidth / (double)envelope.getWidth(), (double)maxHeight / (double)envelope.getHeight());
        return blockSize *= 0.8;
    }

    public static void drawColoredBlock(double x, double y, double z, double width, double height, int color) {
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)ColorUtils.getRedf(color), (float)ColorUtils.getGreenf(color), (float)ColorUtils.getBluef(color), (float)ColorUtils.getAlphaf(color));
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a(x + 0.0, y + height, z);
        tessellator.func_78377_a(x + width, y + height, z);
        tessellator.func_78377_a(x + width, y + 0.0, z);
        tessellator.func_78377_a(x + 0.0, y + 0.0, z);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTexturedBlock(double x, double y, double z, double width, double height, IIcon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("No icon for block!");
        }
        double minU = icon.func_94214_a(0.0);
        double maxU = icon.func_94214_a(16.0);
        double minV = icon.func_94207_b(0.0);
        double maxV = icon.func_94207_b(16.0);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + height, z, minU, maxV);
        tessellator.func_78374_a(x + width, y + height, z, maxU, maxV);
        tessellator.func_78374_a(x + width, y + 0.0, z, maxU, minV);
        tessellator.func_78374_a(x + 0.0, y + 0.0, z, minU, minV);
        tessellator.func_78381_a();
    }
}

