/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.render;

import cuchaz.modsShared.ColorUtils;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.EntityShip;
import cuchaz.ships.HitList;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.render.RenderUtils;
import cuchaz.ships.render.ShipDebugRenderInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderShip
extends Render {
    private RenderBlocks m_renderBlocks = new RenderBlocks();
    private Set<Integer> m_blacklistedBlocks = new TreeSet<Integer>();
    private Map<ShipWorld, Integer> m_displayListIds = new HashMap<ShipWorld, Integer>();

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    public void func_76979_b(Entity entity, double x, double y, double z, float yaw, float partialTickTime) {
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.doRender((EntityShip)entity, x, y, z, yaw, partialTickTime);
    }

    public void doRender(EntityShip ship, double x, double y, double z, float yaw, float partialTickTime) {
        ShipWorld shipWorld = ship.getShipWorld();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)ship.blocksToShipX(0.0), (double)ship.blocksToShipY(0.0), (double)ship.blocksToShipZ(0.0));
        RenderHelper.func_74518_a();
        RenderManager.field_78727_a.field_78722_g = shipWorld;
        RenderManager.field_78727_a.field_78724_e.func_110577_a(TextureMap.field_110575_b);
        GL11.glCallList((int)this.getDisplayList(this.m_renderBlocks, shipWorld));
        GL11.glPushMatrix();
        GL11.glTranslated((double)RenderManager.field_78725_b, (double)RenderManager.field_78726_c, (double)RenderManager.field_78723_d);
        for (EntityHanging hangingEntity : shipWorld.hangingEntities().values()) {
            RenderManager.field_78727_a.func_147937_a((Entity)hangingEntity, partialTickTime);
        }
        GL11.glPopMatrix();
        for (Coords coords : shipWorld.coords()) {
            TileEntity tileEntity = shipWorld.getTileEntity(coords);
            if (tileEntity == null || !TileEntityRendererDispatcher.field_147556_a.func_147545_a(tileEntity)) continue;
            try {
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(tileEntity, (double)tileEntity.field_145851_c, (double)tileEntity.field_145848_d, (double)tileEntity.field_145849_e, partialTickTime);
            }
            catch (Throwable t) {
                Ships.logger.error(t, "Tile entity threw up while rendering: %s", Block.field_149771_c.func_148750_c((Object)tileEntity.func_145838_q()));
            }
        }
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
        if (ShipDebugRenderInfo.isDebugRenderingOn()) {
            this.renderDebug(ship, x, y, z, yaw);
        }
    }

    public int getDisplayList(RenderBlocks renderBlocks, ShipWorld shipWorld) {
        Integer id = this.m_displayListIds.get((Object)shipWorld);
        if (id != null && shipWorld.needsRenderUpdate()) {
            GL11.glDeleteLists((int)id, (int)1);
            id = null;
        }
        if (id == null) {
            id = GLAllocation.func_74526_a((int)1);
            this.m_displayListIds.put(shipWorld, id);
            GL11.glNewList((int)id, (int)4864);
            this.renderShip(renderBlocks, shipWorld);
            GL11.glEndList();
        }
        return id;
    }

    private void renderShip(RenderBlocks renderBlocks, ShipWorld shipWorld) {
        renderBlocks.field_147845_a = shipWorld;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (Coords coords : shipWorld.coords()) {
            Block block = shipWorld.getBlock(coords);
            try {
                if (this.m_blacklistedBlocks.contains(Block.func_149682_b((Block)block))) {
                    RenderShip.renderBlockFailsafe(renderBlocks, block, coords);
                    continue;
                }
                RenderShip.renderBlock(renderBlocks, shipWorld, block, coords);
            }
            catch (Throwable t) {
                this.m_blacklistedBlocks.add(Block.func_149682_b((Block)block));
                Ships.logger.warning(t, "Block: %s couldn't render properly! Blocks of this type will not be rendered again.", block.func_149739_a());
            }
        }
        tessellator.func_78381_a();
    }

    public static void renderBlock(RenderBlocks renderBlocks, ShipWorld shipWorld, Block block, Coords coords) {
        block.func_149719_a((IBlockAccess)shipWorld, coords.x, coords.y, coords.z);
        TileEntity tileEntity = shipWorld.getTileEntity(coords);
        if (tileEntity != null && TileEntityRendererDispatcher.field_147556_a.func_147545_a(tileEntity)) {
            return;
        }
        if (block.func_149645_b() == 0) {
            int colorMultiplier = block.func_149720_d((IBlockAccess)shipWorld, coords.x, coords.y, coords.z);
            float colorR = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(colorMultiplier & 0xFF) / 255.0f;
            renderBlocks.func_147775_a(block);
            renderBlocks.func_147736_d(block, coords.x, coords.y, coords.z, colorR, colorG, colorB);
        } else {
            renderBlocks.func_147805_b(block, coords.x, coords.y, coords.z);
        }
    }

    public static void renderBlockFailsafe(RenderBlocks renderBlocks, Block block, Coords coords) {
        try {
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            renderBlocks.func_147775_a(block);
            renderBlocks.func_147736_d(block, coords.x, coords.y, coords.z, 1.0f, 1.0f, 1.0f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void renderDebug(EntityShip ship, double x, double y, double z, float yaw) {
        ShipDebugRenderInfo info = ship.getCollider().getDebugRenderInfo();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)(-ship.field_70165_t), (double)(-ship.field_70163_u), (double)(-ship.field_70161_v));
        RenderUtils.renderAxis(ship);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)ship.blocksToShipX(0.0), (double)ship.blocksToShipY(0.0), (double)ship.blocksToShipZ(0.0));
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        for (Coords coords : ship.getShipWorld().coords()) {
            boxes.clear();
            ship.getCollider().getCollisionBoxesInBlockSpace(boxes, coords, ship.getCollider().getBlockBoxInBlockSpace(coords));
            int color = info.getCollidedCoords().contains(coords) ? ColorUtils.getColor(255, 255, 0) : ColorUtils.getColor(255, 0, 0);
            for (AxisAlignedBB box : boxes) {
                RenderUtils.renderHitbox(box, color);
            }
        }
        double waterHeightInBlockSpace = ship.shipToBlocksY(ship.worldToShipY(ship.getWaterHeight()));
        for (Coords coords : ship.getShipWorld().getDisplacement().getTrappedAirFromWaterHeight(waterHeightInBlockSpace)) {
            AxisAlignedBB box;
            box = ship.getCollider().getBlockBoxInBlockSpace(coords);
            RenderUtils.renderBox(box, ColorUtils.getColor(0, 255, 0), -0.4);
        }
        Vec3 camera = Vec3.func_72443_a((double)RenderManager.field_78725_b, (double)RenderManager.field_78726_c, (double)RenderManager.field_78723_d);
        ship.worldToShip(camera);
        ship.shipToBlocks(camera);
        boolean isFirstPerson = Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        for (AxisAlignedBB box : info.getQueryBoxes()) {
            if (box.func_72318_a(camera) && isFirstPerson) continue;
            RenderUtils.renderHitbox(box, ColorUtils.getColor(0, 255, 0));
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        double reachDist = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        HitList hits = new HitList();
        hits.addHits(ship, (EntityPlayer)player, reachDist);
        hits.addHits(player.field_70170_p, (EntityPlayer)player, reachDist);
        HitList.Entry hit = hits.getClosestHit();
        if (hit != null && hit.type == HitList.Type.Ship) {
            boxes.clear();
            Coords coords = new Coords(hit.hit.field_72311_b, hit.hit.field_72312_c, hit.hit.field_72309_d);
            ship.getCollider().getCollisionBoxesInBlockSpace(boxes, coords, ship.getCollider().getBlockBoxInBlockSpace(coords));
            for (AxisAlignedBB box : boxes) {
                RenderUtils.renderHitbox(box, ColorUtils.getColor(255, 255, 255));
            }
        }
        GL11.glPopMatrix();
        info.setRendered();
    }
}

