/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.propulsion;

import cuchaz.modsShared.Util;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.BlocksStorage;
import cuchaz.ships.propulsion.PropulsionMethod;
import net.minecraft.init.Blocks;

public class Sail
extends PropulsionMethod {
    public static final double ThrustPerForwardBlock = Util.perSecond2ToPerTick2(8.0);
    public static final double ThrustPerSideBlock = Util.perSecond2ToPerTick2(2.0);
    private int m_numForwardBlocks;
    private int m_numSideBlocks;

    protected Sail(BlocksStorage shipBlocks, BlockSet sailBlocks, BlockSide frontDirection) {
        super("Sail", "Sails", sailBlocks);
        this.m_numForwardBlocks = this.getNumExposedBlocks(shipBlocks, sailBlocks, frontDirection);
        this.m_numSideBlocks = this.getNumExposedBlocks(shipBlocks, sailBlocks, frontDirection.rotateXZCw(1));
    }

    @Override
    public double getThrust(double speed) {
        return (ThrustPerForwardBlock * (double)this.m_numForwardBlocks + ThrustPerSideBlock * (double)this.m_numSideBlocks) / (speed + 1.0);
    }

    public boolean isValid() {
        return true;
    }

    private int getNumExposedBlocks(BlocksStorage shipBlocks, BlockSet sailBlocks, BlockSide checkDirection) {
        int numExposedBlocks = 0;
        Coords checkCoords = new Coords();
        for (Coords coords : sailBlocks) {
            checkCoords.set(coords.x + checkDirection.getDx(), coords.y + checkDirection.getDy(), coords.z + checkDirection.getDz());
            if (shipBlocks.getBlock((Coords)checkCoords).block != Blocks.field_150350_a) continue;
            ++numExposedBlocks;
        }
        return numExposedBlocks;
    }
}

