/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.propulsion;

import cuchaz.modsShared.blocks.BlockArray;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.BlocksStorage;
import cuchaz.ships.Ships;
import cuchaz.ships.propulsion.Paddle;
import cuchaz.ships.propulsion.PropulsionDiscoverer;
import cuchaz.ships.propulsion.PropulsionDiscovererRegistry;
import cuchaz.ships.propulsion.PropulsionMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Propulsion {
    private BlocksStorage m_blocksStorage;
    private Coords m_helmCoords;
    private BlockSide m_frontSide;
    private List<PropulsionMethod> m_methods;
    private Map<Class<? extends PropulsionMethod>, MethodCount> m_typeCounts;

    public Propulsion(BlocksStorage blocksStorage) {
        this.m_blocksStorage = blocksStorage;
        this.m_helmCoords = this.findHelm(this.m_blocksStorage);
        this.m_methods = new ArrayList<PropulsionMethod>();
        if (this.m_blocksStorage.getShipType().isPaddleable()) {
            this.m_methods.add(new Paddle());
            this.m_frontSide = null;
        } else if (this.m_helmCoords != null) {
            this.m_frontSide = BlockSide.getByXZOffset(this.m_blocksStorage.getBlock((Coords)this.m_helmCoords).meta);
            for (PropulsionDiscoverer discoverer : PropulsionDiscovererRegistry.discoverers()) {
                this.m_methods.addAll(discoverer.getPropulsionMethods(this.m_blocksStorage, this.m_frontSide));
            }
        } else {
            Ships.logger.warning("Non-paddleable ship doesn't have a helm! This wasn't supposed to happen, and will probably cause problems later!", new Object[0]);
        }
        this.m_typeCounts = new HashMap<Class<? extends PropulsionMethod>, MethodCount>();
        for (PropulsionMethod method : this.m_methods) {
            MethodCount count = this.m_typeCounts.get(method.getClass());
            if (count == null) {
                count = new MethodCount(method);
                this.m_typeCounts.put(method.getClass(), count);
            }
            count.m_numInstances++;
        }
    }

    public BlockSide getFrontSide() {
        return this.m_frontSide;
    }

    public BlockArray getEnevelope() {
        BlockArray envelope = this.m_blocksStorage.getGeometry().getEnvelopes().getEnvelope(BlockSide.Top).newEmptyCopy();
        for (PropulsionMethod method : this.m_methods) {
            for (Coords coords : method.getCoords()) {
                Coords oldCoords = envelope.getBlock(coords.x, coords.z);
                if (oldCoords != null && coords.y <= oldCoords.y) continue;
                envelope.setBlock(coords.x, coords.z, coords);
            }
        }
        return envelope;
    }

    public Iterable<PropulsionMethod> methods() {
        return this.m_methods;
    }

    public Iterable<MethodCount> methodCounts() {
        return this.m_typeCounts.values();
    }

    public double getTotalThrust(double speed) {
        double totalThrust = 0.0;
        for (PropulsionMethod method : this.m_methods) {
            totalThrust += method.getThrust(speed);
        }
        return totalThrust;
    }

    public String dumpMethods() {
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        for (MethodCount count : this.methodCounts()) {
            buf.append(delimiter);
            buf.append(count.toString());
            delimiter = ", ";
        }
        return buf.toString();
    }

    private Coords findHelm(BlocksStorage blocksStorage) {
        for (Coords coords : blocksStorage.coords()) {
            if (blocksStorage.getBlock((Coords)coords).block != Ships.m_blockHelm) continue;
            return coords;
        }
        return null;
    }

    public static class MethodCount {
        private int m_numInstances = 0;
        private String m_name;
        private String m_namePlural;

        public MethodCount(PropulsionMethod method) {
            this.m_name = method.getName();
            this.m_namePlural = method.getNamePlural();
        }

        public String getName() {
            if (this.m_numInstances == 1) {
                return this.m_name;
            }
            return this.m_namePlural;
        }

        public String toString() {
            return String.format("%d %s", this.m_numInstances, this.getName());
        }
    }
}

