/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.persistence;

import cuchaz.modsShared.blocks.BlockMap;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.BlocksStorage;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.persistence.BlockStoragePersistence;
import cuchaz.ships.persistence.CorruptedPersistence;
import cuchaz.ships.persistence.PersistenceException;
import cuchaz.ships.persistence.UnrecognizedPersistenceVersion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;

public enum ShipWorldPersistence {
    V1(1){

        @Override
        public ShipWorld onRead(World world, DataInputStream in) throws IOException, UnrecognizedPersistenceVersion {
            BlocksStorage storage = BlockStoragePersistence.readAnyVersion(in);
            BlockMap<TileEntity> tileEntities = new BlockMap<TileEntity>();
            int numTileEntities = in.readInt();
            for (int i = 0; i < numTileEntities; ++i) {
                NBTTagCompound nbt = CompressedStreamTools.func_74794_a((DataInputStream)in);
                TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)nbt);
                if (tileEntity == null) {
                    Ships.logger.warning("Unable to restore tile entity: " + nbt.func_74779_i("id"), new Object[0]);
                    continue;
                }
                Coords coords = new Coords(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                tileEntities.put(coords, tileEntity);
            }
            BlockMap<EntityHanging> hangingEntities = new BlockMap<EntityHanging>();
            int numHangingEntities = in.readInt();
            for (int i = 0; i < numHangingEntities; ++i) {
                NBTTagCompound nbt = CompressedStreamTools.func_74794_a((DataInputStream)in);
                EntityHanging hangingEntity = (EntityHanging)EntityList.func_75615_a((NBTTagCompound)nbt, (World)world);
                if (hangingEntity == null) {
                    Ships.logger.warning("Unable to restore hanging entity: " + nbt.func_74779_i("id"), new Object[0]);
                    continue;
                }
                Coords coords = new Coords(hangingEntity.field_146063_b, hangingEntity.field_146064_c, hangingEntity.field_146062_d);
                hangingEntities.put(coords, hangingEntity);
            }
            int biomeId = in.readInt();
            return new ShipWorld(world, storage, tileEntities, hangingEntities, biomeId);
        }

        @Override
        public void onWrite(ShipWorld shipWorld, DataOutputStream out) throws IOException {
            NBTTagCompound nbt;
            BlockStoragePersistence.V1.write(shipWorld.getBlocksStorage(), out);
            out.writeInt(shipWorld.tileEntities().size());
            for (TileEntity tileEntity : shipWorld.tileEntities().values()) {
                nbt = new NBTTagCompound();
                try {
                    tileEntity.func_145841_b(nbt);
                }
                catch (Throwable t) {
                    Ships.logger.warning(t, "Tile entity %s on a ship at (%d,%d,%d) did not behave during a save operation!", tileEntity.getClass().getName(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                }
                CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)out);
            }
            out.writeInt(shipWorld.hangingEntities().size());
            for (EntityHanging hangingEntity : shipWorld.hangingEntities().values()) {
                nbt = new NBTTagCompound();
                try {
                    hangingEntity.func_70039_c(nbt);
                }
                catch (Throwable t) {
                    Ships.logger.warning(t, "Hanging entity %s on a ship at (%d,%d,%d) did not behave during a save operation!", hangingEntity.getClass().getName(), hangingEntity.field_146063_b, hangingEntity.field_146064_c, hangingEntity.field_146062_d);
                }
                CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)out);
            }
            out.writeInt(shipWorld.getBiomeId());
        }
    };

    private static final String Encoding = "UTF-8";
    private static TreeMap<Integer, ShipWorldPersistence> m_versions;
    private int m_version;

    private ShipWorldPersistence(int version) {
        this.m_version = version;
    }

    protected abstract ShipWorld onRead(World var1, DataInputStream var2) throws IOException, UnrecognizedPersistenceVersion;

    protected abstract void onWrite(ShipWorld var1, DataOutputStream var2) throws IOException;

    private static ShipWorldPersistence get(int version) {
        return m_versions.get(version);
    }

    private static ShipWorldPersistence getNewestVersion() {
        return m_versions.lastEntry().getValue();
    }

    public static ShipWorld readAnyVersion(World world, String data) throws PersistenceException {
        try {
            DataInputStream in = new DataInputStream(new GZIPInputStream((InputStream)new Base64InputStream((InputStream)new ByteArrayInputStream(data.getBytes(Encoding)))));
            ShipWorld shipWorld = ShipWorldPersistence.readAnyVersion(world, in);
            in.close();
            return shipWorld;
        }
        catch (IOException ex) {
            throw new CorruptedPersistence(ex);
        }
    }

    public static ShipWorld readAnyVersion(World world, byte[] data) throws PersistenceException {
        return ShipWorldPersistence.readAnyVersion(world, data, false);
    }

    public static ShipWorld readAnyVersion(World world, byte[] data, boolean isCompressed) throws PersistenceException {
        if (isCompressed) {
            try {
                return ShipWorldPersistence.readAnyVersion(world, new GZIPInputStream(new ByteArrayInputStream(data)));
            }
            catch (IOException ex) {
                throw new CorruptedPersistence(ex);
            }
        }
        return ShipWorldPersistence.readAnyVersion(world, new ByteArrayInputStream(data));
    }

    private static ShipWorld readAnyVersion(World world, InputStream in) throws PersistenceException {
        try {
            DataInputStream din = new DataInputStream(in);
            byte version = din.readByte();
            ShipWorldPersistence persistence = ShipWorldPersistence.get(version);
            if (persistence == null) {
                throw new UnrecognizedPersistenceVersion(version);
            }
            return persistence.onRead(world, din);
        }
        catch (Exception ex) {
            throw new CorruptedPersistence(ex);
        }
    }

    public static String writeNewestVersionToString(ShipWorld shipWorld) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(new GZIPOutputStream((OutputStream)new Base64OutputStream((OutputStream)buffer)));
            ShipWorldPersistence.writeNewestVersion(shipWorld, out);
            out.close();
            return new String(buffer.toByteArray(), Encoding);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public static byte[] writeNewestVersion(ShipWorld shipWorld) {
        return ShipWorldPersistence.writeNewestVersion(shipWorld, false);
    }

    public static byte[] writeNewestVersion(ShipWorld shipWorld, boolean useCompression) {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            if (useCompression) {
                GZIPOutputStream gzipOut = new GZIPOutputStream(buf);
                ShipWorldPersistence.writeNewestVersion(shipWorld, gzipOut);
                gzipOut.finish();
            } else {
                ShipWorldPersistence.writeNewestVersion(shipWorld, buf);
            }
            return buf.toByteArray();
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public static void writeNewestVersion(ShipWorld shipWorld, OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        ShipWorldPersistence persistence = ShipWorldPersistence.getNewestVersion();
        dout.writeByte(persistence.m_version);
        persistence.onWrite(shipWorld, dout);
    }

    static {
        m_versions = new TreeMap();
        for (ShipWorldPersistence persistence : ShipWorldPersistence.values()) {
            m_versions.put(persistence.m_version, persistence);
        }
    }
}

