/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.persistence;

import cuchaz.ships.EntityShip;
import cuchaz.ships.persistence.PersistenceException;
import cuchaz.ships.persistence.ShipWorldPersistence;
import cuchaz.ships.persistence.UnrecognizedPersistenceVersion;
import java.util.TreeMap;
import net.minecraft.nbt.NBTTagCompound;

public enum ShipPersistence {
    V1(1){

        @Override
        public void read(EntityShip ship, NBTTagCompound nbt) throws PersistenceException {
            ship.setShipWorld(ShipWorldPersistence.readAnyVersion(ship.field_70170_p, nbt.func_74770_j("blocks")));
        }

        @Override
        public void write(EntityShip ship, NBTTagCompound nbt) {
            nbt.func_74773_a("blocks", ShipWorldPersistence.writeNewestVersion(ship.getShipWorld()));
        }
    }
    ,
    V2(2){

        @Override
        public void read(EntityShip ship, NBTTagCompound nbt) throws PersistenceException {
            ship.setShipWorld(ShipWorldPersistence.readAnyVersion(ship.field_70170_p, nbt.func_74770_j("blocks")));
            ship.getWaterDisplacer().read(nbt.func_74770_j("waterDisplacement"));
            ship.getRainDisplacer().read(nbt.func_74770_j("rainDisplacement"));
        }

        @Override
        public void write(EntityShip ship, NBTTagCompound nbt) {
            nbt.func_74773_a("blocks", ShipWorldPersistence.writeNewestVersion(ship.getShipWorld()));
            nbt.func_74773_a("waterDisplacement", ship.getWaterDisplacer().write());
            nbt.func_74773_a("rainDisplacement", ship.getRainDisplacer().write());
        }
    };

    private static TreeMap<Integer, ShipPersistence> m_versions;
    private int m_version;

    private ShipPersistence(int version) {
        this.m_version = version;
    }

    public abstract void read(EntityShip var1, NBTTagCompound var2) throws PersistenceException;

    public abstract void write(EntityShip var1, NBTTagCompound var2);

    private static ShipPersistence get(int version) {
        return m_versions.get(version);
    }

    private static ShipPersistence getNewestVersion() {
        return m_versions.lastEntry().getValue();
    }

    public static void readAnyVersion(EntityShip ship, NBTTagCompound nbt) throws PersistenceException {
        byte version = nbt.func_74771_c("version");
        ShipPersistence persistence = ShipPersistence.get(version);
        if (persistence == null) {
            throw new UnrecognizedPersistenceVersion(version);
        }
        persistence.read(ship, nbt);
    }

    public static void writeNewestVersion(EntityShip ship, NBTTagCompound nbt) {
        ShipPersistence persistence = ShipPersistence.getNewestVersion();
        nbt.func_74774_a("version", (byte)persistence.m_version);
        persistence.write(ship, nbt);
    }

    static {
        m_versions = new TreeMap();
        for (ShipPersistence persistence : ShipPersistence.values()) {
            m_versions.put(persistence.m_version, persistence);
        }
    }
}

