/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.persistence;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.Bits;
import cuchaz.ships.BlockStorage;
import cuchaz.ships.BlocksStorage;
import cuchaz.ships.Ships;
import cuchaz.ships.persistence.UnrecognizedPersistenceVersion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;

public enum BlockStoragePersistence {
    V1(1){

        @Override
        protected BlocksStorage onRead(DataInputStream in) throws IOException {
            TreeMap map = Maps.newTreeMap();
            int numMappings = in.readUnsignedShort();
            for (int i = 0; i < numMappings; ++i) {
                map.put(in.readUnsignedShort(), in.readUTF());
            }
            HashSet warnedBlocks = Sets.newHashSet();
            int numBlocks = in.readInt();
            BlocksStorage blocks = new BlocksStorage();
            for (int i = 0; i < numBlocks; ++i) {
                Coords coords = new Coords(in.readShort(), in.readShort(), in.readShort());
                int packed = in.readUnsignedShort();
                BlockStorage storage = new BlockStorage();
                storage.meta = Bits.unpackUnsigned(packed, 4, 12);
                String blockName = (String)map.get(Bits.unpackUnsigned(packed, 12, 0));
                storage.block = (Block)Block.field_149771_c.func_82594_a(blockName);
                if (storage.block == null) {
                    if (!warnedBlocks.contains(blockName)) {
                        Ships.logger.warning("Can't find block %s on this server! Block has been replaced with wood planks", blockName);
                        warnedBlocks.add(blockName);
                    }
                    storage.block = Blocks.field_150344_f;
                }
                blocks.setBlock(coords, storage);
            }
            return blocks;
        }

        @Override
        protected void onWrite(BlocksStorage blocks, DataOutputStream out) throws IOException {
            Object block;
            TreeMap map = Maps.newTreeMap();
            for (Coords coords : blocks.coords()) {
                block = blocks.getBlock((Coords)coords).block;
                map.put(Block.func_149682_b((Block)block), Block.field_149771_c.func_148750_c(block));
            }
            out.writeShort(map.size());
            for (Map.Entry entry : map.entrySet()) {
                out.writeShort((Integer)entry.getKey());
                out.writeUTF((String)entry.getValue());
            }
            out.writeInt(blocks.getNumBlocks());
            for (Coords coords : blocks.coords()) {
                out.writeShort(coords.x);
                out.writeShort(coords.y);
                out.writeShort(coords.z);
                block = blocks.getBlock(coords);
                out.writeShort(Bits.packUnsigned(Block.func_149682_b((Block)block.block), 12, 0) | Bits.packUnsigned(block.meta, 4, 12));
            }
        }
    };

    private static final String Encoding = "UTF-8";
    private static TreeMap<Integer, BlockStoragePersistence> m_versions;
    private int m_version;

    private BlockStoragePersistence(int version) {
        this.m_version = version;
    }

    protected abstract BlocksStorage onRead(DataInputStream var1) throws IOException;

    protected abstract void onWrite(BlocksStorage var1, DataOutputStream var2) throws IOException;

    private static BlockStoragePersistence get(int version) {
        return m_versions.get(version);
    }

    private static BlockStoragePersistence getNewestVersion() {
        return m_versions.lastEntry().getValue();
    }

    public static BlocksStorage readAnyVersion(String data) throws UnrecognizedPersistenceVersion {
        try {
            DataInputStream in = new DataInputStream(new GZIPInputStream((InputStream)new Base64InputStream((InputStream)new ByteArrayInputStream(data.getBytes(Encoding)))));
            BlocksStorage blocks = BlockStoragePersistence.readAnyVersion(in);
            in.close();
            return blocks;
        }
        catch (IOException ex) {
            throw new UnrecognizedPersistenceVersion();
        }
    }

    public static BlocksStorage readAnyVersion(byte[] data) throws UnrecognizedPersistenceVersion {
        try {
            return BlockStoragePersistence.readAnyVersion(new ByteArrayInputStream(data));
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public static BlocksStorage readAnyVersion(InputStream in) throws IOException, UnrecognizedPersistenceVersion {
        DataInputStream din = new DataInputStream(in);
        byte version = din.readByte();
        BlockStoragePersistence persistence = BlockStoragePersistence.get(version);
        if (persistence == null) {
            throw new UnrecognizedPersistenceVersion(version);
        }
        return persistence.onRead(din);
    }

    public static String writeNewestVersionToString(BlocksStorage blocks) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(new GZIPOutputStream((OutputStream)new Base64OutputStream((OutputStream)buffer)));
            BlockStoragePersistence.writeNewestVersion(blocks, out);
            out.close();
            return new String(buffer.toByteArray(), Encoding);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public static byte[] writeNewestVersion(BlocksStorage blocks) {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            BlockStoragePersistence.writeNewestVersion(blocks, buf);
            return buf.toByteArray();
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public static void writeNewestVersion(BlocksStorage blocks, OutputStream out) throws IOException {
        BlockStoragePersistence.getNewestVersion().write(blocks, out);
    }

    public void write(BlocksStorage blocks, OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeByte(this.m_version);
        this.onWrite(blocks, dout);
    }

    static {
        m_versions = new TreeMap();
        for (BlockStoragePersistence persistence : BlockStoragePersistence.values()) {
            m_versions.put(persistence.m_version, persistence);
        }
    }
}

