/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cuchaz.modsShared.net.Packet;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.ShipUnlauncher;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.NetHandlerPlayServer;

public class PacketUnlaunchShip
extends Packet<PacketUnlaunchShip> {
    private int m_entityId;

    public PacketUnlaunchShip() {
    }

    public PacketUnlaunchShip(int entityId) {
        this.m_entityId = entityId;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.m_entityId);
    }

    public void fromBytes(ByteBuf buf) {
        this.m_entityId = buf.readInt();
    }

    @Override
    public IMessageHandler<PacketUnlaunchShip, IMessage> getServerHandler() {
        return new IMessageHandler<PacketUnlaunchShip, IMessage>(){

            public IMessage onMessage(PacketUnlaunchShip message, MessageContext ctx) {
                return message.onReceivedServer(ctx.getServerHandler());
            }
        };
    }

    private IMessage onReceivedServer(NetHandlerPlayServer netServer) {
        EntityShip ship = ShipLocator.getShip(netServer.field_147369_b.field_70170_p, this.m_entityId);
        if (ship == null) {
            return null;
        }
        ShipUnlauncher unlauncher = new ShipUnlauncher(ship);
        if (unlauncher.isUnlaunchable(true)) {
            unlauncher.unlaunch();
        }
        return null;
    }
}

