/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.modsShared.net.Packet;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLauncher;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.persistence.PersistenceException;
import cuchaz.ships.persistence.ShipWorldPersistence;
import io.netty.buffer.ByteBuf;
import java.util.TreeMap;
import net.minecraft.client.network.NetHandlerPlayClient;

public class PacketShipLaunched
extends Packet<PacketShipLaunched> {
    private int m_entityId;
    private byte[] m_shipData;
    private int m_launchX;
    private int m_launchY;
    private int m_launchZ;
    public static PacketShipLaunched instance = null;
    private TreeMap<Integer, PacketShipLaunched> m_packets;

    public PacketShipLaunched() {
        this.m_packets = new TreeMap();
        instance = this;
    }

    public PacketShipLaunched(EntityShip ship, Coords shipBlock) {
        this.m_entityId = ship.func_145782_y();
        this.m_shipData = ShipWorldPersistence.writeNewestVersion(ship.getShipWorld(), true);
        this.m_launchX = shipBlock.x;
        this.m_launchY = shipBlock.y;
        this.m_launchZ = shipBlock.z;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.m_entityId);
        buf.writeInt(this.m_shipData.length);
        buf.writeBytes(this.m_shipData);
        buf.writeInt(this.m_launchX);
        buf.writeInt(this.m_launchY);
        buf.writeInt(this.m_launchZ);
    }

    public void fromBytes(ByteBuf buf) {
        this.m_entityId = buf.readInt();
        this.m_shipData = new byte[buf.readInt()];
        buf.readBytes(this.m_shipData);
        this.m_launchX = buf.readInt();
        this.m_launchY = buf.readInt();
        this.m_launchZ = buf.readInt();
    }

    @Override
    public IMessageHandler<PacketShipLaunched, IMessage> getClientHandler() {
        return new IMessageHandler<PacketShipLaunched, IMessage>(){

            public IMessage onMessage(PacketShipLaunched message, MessageContext ctx) {
                return message.onReceivedClient(ctx.getClientHandler());
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    private IMessage onReceivedClient(NetHandlerPlayClient netClient) {
        this.m_packets.put(this.m_entityId, this);
        return null;
    }

    public PacketShipLaunched getPacket(EntityShip ship) {
        PacketShipLaunched packet = this.m_packets.get(ship.func_145782_y());
        if (packet != null) {
            this.m_packets.remove(ship.func_145782_y());
        }
        return packet;
    }

    public void process(EntityShip ship) {
        try {
            ShipWorld shipWorld = ShipWorldPersistence.readAnyVersion(ship.field_70170_p, this.m_shipData, true);
            ShipLauncher.initShip(ship, shipWorld, new Coords(this.m_launchX, this.m_launchY, this.m_launchZ));
        }
        catch (PersistenceException ex) {
            Ships.logger.warning(ex, "Unable to read ship! Ship will be removed from world", new Object[0]);
            ship.func_70106_y();
        }
    }
}

