/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.net.Packet;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.Ships;
import cuchaz.ships.persistence.PersistenceException;
import cuchaz.ships.persistence.ShipWorldPersistence;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.world.World;

public class PacketShipBlocks
extends Packet<PacketShipBlocks> {
    private int m_entityId;
    private byte[] m_shipData;

    public PacketShipBlocks() {
    }

    public PacketShipBlocks(EntityShip ship) {
        this.m_entityId = ship.func_145782_y();
        this.m_shipData = ShipWorldPersistence.writeNewestVersion(ship.getShipWorld(), true);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.m_entityId);
        buf.writeInt(this.m_shipData.length);
        buf.writeBytes(this.m_shipData);
    }

    public void fromBytes(ByteBuf buf) {
        this.m_entityId = buf.readInt();
        this.m_shipData = new byte[buf.readInt()];
        buf.readBytes(this.m_shipData);
    }

    @Override
    public IMessageHandler<PacketShipBlocks, IMessage> getClientHandler() {
        return new IMessageHandler<PacketShipBlocks, IMessage>(){

            public IMessage onMessage(PacketShipBlocks message, MessageContext ctx) {
                return message.onReceivedClient(ctx.getClientHandler());
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    private IMessage onReceivedClient(NetHandlerPlayClient netClient) {
        EntityShip ship = ShipLocator.getShip((World)Minecraft.func_71410_x().field_71441_e, this.m_entityId);
        if (ship == null) {
            return null;
        }
        if (ship.getShipWorld() == null) {
            try {
                ship.setShipWorld(ShipWorldPersistence.readAnyVersion(ship.field_70170_p, this.m_shipData, true));
            }
            catch (PersistenceException ex) {
                Ships.logger.warning(ex, "Unable to read ship! Ship will be removed from world", new Object[0]);
                ship.func_70106_y();
            }
        }
        return null;
    }
}

