/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.net.Packet;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLocator;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.world.World;

public class PacketShipBlockEvent
extends Packet<PacketShipBlockEvent> {
    private int m_entityId;
    private int m_x;
    private int m_y;
    private int m_z;
    private int m_blockId;
    private int m_eventId;
    private int m_eventParam;

    public PacketShipBlockEvent() {
    }

    public PacketShipBlockEvent(int entityId, int x, int y, int z, Block block, int eventId, int eventParam) {
        this.m_entityId = entityId;
        this.m_x = x;
        this.m_y = y;
        this.m_z = z;
        this.m_blockId = Block.func_149682_b((Block)block);
        this.m_eventId = eventId;
        this.m_eventParam = eventParam;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.m_entityId);
        buf.writeInt(this.m_x);
        buf.writeInt(this.m_y);
        buf.writeInt(this.m_z);
        buf.writeInt(this.m_blockId);
        buf.writeInt(this.m_eventId);
        buf.writeInt(this.m_eventParam);
    }

    public void fromBytes(ByteBuf buf) {
        this.m_entityId = buf.readInt();
        this.m_x = buf.readInt();
        this.m_y = buf.readInt();
        this.m_z = buf.readInt();
        this.m_blockId = buf.readInt();
        this.m_eventId = buf.readInt();
        this.m_eventParam = buf.readInt();
    }

    @Override
    public IMessageHandler<PacketShipBlockEvent, IMessage> getClientHandler() {
        return new IMessageHandler<PacketShipBlockEvent, IMessage>(){

            public IMessage onMessage(PacketShipBlockEvent message, MessageContext ctx) {
                return message.onReceivedClient(ctx.getClientHandler());
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    private IMessage onReceivedClient(NetHandlerPlayClient netClient) {
        EntityShip ship = ShipLocator.getShip((World)Minecraft.func_71410_x().field_71441_e, this.m_entityId);
        if (ship == null || ship.getShipWorld() == null) {
            return null;
        }
        Block block = Block.func_149729_e((int)this.m_blockId);
        if (ship.getShipWorld().func_147439_a(this.m_x, this.m_y, this.m_z) == block) {
            block.func_149696_a((World)ship.getShipWorld(), this.m_x, this.m_y, this.m_z, this.m_eventId, this.m_eventParam);
        }
        return null;
    }
}

