/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cuchaz.ships.packets.Packet;
import cuchaz.ships.packets.PacketBlockPropertiesOverrides;
import cuchaz.ships.packets.PacketChangedBlocks;
import cuchaz.ships.packets.PacketEraseShip;
import cuchaz.ships.packets.PacketLaunchShip;
import cuchaz.ships.packets.PacketPasteShip;
import cuchaz.ships.packets.PacketPilotShip;
import cuchaz.ships.packets.PacketPlaceProjector;
import cuchaz.ships.packets.PacketPlayerSleepInBerth;
import cuchaz.ships.packets.PacketRequestShipBlocks;
import cuchaz.ships.packets.PacketShipBlockEvent;
import cuchaz.ships.packets.PacketShipBlocks;
import cuchaz.ships.packets.PacketShipLaunched;
import cuchaz.ships.packets.PacketShipPlaque;
import cuchaz.ships.packets.PacketUnlaunchShip;

public class PacketRegistry {
    private SimpleNetworkWrapper m_network;
    private int m_nextId = 0;

    public PacketRegistry(String modId) {
        this.m_network = NetworkRegistry.INSTANCE.newSimpleChannel(modId);
        this.register(new PacketLaunchShip());
        this.register(new PacketShipLaunched());
        this.register(new PacketUnlaunchShip());
        this.register(new PacketRequestShipBlocks());
        this.register(new PacketShipBlocks());
        this.register(new PacketPilotShip());
        this.register(new PacketShipBlockEvent());
        this.register(new PacketChangedBlocks());
        this.register(new PacketPasteShip());
        this.register(new PacketEraseShip());
        this.register(new PacketShipPlaque());
        this.register(new PacketPlayerSleepInBerth());
        this.register(new PacketBlockPropertiesOverrides());
        this.register(new PacketPlaceProjector());
    }

    private <T extends Packet<T>> void register(T packet) {
        IMessageHandler<T, IMessage> serverHandler;
        Class<?> c = packet.getClass();
        IMessageHandler<T, IMessage> clientHandler = packet.getClientHandler();
        if (clientHandler != null) {
            this.m_network.registerMessage(clientHandler, c, this.m_nextId, Side.CLIENT);
        }
        if ((serverHandler = packet.getServerHandler()) != null) {
            this.m_network.registerMessage(serverHandler, c, this.m_nextId, Side.SERVER);
        }
        ++this.m_nextId;
    }

    public SimpleNetworkWrapper getDispatch() {
        return this.m_network;
    }
}

