/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.net.Packet;
import cuchaz.ships.EntityShip;
import cuchaz.ships.PlayerRespawner;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.ShipWorld;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PacketPlayerSleepInBerth
extends Packet<PacketPlayerSleepInBerth> {
    private static final int NotAShip = -1;
    private int m_playerEntityId;
    private int m_shipEntityId;
    private int m_x;
    private int m_y;
    private int m_z;

    public PacketPlayerSleepInBerth() {
    }

    public PacketPlayerSleepInBerth(EntityPlayer player, World world, int x, int y, int z) {
        this.m_playerEntityId = player.func_145782_y();
        this.m_shipEntityId = -1;
        this.m_x = x;
        this.m_y = y;
        this.m_z = z;
        if (world instanceof ShipWorld) {
            EntityShip ship = ((ShipWorld)world).getShip();
            this.m_shipEntityId = ship.func_145782_y();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.m_playerEntityId);
        buf.writeInt(this.m_shipEntityId);
        buf.writeInt(this.m_x);
        buf.writeInt(this.m_y);
        buf.writeInt(this.m_z);
    }

    public void fromBytes(ByteBuf buf) {
        this.m_playerEntityId = buf.readInt();
        this.m_shipEntityId = buf.readInt();
        this.m_x = buf.readInt();
        this.m_y = buf.readInt();
        this.m_z = buf.readInt();
    }

    @Override
    public IMessageHandler<PacketPlayerSleepInBerth, IMessage> getClientHandler() {
        return new IMessageHandler<PacketPlayerSleepInBerth, IMessage>(){

            public IMessage onMessage(PacketPlayerSleepInBerth message, MessageContext ctx) {
                return message.onReceivedClient(ctx.getClientHandler());
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    private IMessage onReceivedClient(NetHandlerPlayClient netClient) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(this.m_playerEntityId);
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer sleepingPlayer = (EntityPlayer)entity;
        if (this.m_shipEntityId == -1) {
            PlayerRespawner.sleepInBerthAt((World)world, this.m_x, this.m_y, this.m_z, sleepingPlayer);
        } else {
            EntityShip ship = ShipLocator.getShip((World)world, this.m_shipEntityId);
            if (ship == null) {
                return null;
            }
            PlayerRespawner.sleepInBerthAt(ship.getShipWorld(), this.m_x, this.m_y, this.m_z, sleepingPlayer);
        }
        return null;
    }
}

