/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cuchaz.modsShared.net.Packet;
import cuchaz.ships.ShipClipboard;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.items.ItemProjector;
import cuchaz.ships.persistence.PersistenceException;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import org.apache.commons.codec.binary.Base64;

public class PacketPlaceProjector
extends Packet<PacketPlaceProjector> {
    private byte[] m_encodedBlocks;
    private int m_x;
    private int m_y;
    private int m_z;

    public PacketPlaceProjector() {
    }

    public PacketPlaceProjector(String encodedBlocks, int x, int y, int z) {
        this.m_encodedBlocks = Base64.decodeBase64((String)encodedBlocks);
        if (this.m_encodedBlocks.length > 0x100000) {
            throw new IllegalArgumentException("Ship description size exceeds 1048576 bytes. If this is a legitimate use, we need a bigger size");
        }
        this.m_x = x;
        this.m_y = y;
        this.m_z = z;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.m_encodedBlocks.length);
        buf.writeBytes(this.m_encodedBlocks);
        buf.writeInt(this.m_x);
        buf.writeInt(this.m_y);
        buf.writeInt(this.m_z);
    }

    public void fromBytes(ByteBuf buf) {
        int dataSize = buf.readInt();
        if (dataSize <= 0x100000) {
            this.m_encodedBlocks = new byte[dataSize];
            buf.readBytes(this.m_encodedBlocks);
        }
        this.m_x = buf.readInt();
        this.m_y = buf.readInt();
        this.m_z = buf.readInt();
    }

    @Override
    public IMessageHandler<PacketPlaceProjector, IMessage> getServerHandler() {
        return new IMessageHandler<PacketPlaceProjector, IMessage>(){

            public IMessage onMessage(PacketPlaceProjector message, MessageContext ctx) {
                return message.onReceivedServer(ctx.getServerHandler());
            }
        };
    }

    private IMessage onReceivedServer(NetHandlerPlayServer netServer) {
        if (this.m_encodedBlocks == null) {
            return null;
        }
        try {
            ItemStack heldItem;
            ShipWorld shipWorld = ShipClipboard.createShipWorld(netServer.field_147369_b.field_70170_p, Base64.encodeBase64String((byte[])this.m_encodedBlocks));
            ItemProjector.placeProjector(netServer.field_147369_b.field_70170_p, this.m_x, this.m_y, this.m_z, shipWorld);
            if (!netServer.field_147369_b.field_71075_bZ.field_75098_d && (heldItem = netServer.field_147369_b.func_70694_bm()).func_77973_b() == Ships.m_itemProjector) {
                --heldItem.field_77994_a;
                if (heldItem.field_77994_a <= 0) {
                    netServer.field_147369_b.field_71071_by.field_70462_a[netServer.field_147369_b.field_71071_by.field_70461_c] = null;
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent((EntityPlayer)netServer.field_147369_b, heldItem));
                }
            }
        }
        catch (PersistenceException ex) {
            Ships.logger.error(ex, "Unable to place ship projector!", new Object[0]);
        }
        return null;
    }
}

